<?php

class My_Elementor_Widgets {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widgets/services.php');
		require_once('widgets/products.php');
		require_once('widgets/products-grid.php');
		require_once('widgets/timed-products.php');
		require_once('widgets/posts.php');
		require_once('widgets/posts-grid.php');
		require_once('widgets/special-offer.php');
		require_once('widgets/ads-image.php');
		require_once('widgets/logo-slider.php');
		require_once('widgets/slider.php');
		require_once('widgets/daily-slider.php');
		require_once('widgets/offer.php');
		require_once('widgets/text-box.php');
		require_once('widgets/daily-discount.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Our_Service_Box() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Dina_Woo_Products() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Dina_Woo_Products_Grid() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Dina_Timed_Products() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Dina_Dialy_Discount() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Dina_Blog_Posts() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Dina_Blog_Posts_Grid() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Special_Offer() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Ads_Image() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Logo_Slider() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Slider() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Dina_Daily_Slider() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Dina_Woo_Offer() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Text_Box() );
	}

}

add_action( 'init', 'my_elementor_init' );
function my_elementor_init() {
	My_Elementor_Widgets::get_instance();
}

function add_elementor_widget_categories( $elements_manager ) {

	$elements_manager->add_category(
		'dina-kala',
		[
			'title' => __( 'DinaKala', 'dina-kala' ),
			'icon' => 'fa fa-plug',
		]
	);

}
add_action( 'elementor/elements/categories_registered', 'add_elementor_widget_categories' );

//Disable Elementor Google Fonts
add_filter( 'elementor/frontend/print_google_fonts', '__return_false' );