<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: Hosseinkhani.ir
*/
// Exit if accessed directly

global $product;
global $di_data;
$in_stock = $product->is_in_stock(); ?>

<div class="<?php echo dina_mini_product_classes($product->get_id()); ?>">
	<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="product-link">
		<?php pr_img() ?>
		<?php if($in_stock && $product->is_on_sale()) { ?>
		<?php echo dina_dis_price(get_the_ID()); ?>
		<?php } ?>
		<?php dina_product_label(get_the_ID()); ?>
		<span class="product-title">
			<?php the_title(); ?>
		</span>
		<span class="product-price">
			<span class="price-con">
				<?php if($in_stock || $di_data['show_price_out']) { ?>
					<?php echo $product->get_price_html(); ?>
				<?php } else { ?>
					<?php _e( 'Out of stock', 'dina-kala' ); ?>
				<?php } ?>
			</span>
		</span>
	</a>

	<?php
	dina_prod_hover($product->get_id());
	dina_add_to_cart($product);
	dina_product_rating($product->get_id());
	if( class_exists( 'WeDevs_Dokan' ) && $di_data['show_product_vendor_archive'] ) {
	dina_get_product_vendor($product->get_id());
	}
	?>
</div>