<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: Hosseinkhani.ir
*/
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
global $di_data;
dfile_scheck();
if (!current_user_can('administrator'))
	{
	if ($di_data['maintenance'])
		{
		get_template_part('under-page');
		die();
		}
	}
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

    <head>
        <link rel="shortcut icon" href="<?php echo $di_data['site_favicon']['url']; ?>" type="image/x-icon" />
        <meta http-equiv="Content-Type" content="text/html; charset=<?php bloginfo('charset'); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <?php if(!$di_data['dis_mobile_color']) { ?>
        <meta name="theme-color" content="<?php echo $di_data['custom_color']; ?>" />
        <?php } ?>
        <meta name="fontiran.com:license" content="B3L8B">
        <?php if (is_singular()) { wp_enqueue_script('comment-reply'); } ?>
        <link rel="alternate" type="appliction/rss+xml" href="<?php bloginfo('rss2_url'); ?>" title="<?php printf(__('Latest Articles %s', 'dina-kala') , esc_html(get_bloginfo('name') , 1)); ?>" />
        <link rel="alternate" type="appliction/rss+xml" href="<?php bloginfo('comments_rss2_url'); ?>" title="<?php printf(__('Last comments %s', 'dina-kala') , esc_html(get_bloginfo('name') , 1)); ?>" />
        <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
        <?php wp_head(); ?>
    </head>
    
    <?php $open_cat = ($di_data['open_cat_widget'] ? 'dina-open-cat' : ''); ?>
    <body <?php body_class($open_cat); ?> <?php if($di_data['site_schema']) {?>itemscope itemtype="https://schema.org/WebPage"
    <?php } ?>>

    <?php if ($di_data['show_page_loading']) { ?>
    <!-- Page Loading -->
    <div class="se-pre-con"></div>
    <?php } ?>

        <?php if(!$di_data['hide_mobile_bar']) { ?>
        <?php $mftitle = $di_data['mobile_bar_title']; ?>
        <div class="mobile-footer">
            <ul>
                <?php if(dina_check_side() == 2) { ?>            
                <li class="open-side" onclick="openSide()">
                    <span aria-hidden="true" class="fal fa-filter f-icon" title="<?php _e('Show filters', 'dina-kala'); ?>"></span>
                    <?php if(!$mftitle) { ?>
                        <span class="mf-title"><?php _e('Filters', 'dina-kala'); ?></span>
                    <?php } ?>
                </li>
                <?php } elseif(dina_check_side() == 1) { ?>
                <li class="open-side" onclick="openSide()">
                    <span aria-hidden="true" class="fal fa-ellipsis-h f-icon" title="<?php _e('Show sidebar', 'dina-kala'); ?>">
                    </span>
                    <?php if(!$mftitle) { ?>
                        <span class="mf-title"><?php _e('Sidebar', 'dina-kala'); ?></span>
                    <?php } ?>
                </li>
                <?php } else { ?>
                    <?php if(!$di_data['ch_back_top_btn']) { ?>
                        <li class="return-top">
                            <span aria-hidden="true" class="fal fa-chevron-up f-icon" title="<?php echo __('Return Top', 'dina-kala'); ?>">
                            </span>
                            <?php if(!$mftitle) { ?>
                                <span class="mf-title"><?php echo __('Return', 'dina-kala'); ?></span>
                            <?php } ?>
                        </li>
                    <?php } else { ?>
                        <li>
                            <a href="<?php echo $di_data['back_top_btn_link']; ?>" title="<?php echo $di_data['back_top_btn_title']; ?>">
                                <span aria-hidden="true" class="f-icon <?php echo $di_data['back_top_btn_icon']; ?>" title="<?php echo $di_data['back_top_btn_title']; ?>">
                                </span>
                                <?php if(!$mftitle) { ?>
                                    <span class="mf-title"><?php echo $di_data['back_top_btn_title']; ?></span>
                                <?php } ?>
                            </a>
                        </li>
                    <?php } 
                } ?>

                <?php if(!$di_data['ch_whish_btn']) { ?>
                <?php if($di_data['show_wish_list'] && class_exists( 'JVM_WooCommerce_Wishlist' )) {
                    $wish_url = jvm_get_wishlist_url();
                    $wish_count = jvm_woocommerce_wishlist_get_count(); ?>
                <li>
                    <a href="<?php echo $wish_url; ?>" title="<?php _e('Wishlist', 'dina-kala'); ?>"  rel="nofollow">
                        <span aria-hidden="true" class="fal fa-heart f-icon" title="<?php _e('Wishlist', 'dina-kala'); ?>">
                            <span class="wish-amount">
                                <?php echo $wish_count; ?>
                            </span>
                        </span>
                        <?php if(!$mftitle) { ?>
                            <span class="mf-title"><?php _e('Wishlist ', 'dina-kala'); ?></span>
                        <?php } ?>
                    </a>
                </li>
                <?php } ?>
                <?php } else { ?>
                <li>
                    <a href="<?php echo $di_data['whish_btn_link']; ?>" title="<?php echo $di_data['whish_btn_title']; ?>">
                        <span aria-hidden="true" class="f-icon <?php echo $di_data['whish_btn_icon']; ?>" title="<?php echo $di_data['whish_btn_title']; ?>">
                        </span>
                        <?php if(!$mftitle) { ?>
                            <span class="mf-title"><?php echo $di_data['whish_btn_title']; ?></span>
                        <?php } ?>
                    </a>
                </li>
                <?php } ?>

                <?php global $post; if(is_singular('product')) { ?>
                <li class="go-to-add">
                    <span aria-hidden="true" class="fal fa-cart-plus f-icon" title="<?php _e('Add to cart', 'dina-kala'); ?>">
                    </span>
                    <?php if(!$mftitle) { ?>
                        <span class="mf-title"><?php _e('Buy', 'dina-kala'); ?></span>
                    <?php } ?>
                </li>
                <?php } else { ?>
                <li>
                    <a href="<?php echo esc_url(home_url()); ?>" title="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>">
                        <span aria-hidden="true" class="fal fa-home f-icon" title="<?php _e('Home', 'dina-kala'); ?>">
                        </span>
                        <?php if(!$mftitle) { ?>
                            <span class="mf-title"><?php _e('Home', 'dina-kala'); ?></span>
                        <?php } ?>
                    </a>
                </li>
                <?php } ?>
                
                <?php if(!$di_data['ch_compare_btn']) { ?>
                <?php 
                if ( defined( 'WCCM_VERISON' ) ) {
                $compare_url = wccm_get_compare_page_link( wccm_get_compare_list() );
                $compare_count = count(wccm_get_compare_list()); ?>
                <li>
                    <a href="<?php echo $compare_url; ?>" class="compare-link" rel="nofollow" title="<?php _e('Compare ', 'dina-kala'); ?>">
                        <span aria-hidden="true" class="fal fa-random f-icon">
                            <span class="compare-amount"><?php echo $compare_count; ?></span>
                        </span>
                        <?php if(!$mftitle) { ?>
                            <span class="mf-title"><?php _e('Compare ', 'dina-kala'); ?></span>
                        <?php } ?>
                    </a>
                </li>
                <?php } ?>
                <?php } else { ?>
                <li>
                    <a href="<?php echo $di_data['compare_btn_link']; ?>" title="<?php echo $di_data['compare_btn_title']; ?>">
                        <span aria-hidden="true" class="f-icon <?php echo $di_data['compare_btn_icon']; ?>"></span>
                        <?php if(!$mftitle) { ?>
                            <span class="mf-title"><?php echo $di_data['compare_btn_title']; ?></span>
                        <?php } ?>
                    </a>
                </li>
                <?php } ?>


                <li onclick="openCart()">
                    <span aria-hidden="true" class="fal fa-shopping-bag f-icon" title="<?php _e('Shopping Cart', 'dina-kala'); ?>">
                        <span class="cart-amount"><?php echo WC()->cart->get_cart_contents_count(); ?></span>
                    </span>
                    <?php if(!$mftitle) { ?>
                    <span class="mf-title"><?php _e('Cart', 'dina-kala'); ?></span>
                    <?php } ?>
                </li>

            </ul>
        </div>
        <?php } elseif(is_singular('product')) { ?>
            <div class="btn btn-success go-to-add" title="<?php _e('Add to cart', 'dina-kala'); ?>">
                <i aria-hidden="true" class="fal fa-cart-plus"></i>
                <?php _e('Add to cart', 'dina-kala'); ?>
            </div>
        <?php } ?>

        <?php if($di_data['show_alert_app']) { ?>
        <div class="alert alert-dark alert-app alert-dismissible fade show" role="alert">
            <button type="button" class="alert-app-close close" data-dismiss="alert" aria-label="Close">
                <i class="fal fa-times" aria-hidden="true"></i>
            </button>
            <span class="alert-app-title">
                <?php echo $di_data['alert_app_title']; ?>
            </span>
            <?php if($di_data['and_link'] != '') { ?>
                <a href="<?php echo $di_data['and_link']; ?>" rel="nofollow" class="btn btn-success and-btn"><i class="fab fa-android" aria-hidden="true"></i><?php _e(' Android' , 'dina-kala'); ?></a>
                <?php } ?>
                <?php if($di_data['ios_link'] != '') { ?>
                <a href="<?php echo $di_data['ios_link']; ?>" rel="nofollow" class="btn btn-secondary ios-btn"><i class="fab fa-apple" aria-hidden="true"></i> <?php _e(' IOS' , 'dina-kala'); ?></a>
            <?php } ?>
        </div>
        <?php } ?>
    
    <header class="site-header<?php if(!$di_data['show_bread']) { echo ' no-bread'; }  ?>" <?php if($di_data['site_schema'] ) {?>itemscope itemtype="https://schema.org/Organization" <?php } ?>>
    <?php if($di_data['site_schema']) { echo '<meta itemprop="url" content="'.esc_url(home_url()).'">'; } ?>
    <?php if($di_data['site_schema']) { echo '<meta itemprop="name" content="'.esc_html(get_bloginfo('name')).'">'; } ?>
    <?php if($di_data['show_msg']) { ?>
    <!-- Header Massage Div -->
    <?php if($di_data['show_img_msg']) { ?>
        <aside class="head-img-msg-con">
            <a href="<?php echo $di_data['img_msg_link']; ?>" class="head-img-msg" target="_blank" style="background-image: url(<?php echo $di_data['img_msg_image']['url']; ?>)" title="<?php echo $di_data['img_msg_title']; ?>"></a>
        </aside>
    <?php } else { ?>
    <div class="container-fluid head-msg">
        <div class="container">
            <div class="row">
                <div class="col-12 col-md-10 msg-text">
                    <i aria-hidden="true" class="fal <?php echo $di_data['msg_icon']; ?> msg-icon"></i>
                    <?php echo $di_data['site_msg']; ?>
                </div>
                <?php if($di_data['msg_btn']) { ?>
                <div class="col-12 col-md-2">
                    <a class="btn <?php echo $di_data['msg_btn_color']; ?> msg-btn" href="<?php echo $di_data['msg_btn_link']; ?>" title="<?php echo $di_data['msg_btn_text']; ?>">
                        <?php echo $di_data['msg_btn_text']; ?>
                        <i class="fal fa-arrow-left" aria-hidden="true"></i>
                    </a>
                </div>
                <?php } ?>
            </div>
        </div>
        <?php if($di_data['user_close']) { ?>
        <i class="fal fa-times msg-close" aria-hidden="true"></i>
        <?php } ?>
    </div>
    <?php } ?>
    <!-- Header Massage Div -->
    <?php } ?>

    <!-- Header Div -->
    <div class="container-fluid header<?php if($di_data['fixed_head_mobile']) {echo ' fixed-mobile';} ?>">
        <div class="container">
            
            <?php if(!$di_data['hide_top_bar']) { ?>
            <div class="row head-mc<?php if ($di_data['head_pos'] == 2) {echo ' left-head';} ?>">

                <!-- Header Menu -->
                <nav class="col-md-6 head-menu <?php if ($di_data['mobile_head_menu']) {echo ' visible-mobile';} ?>" <?php if($di_data['site_schema']) {?>itemscope itemtype="https://schema.org/SiteNavigationElement" <?php } ?>>
                    <?php
                    if (has_nav_menu('header')) {
                        wp_nav_menu( array(
                            'menu'              => 'header',
                            'theme_location'    => 'header',
                            'depth'             => 1,
                            'container'         => 'div'
                            )
                        );
                    }
                    ?>
                </nav>
                <!-- Header Menu -->
                
                <?php if($di_data['show_contact'] && !$di_data['show_head_social']) { ?>
                <!-- Header Contact -->
                <div class="col-md-6 head-contact">
                    <div class="head-phone" <?php if($di_data['site_schema']) {?>itemprop="telephone"<?php } ?>>
                        <a href="tel:<?php echo dina_remove_dash($di_data['site_tel']); ?>" target="_blank">
                            <i class="fal fa-phone" aria-hidden="true"></i>
                            <?php echo $di_data['site_tel']; ?>
                        </a>
                    </div>
                    <?php if($di_data['replace_email']) { ?>
                        <div class="head-phone" <?php if($di_data['site_schema']) {?>itemprop="telephone"<?php } ?>>
                            <a href="tel:<?php echo dina_remove_dash($di_data['site_tel2']); ?>" target="_blank">
                                <i class="fal fa-phone-rotary" aria-hidden="true"></i>
                                <?php echo $di_data['site_tel2']; ?>
                            </a>
                        </div>
                    <?php } else { ?>
                        <div class="head-email" <?php if($di_data['site_schema']) {?>itemprop="email"<?php } ?>>
                            <a href="mailto:<?php echo $di_data['site_email']; ?>" target="_blank">
                                <i class="fal fa-envelope" aria-hidden="true"></i>
                                <?php echo $di_data['site_email']; ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <!-- Header Contact -->
                <?php } ?>

                <?php if($di_data['show_head_social']) { ?>
                <!-- Header Social -->
                <div class="col-md-6 head-social">
                    <ul>
                        <?php if($di_data['so_twitter']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_twitter_link']; ?>" title="<?php echo __( 'Twitter', 'dina-kala' ); ?>" target="_blank">
                                <i class="fab fa-twitter"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_facebook']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_facebook_link']; ?>" title="<?php echo __( 'Facebook', 'dina-kala' ); ?>" target="_blank">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_google']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_google_link']; ?>" title="<?php echo __( 'Google+', 'dina-kala' ); ?>" target="_blank">
                                <i class="fab fa-google-plus-g"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_whatsapp']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_whatsapp_link']; ?>" title="<?php echo __( 'Whatsapp', 'dina-kala' ); ?>" target="_blank">
                                <i class="fab fa-whatsapp"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_telegram']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_telegram_link']; ?>" title="<?php echo __( 'Telegram', 'dina-kala' ); ?>" target="_blank">
                                <i class="fab fa-telegram-plane"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_instagram']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_instagram_link']; ?>" title="<?php echo __( 'Instagram', 'dina-kala' ); ?>" target="_blank">
                                <i class="fab fa-instagram"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_youtube']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_youtube_link']; ?>" title="<?php echo __( 'Youtube', 'dina-kala' ); ?>" target="_blank">
                                <i class="fab fa-youtube"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_linkedin']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_linkedin_link']; ?>" title="<?php echo __( 'Linkedin', 'dina-kala' ); ?>" target="_blank">
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_dribble']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_dribble_link']; ?>" title="<?php echo __( 'Dribble', 'dina-kala' ); ?>" target="_blank">
                                <i class="fab fa-dribbble"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_behance']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_behance_link']; ?>" title="<?php echo __( 'Behance', 'dina-kala' ); ?>" target="_blank">
                                <i class="fab fa-behance"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_pinterest']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_pinterest_link']; ?>" title="<?php echo __( 'Pinterest', 'dina-kala' ); ?>" target="_blank">
                                <i class="fab fa-pinterest-p"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_aparat']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_aparat_link']; ?>" title="<?php echo __('Aparat','dina-kala'); ?>" target="_blank">
                                <i class="dico ico-aparat"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_cloob']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_cloob_link']; ?>" title="<?php echo __('Aparat','dina-kala'); ?>" target="_blank">
                                <i class="dico ico-cloob"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_soroush']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_soroush_link']; ?>" title="<?php echo __('Soroush','dina-kala'); ?>" target="_blank">
                                <i class="dico ico-Soroush"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_gap']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_gap_link']; ?>" title="<?php echo __('Gap','dina-kala'); ?>" target="_blank">
                                <i class="dico ico-Gap"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_eitaa']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_eitaa_link']; ?>" title="<?php echo __('Eitaa','dina-kala'); ?>" target="_blank">
                                <i class="dico ico-Eitaa"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_bisphone']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_bisphone_link']; ?>" title="<?php echo __('Bisphone','dina-kala'); ?>" target="_blank">
                                <i class="dico ico-Bisphone"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_bale']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_bale_link']; ?>" title="<?php echo __('Bale','dina-kala'); ?>" target="_blank">
                                <i class="dico ico-Bale"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_igap']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_igap_link']; ?>" title="<?php echo __('iGap','dina-kala'); ?>" target="_blank">
                                <i class="dico ico-iGap"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_rubika']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_rubika_link']; ?>" title="<?php echo __('Rubika','dina-kala'); ?>" target="_blank">
                                <i class="dico ico-rubika"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_hoorsa']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_hoorsa_link']; ?>" title="<?php echo __('Hoorsa','dina-kala'); ?>" target="_blank">
                                <i class="dico ico-hoorsa"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_phone']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="tel:<?php echo dina_remove_dash($di_data['so_phone_link']); ?>" title="<?php echo __('Phone','dina-kala'); ?>" target="_blank">
                                <i class="fal fa-phone" aria-hidden="true"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_mobile']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="tel:<?php echo dina_remove_dash($di_data['so_mobile_link']); ?>" title="<?php echo __('Mobile','dina-kala'); ?>" target="_blank">
                                <i class="fal fa-mobile-alt" aria-hidden="true"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_email']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="mailto:<?php echo $di_data['so_email_link']; ?>" title="<?php echo __('Email','dina-kala'); ?>" target="_blank">
                                <i class="fal fa-at" aria-hidden="true"></i>
                            </a>
                        </li>
                        <?php } ?>
                    </ul>
                </div>
                <!-- Header Social -->
                <?php } ?>

            </div>
            <?php } ?>

            <div class="row logo-box<?php if ($di_data['logo_pos'] == 2) {echo ' left-logo';} if ($di_data['mobile_logo_pos'] == 1) {echo ' mobile-right-logo';} ?>">

                    <div class="col-6 mobile-btns d-block d-md-none">
                        <span class="btn btn-light mmenu" onclick="openNav()">
                                <i aria-hidden="true" class="fal fa-bars"></i>
                        </span>
                        <?php if($di_data['show_user_btn']) { ?>
                        <?php if(!is_user_logged_in()) { ?>
                            <?php if (function_exists('digits_version') && $di_data['digits_mode']) { ?>
                            <?php if($di_data['digits_page']) {$digits_mode = 'digitlink';} else {$digits_mode = 'digitpopup';} ?>
                                <span title="<?php echo __('Login Or Register', 'dina-kala'); ?>" class="btn btn-light mlogin digitsbtn <?php echo $digits_mode; ?>">
                                    <i aria-hidden="true" class="fal fa-user"></i>
                                    /
                                    <i aria-hidden="true" class="fal fa-user-plus"></i>
                                </span>
                            <?php } elseif($di_data['merge_user_btn']) { ?>
                                <a title="<?php echo __('Login Or Register', 'dina-kala'); ?>" class="btn btn-light mlogin" <?php if($di_data['ch_login_link']) {echo 'href="'.$di_data['login_link'].'"'; } else {echo 'href="' .esc_url(home_url()).'/my-account"';} ?>>
                                    <i aria-hidden="true" class="fal fa-user"></i>
                                    /
                                    <i aria-hidden="true" class="fal fa-user-plus"></i>
                                </a>
                            <?php } else { ?>
                            <a title="<?php echo __('Login', 'dina-kala'); ?>" <?php if($di_data['ch_login_link']) {echo 'href="'.$di_data['login_link'].'"'; } else {echo 'href="#" onclick="openLogin()"';} ?>
                                class="btn btn-light mlogin">
                                <i aria-hidden="true" class="fal fa-user"></i>
                            </a>
                            <a title="<?php echo __('Register', 'dina-kala'); ?>" <?php if($di_data['ch_register_link']) {echo 'href="'.$di_data['register_link'].'"'; } else {echo 'href="' .esc_url(home_url()).'/my-account"';} ?>
                                class="btn btn-light mregister">
                                <i aria-hidden="true" class="fal fa-user-plus"></i>
                            </a>
                        <?php } } else { ?>
                            <a title="<?php echo __('User Menu', 'dina-kala'); ?>" class="btn btn-light mlogin" onclick="openUmenu()">
                                <i aria-hidden="true" class="fal fa-user"></i>
                            </a>
                        <?php } } ?>
                    </div>

                    <div class="col-md-3 col-6 logo">
                    <?php if (is_front_page()) {echo '<h1>';} ?>
                    <a href="<?php echo esc_url(home_url()); ?>" title="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" rel="home">
                    <?php 
                    $logo_width = (!empty($di_data['site_logo']['width'])) ? $di_data['site_logo']['width'] : '160';
                    $logo_height = (!empty($di_data['site_logo']['height'])) ? $di_data['site_logo']['height'] : '57'; ?>
                        <img <?php if($di_data['site_schema']) {?>itemprop="logo" <?php } ?> src="<?php echo $di_data['site_logo']['url']; ?>" srcset="<?php echo $di_data['site_logo_retina']['url']; ?> 2x" width="<?php echo $logo_width; ?>" height="<?php echo $logo_height; ?>" alt="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" title="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" class="img-logo"/>
                        <strong><?php bloginfo('name'); ?> | <?php bloginfo('description'); ?> </strong>
                    </a>
                    <?php if (is_front_page()) {echo '</h1>';} ?>
                    </div>
                    
                    <div class="col-md-6 search-con<?php if($di_data['mobile_search']) { ?> mobile-search-con<?php } ?>">
                        <form id="head-search" role="search" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                        <?php if(!$di_data['search_others']) { ?>
                            <input type="hidden" name="post_type" value="product" />
                        <?php } ?>
                        <div class="input-group search-form col-md-11">
                            <?php 
                            if ( $di_data['search_cat'] ) {
                            $categories = get_terms("product_cat");
                            if (!empty( $categories ) && !is_wp_error( $categories ) ) {
                             ?>
                            <div class="input-group-before prod-cat">
                                <?php echo '<select name="product_cat" >';
                                echo '<option value="">'.__("Category",'dina-kala').'</option>';
                                foreach ( $categories as $category ) {
                                echo '<option value="'.$category->slug.'">'.$category->name.'</option>';
                                }
                                echo '</select>'; ?>
                            </div>
                            <?php } } ?>
                            <input autocomplete="off"<?php if($di_data['ajax_search']) { echo ' data-swplive="true"' ; } ?> name="s" type="text" class="form-control search-input" placeholder="<?php _e('Search Products...', 'dina-kala'); ?>" aria-label="<?php _e("Search", 'dina-kala'); ?>" required>
                            <div class="input-group-append">
                                <button class="btn btn-search" type="submit" aria-label="<?php _e("Search", 'dina-kala'); ?>">
                                    <i class="fal fa-search" aria-hidden="true"></i>
                                </button>
                            </div>
                        </div>
                        </form>
                    </div>

                    <?php if($di_data['show_user_btn']) { ?>
                        <?php if(!is_user_logged_in()) { ?>
                        <div class="col-md-3 user-btn d-none d-md-block">
                            <?php if (function_exists('digits_version') && $di_data['digits_mode']) { ?>
                                <?php if($di_data['digits_page']) {$digits_mode = 'digitlink';} else {$digits_mode = 'digitpopup';} ?>
                                <?php if($di_data['user_btn_style']) { ?>
                                    <span title="<?php echo __('Login Or Register', 'dina-kala'); ?>" class="register-link digitsbtn <?php echo $digits_mode; ?>">
                                        <i aria-hidden="true" class="fal fa-user"></i>
                                        <span class="hidden-ta"><?php echo __('Login', 'dina-kala'); ?></span>
                                        /
                                        <i aria-hidden="true" class="fal fa-user-plus"></i>
                                        <span class="hidden-ta"><?php echo __('Register', 'dina-kala'); ?></span>
                                    </span>
                                <?php } else { ?>
                                    <span title="<?php echo __('Login Or Register', 'dina-kala'); ?>" class="btn btn-success btn-register digitsbtn <?php echo $digits_mode; ?>">
                                        <i aria-hidden="true" class="fal fa-user"></i>
                                        <span class="hidden-ta"><?php echo __('Login', 'dina-kala'); ?></span>
                                        /
                                        <i aria-hidden="true" class="fal fa-user-plus"></i>
                                        <span class="hidden-ta"><?php echo __('Register', 'dina-kala'); ?></span>
                                    </span>
                                <?php } ?>
                            <?php } else { ?>
                                <?php if($di_data['user_btn_style']) { ?>
                                    <?php if($di_data['merge_user_btn']) { ?>
                                        <a title="<?php echo __('Login Or Register', 'dina-kala'); ?>" <?php if($di_data['ch_login_link']) {echo 'href="'.$di_data['login_link'].'"'; } else {echo 'href="' .esc_url(home_url()).'/my-account"';} ?>
                                        class="register-link merge-btn">
                                            <i aria-hidden="true" class="fal fa-user"></i>
                                            <span class="hidden-ta"><?php echo __('Login', 'dina-kala'); ?></span>
                                            /
                                            <i aria-hidden="true" class="fal fa-user-plus"></i>
                                            <span class="hidden-ta"><?php echo __('Register', 'dina-kala'); ?></span>
                                        </a>
                                    <?php } else { ?>
                                        <a title="<?php echo __('Login', 'dina-kala'); ?>" <?php if($di_data['ch_login_link']) {echo 'href="'.$di_data['login_link'].'"'; } else {echo 'href="#" onclick="openLogin()"';} ?>
                                            class="login-link">
                                            <i aria-hidden="true" class="fal fa-user"></i>
                                            <span class="hidden-ta"><?php echo __('Login', 'dina-kala'); ?></span>
                                        </a>
                                        /
                                        <a title="<?php echo __('Register', 'dina-kala'); ?>" <?php if($di_data['ch_register_link']) {echo 'href="'.$di_data['register_link'].'"'; } else {echo 'href="' .esc_url(home_url()).'/my-account"';} ?>
                                            class="register-link">
                                            <i aria-hidden="true" class="fal fa-user-plus"></i>
                                            <span class="hidden-ta"><?php echo __('Register', 'dina-kala'); ?></span>
                                        </a>
                                    <?php } ?>
                                <?php } else { ?>
                                    <?php if($di_data['merge_user_btn']) { ?>
                                        <a title="<?php echo __('Login Or Register', 'dina-kala'); ?>" <?php if($di_data['ch_login_link']) {echo 'href="'.$di_data['login_link'].'"'; } else {echo 'href="' .esc_url(home_url()).'/my-account"';} ?>
                                            class="btn btn-success btn-register merge-btn">
                                            <i aria-hidden="true" class="fal fa-user"></i>
                                            <span class="hidden-ta"><?php echo __('Login', 'dina-kala'); ?></span>
                                            /
                                            <i aria-hidden="true" class="fal fa-user-plus"></i>
                                            <span class="hidden-ta"><?php echo __('Register', 'dina-kala'); ?></span>
                                        </a>
                                    <?php } else { ?>
                                        <a title="<?php echo __('Login', 'dina-kala'); ?>" <?php if($di_data['ch_login_link']) {echo 'href="'.$di_data['login_link'].'"'; } else {echo 'href="#" onclick="openLogin()"';} ?>
                                            class="btn btn-outline-success btn-login">
                                            <i aria-hidden="true" class="fal fa-user"></i>
                                            <span class="hidden-ta"><?php echo __('Login', 'dina-kala'); ?></span>
                                        </a>
                                        <a title="<?php echo __('Register', 'dina-kala'); ?>" <?php if($di_data['ch_register_link']) {echo 'href="'.$di_data['register_link'].'"'; } else {echo 'href="' .esc_url(home_url()).'/my-account"';} ?>
                                            class="btn btn-success btn-register">
                                            <i aria-hidden="true" class="fal fa-user-plus"></i>
                                            <span class="hidden-ta"><?php echo __('Register', 'dina-kala'); ?></span>
                                        </a>
                                    <?php } ?>
                                <?php } ?>
                            <?php } ?>
                        </div>
                        <?php } else {
                        $user = wp_get_current_user(); ?>
                        <div class="col-md-3 drop-con d-none d-md-block">
                        <div class="dropdown user-drop">
                            <button class="dropdown-toggle user-menu" type="button" data-toggle="dropdown">
                            <?php echo get_avatar(get_current_user_id() , 32,'',$user->display_name ); ?>
                            <span class="user-name"><?php echo $user->display_name; ?>
                            <?php if (class_exists( 'WooWallet' ))
                            {       
                            echo '<span class="wallet hidden-ta">';
                            $wallet = woo_wallet()->wallet->get_wallet_balance( get_current_user_id() );
                                    echo ' | '. $wallet;
                            echo '</span>';
                            } ?></span>
                            <span class="fal fa-chevron-down user-chevron-down" aria-hidden="true"></span>
                            </button>

                            <?php if($di_data['replace_user_menu'] && has_nav_menu('user_menu')) { ?>
                                <?php
                                    wp_nav_menu( array(
                                        'menu'              => 'user_menu',
                                        'theme_location'    => 'user_menu',
                                        'menu_class'        => 'dropdown-menu user-menu mu-menu col-12',
                                        'depth'             => 1,
                                        'container'         => ''
                                        )
                                    );
                                ?>
                            <?php } else { ?>
                                <ul class="dropdown-menu user-menu mu-menu col-12">
                                    <?php get_template_part('includes/umenu'); ?>
                                </ul>
                            <?php } ?>
                        </div>
                        </div>
                    <?php } } ?>
            </div>
        </div>
    </div>
    <!-- Header Div -->

    <!-- Navbar -->
    <nav class="navbar navbar-expand-sm<?php if ($di_data['fixed_head_top']) {echo ' fixed-nav';} ?><?php if ($di_data['focus_nav']) {echo ' focus-nav';} ?>" <?php if($di_data['site_schema']) {?>itemscope itemtype="https://schema.org/SiteNavigationElement"<?php } ?>>
    <div class="container">
        <!-- Collect the nav links from WordPress -->
        <div class="collapse navbar-collapse" id="bootstrap-nav-collapse">
            <?php 
            $args = array(
                'theme_location' => 'mega_menu',
                'depth'             => 4,
                'container'         => 'div',
                'fallback_cb'       => 'Yamm_Nav_Walker_menu_fallback',
                'walker'            => new Yamm_Nav_Walker()
                );

            if($di_data['mega_style'] == 'second') {
                $args['menu_class'] = 'nav navbar-nav yamm-s';
            } else {
                $args['menu_class'] = 'nav navbar-nav yamm';
            }

            if ($di_data['fixed_head_logo']) {
                if($di_data['site_schema']) { $itemprop = 'itemprop="logo"'; } else { $itemprop = ''; }
                if($di_data['change_fixed_logo'] && !empty($di_data['sticky_logo']['url'])) {
                    $sticky_logo = '<li class="sticky-logo"><a href="'. esc_url(home_url()) .'" title="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" rel="home" class="menu-logo">
                                <img '. $itemprop .'src="'. $di_data['sticky_logo']['url'] .'" alt="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" width="107" height="37" title="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" class="img-logo"/>
                            </a></li>';
                } else {
                    $sticky_logo = '<li class="sticky-logo"><a href="'. esc_url(home_url()) .'" title="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" rel="home" class="menu-logo">
                                <img '. $itemprop .'src="'. $di_data['site_logo']['url'] .'" srcset="'. $di_data['site_logo_retina']['url'] .' 2x" alt="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" width="107" height="37" title="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" class="img-logo"/>
                            </a></li>';
                }
                
                $items_wrap = '<ul id="%1$s" class="%2$s">'.$sticky_logo.'%3$s';
                $items_wrap .= '</ul>';
                $args['items_wrap'] = $items_wrap;
            }

            //$args['menu_class'] = 'nav navbar-nav yamm';
            wp_nav_menu($args);
        ?>
        </div><!-- ./collapse -->

        <?php
        if($di_data['show_wish_list'] && class_exists( 'JVM_WooCommerce_Wishlist' )) {
        $wish_url = jvm_get_wishlist_url();
        $wish_count = jvm_woocommerce_wishlist_get_count(); ?>
        <div class="btn-wish">
            <a href="<?php echo $wish_url; ?>" aria-label="<?php echo __('Wishlist', 'dina-kala'); ?>" rel="nofollow" class="wish-icon" data-toggle="tooltip" data-placement="top" title="<?php echo __('Wishlist', 'dina-kala'); ?>">
                <i aria-hidden="true" class="fal fa-heart"></i>
                <i class="wish-amount"><?php echo $wish_count; ?></i>
            </a>
        </div>
        <?php } ?>

        <?php 
        if ( defined( 'WCCM_VERISON' ) && $di_data['show_compare_btn'] ) {
        $compare_url = wccm_get_compare_page_link( wccm_get_compare_list() );
        $compare_count = count(wccm_get_compare_list()); ?>
        <div class="btn-compare">
            <a href="<?php echo $compare_url; ?>" aria-label="<?php echo __('Compare Products', 'dina-kala'); ?>" rel="nofollow" class="compare-icon compare-link" data-toggle="tooltip" data-placement="top" title="<?php echo __('Compare Products', 'dina-kala'); ?>">
            <i aria-hidden="true" class="fal fa-random"></i>
            <i class="compare-amount"><?php echo $compare_count; ?></i>
            </a>
        </div>
        <?php } ?>

        <?php if($di_data['show_cart_btn']) { ?>
        <div class="btn-cart">
            <span class="shop-icon" data-toggle="tooltip" data-placement="top" title="<?php echo __('Shopping cart', 'dina-kala'); ?>" onclick="openCart()">
            <i aria-hidden="true" class="fal fa-shopping-bag"></i>
            <i class="cart-amount"><?php echo WC()->cart->get_cart_contents_count(); ?></i>
            </span>
        </div>
        <?php } ?>

    </div><!-- /.container -->
    </nav>
    <!-- Navbar -->
    </header>