<?php 
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Demo Website: Dina.Elmfile.ir
Author Website: Hosseinkhani.ir
*/

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

//Theme's Languages
function dina_localisation(){
    function dina_localised( $locale ) {
        if ( isset( $_GET['l'] ) ) {
            return sanitize_key( $_GET['l'] );
        }
        return $locale;
    }
    add_filter( 'locale', 'dina_localised' );
    load_theme_textdomain( 'dina-kala', get_template_directory() . '/languages' );
}
add_action( 'after_setup_theme', 'dina_localisation' );

//Theme's constants
define ('DI_URI' , get_template_directory_uri());
define ('DI_DIR' , get_template_directory());

//Theme version
if ( ! defined( 'DI_VER' ) ) {
	define( 'DI_VER', '3.9' );
}

//Incluse Theme Files
if ( !class_exists( 'ReduxFramework' ) && file_exists( dirname( __FILE__ ) . '/includes/ReduxCore/framework.php' ) ) {
    require_once( dirname( __FILE__ ) . '/includes/ReduxCore/framework.php' );
}
if ( !isset( $redux_demo ) && file_exists( dirname( __FILE__ ) . '/includes/admin-panel-config.php' ) ) {
    require_once( dirname( __FILE__ ) . '/includes/admin-panel-config.php' );
}

Redux::init('di_data');

require_once DI_DIR . '/plugins/plugin.php';
require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
require_once DI_DIR . '/includes/meta-box.php';
require_once DI_DIR . '/includes/ajax-login.php';
require_once DI_DIR . '/includes/recaptchalib.php';
require_once DI_DIR . '/includes/simple-link-list-widget/simple-link-list-widget.php';
require_once DI_DIR . '/includes/dynamic_style.php';
require_once DI_DIR . '/includes/d-sidebar.php';
require_once DI_DIR . '/includes/img-fix.php';
require_once DI_DIR . '/includes/image-banner.php';
require_once DI_DIR . '/includes/logo-namad.php';
require_once DI_DIR . '/includes/epay.php';
require_once DI_DIR . '/includes/products.php';
require_once DI_DIR . '/includes/posts.php';
require_once DI_DIR . '/includes/fnews.php';
//require_once DI_DIR . '/includes/stock-status.php';
require_once DI_DIR . '/includes/thumbnail-upscale.php';
require_once DI_DIR . '/includes/woo.php';
require_once DI_DIR . '/includes/footer-codes.php';
require_once DI_DIR . '/includes/edit_custom_walker.php';
require_once DI_DIR . '/includes/menu-icon.php';
require_once DI_DIR . '/includes/mmenu_walker.php';
require_once DI_DIR . '/includes/views.php';
if( class_exists( 'WeDevs_Dokan' ) ) {
require_once DI_DIR . '/includes/dokan.php';
}
if( !function_exists('yoast_breadcrumb') ) {
require_once DI_DIR . '/includes/rich-text-tags/rich-text-tags.php';
}
//Register Elementor Widgets
if ( did_action( 'elementor/loaded' ) ) {
    require_once DI_DIR . '/includes/elementor.php';
}
if($di_data['mega_style'] == 'second') {
require_once DI_DIR . '/includes/yamm-s.php';
} else {
require_once DI_DIR . '/includes/yamm.php';
}
if($di_data['ajax_search']) {
require_once DI_DIR . '/includes/searchwp-live-ajax-search/searchwp-live-ajax-search.php';
}
if($di_data['ajax_add'] && get_option( 'woocommerce_enable_ajax_add_to_cart' ) === 'yes' && get_option( 'woocommerce_cart_redirect_after_add' ) === 'no') {
require_once DI_DIR . '/includes/ajax-add.php';
}
if($di_data['stock_order']) {
require_once DI_DIR . '/includes/order-class.php';
}
if($di_data['product_brand']) {
require_once DI_DIR . '/includes/brand.php';
}

//Register Theme's styles
add_action('wp_enqueue_scripts','dina_styles');
function dina_styles() {
    global $di_data;
    if (is_rtl()) {
        wp_register_style('dina-boot-rtl', DI_URI . '/css/bootstrap-rtl.min.css', array(), DI_VER);
        wp_enqueue_style('dina-boot-rtl');
    } else {
        wp_register_style('dina-boot', DI_URI . '/css/bootstrap.min.css', array(), DI_VER);
        wp_enqueue_style('dina-boot'); 
    }
    wp_register_style('dina-awe', DI_URI . '/css/fontawesome.min.css', array(), DI_VER);
    wp_enqueue_style('dina-awe');
    wp_register_style('dina-style', DI_URI . '/style.css', array() , DI_VER);
    wp_enqueue_style('dina-style');

    wp_register_style('dina-font', DI_URI . '/css/'.$di_data['theme_font'].'.css', array() , DI_VER);
    wp_enqueue_style('dina-font');
    if($di_data['full_width_style']) {
        wp_register_style('dina-full', DI_URI . '/css/full-width.css', array() , DI_VER);
        wp_enqueue_style('dina-full');
    }
    if( class_exists( 'WeDevs_Dokan' ) ) {
        wp_register_style('dina-dokan', DI_URI . '/css/dokan.css', array(), DI_VER);
        wp_enqueue_style('dina-dokan');
    }
    if (!is_rtl()) {
        wp_register_style('dina-style-ltr', DI_URI . '/css/ltr.css', array(), DI_VER);
        wp_enqueue_style('dina-style-ltr');
    }
}

//Register Elementor Panel styles
add_action('elementor/editor/before_enqueue_scripts', function() {
    wp_register_style('el-style', DI_URI . '/css/elementor.css', array() , DI_VER);
    wp_enqueue_style('el-style');
    wp_register_style('dina-awe', DI_URI . '/css/fontawesome.min.css', array() , DI_VER);
    wp_enqueue_style('dina-awe');
});

//Register Theme's Scripts
add_action('init', 'dina_scripts');
function dina_scripts() {
if (is_admin()) return;
    wp_enqueue_script('dina-js-boot', DI_URI . '/js/bootstrap.min.js', array('jquery'), DI_VER, true);
    wp_enqueue_script('dina-js-main', DI_URI . '/js/main.js', array('jquery'), DI_VER, true);
}

add_action( 'wp_footer', 'dina_vcrtl_conflict', 11 );
function dina_vcrtl_conflict() { 
    if (defined('WPB_VC_VERSION')) {
        wp_deregister_script( 'flexslider' );
        wp_enqueue_script('flexslider', DI_URI . '/js/jquery.flexslider.min.js', array('jquery'), DI_VER, true);
    }
}

//Add Admin Scripts
add_action('admin_enqueue_scripts', 'dina_upload_script');
function dina_upload_script() {
    wp_enqueue_media();
    wp_enqueue_script('ads_script', DI_URI . '/js/upload-media.js', false, DI_VER, true);
}

// Add Theme Support
add_action('after_setup_theme','dina_support');
function dina_support() {
    global $di_data;
    add_theme_support('title-tag');
    add_theme_support('html5');
    add_theme_support('post-thumbnails');
    if($di_data['custom_post_thumb']){
        $width = $di_data['post_thumb_width'];
        $height = $di_data['post_thumb_height'];
        add_image_size('dpost_thumbnail', $width, $height, true);
    }
    add_theme_support('automatic-feed-links');
    add_theme_support( 'woocommerce' );
    add_theme_support( 'wc-product-gallery-zoom' );
    add_theme_support( 'wc-product-gallery-lightbox' );
    add_theme_support( 'wc-product-gallery-slider' );
}

//Rregister navigation menu
register_nav_menus( array(
    'mega_menu'   => __( 'Mega Menu', 'dina-kala' ),
    'header' => __( 'Header Menu', 'dina-kala' ),
));

if($di_data['replace_user_menu']) {
    register_nav_menus( array(
        'user_menu'   => __( 'User Menu', 'dina-kala' ),
    ));
}

if($di_data['replace_mobile_menu']) {
    register_nav_menus( array(
        'mobile_menu'   => __( 'Mobile Menu', 'dina-kala' ),
    ));
}

//Redux Menu
if (!function_exists('remove_redux_menu')) {
    add_action('admin_menu', 'remove_redux_menu', 12);
    function remove_redux_menu()
    {
        remove_submenu_page('tools.php', 'redux-about');
    }
}

//Redux Styles
add_action( 'admin_enqueue_scripts', 'redux_custom_styles' );
function redux_custom_styles($page)
{
    wp_enqueue_style('redux-custom-style', DI_URI .'/includes/redux.css');
}

//Fontawesomw admin icons
add_action('admin_init', 'fa_dashboard');
function fa_dashboard()
{
    wp_enqueue_style('fa_di_admin', DI_URI . '/css/fontawesome.min.css');
}

//Widget tag's number
add_filter( 'widget_tag_cloud_args', 'dina_tag_cloud_limit' );
function dina_tag_cloud_limit($args){ 
    global $di_data;
    // Check if taxonomy option of the widget is set to tags
    if ( isset($args['taxonomy']) ) {
        $args['number'] = $di_data['tag_number']; // Number of tags to show
        }
    return $args;
}

//Loads admin-side menu-icon scripts and styles
add_action('admin_enqueue_scripts', 'admin_menu_icon_styles');
function admin_menu_icon_styles($page)
{
if ($page == 'nav-menus.php')
    {
    wp_enqueue_style('select2', DI_URI . '/includes/select2.min.css');
    wp_enqueue_style('menu-icon-admin-style', DI_URI . '/includes/menu-icon-admin.css');
    wp_enqueue_script('my_s2', DI_URI . '/includes/select2.min.js');
    wp_enqueue_script('my_s1', DI_URI . '/includes/select2.js');
    }
}

//Pagination
function wp_pagination()
{
global $wp_query;
$big = 999999999;
$page_format = paginate_links(array(
    'base' => str_replace($big, '%#%', esc_url(get_pagenum_link($big))) ,
    'format' => '?paged=%#%',
    'current' => max(1, get_query_var('paged')) ,
    'total' => $wp_query->max_num_pages,
    'prev_text' => __('<i class="fal fa-chevron-right" aria-hidden="true" title="Next"></i>') ,
    'next_text' => __('<i class="fal fa-chevron-left" aria-hidden="true" title="Prev"></i>') ,
    'type' => 
    'array'
));
if (is_array($page_format))
    {
    $paged = (get_query_var('paged') == 0) ? 1 : get_query_var('paged');
    echo '<div class="col-12 pagination"><ul>';
    foreach($page_format as $page)
        {
        echo "<li>$page</li>";
        }
    echo '</ul></div>';
    }
}

function p_img() { 
   if ( has_post_thumbnail()) {
        the_post_thumbnail('woocommerce_thumbnail');
    } else { 
        echo '<img src="'.esc_url( get_template_directory_uri() ).'/images/tumb.png" alt="'.the_title_attribute('echo=0').'" class="post-tumb"/>';
    }
}

function pr_img() { 
    global $di_data;
    echo '<div class="img-con">';
    if ( has_post_thumbnail()) {
         the_post_thumbnail('woocommerce_thumbnail');
    } else { 
        echo '<img src="'.esc_url( get_template_directory_uri() ).'/images/tumb.png" alt="'.the_title_attribute('echo=0').'" class="post-tumb"/>';
    }
    if($di_data['show_sec_img']) {
        global $product;
        $attachment_ids = $product->get_gallery_image_ids();
        if ( is_array( $attachment_ids ) && !empty($attachment_ids) ) {
            $first_image_url = wp_get_attachment_image_src($attachment_ids[0], 'woocommerce_thumbnail');
            echo '<img width="'.$first_image_url[1].'" height="'.$first_image_url[2].'" src="'.$first_image_url[0].'" alt="'.get_the_title().'" class="second-img wp-post-image">';
        }
    }
    echo '</div>';
 }

function po_img() { 
    global $di_data;
    echo '<div class="img-con">';
    if ( has_post_thumbnail()) {
        if($di_data['custom_post_thumb']) {
            the_post_thumbnail('dpost_thumbnail');
        } else {
            the_post_thumbnail('woocommerce_thumbnail');
        }
     } else { 
         echo '<img src="'.esc_url( get_template_directory_uri() ).'/images/tumb.png" alt="'.the_title_attribute('echo=0').'" class="post-tumb"/>';
     }
    if($di_data['show_post_pub']) {
        echo '<span class="post-pub">';
            echo get_jdate_publish_time();
        echo '</span>';
    }
    echo '</div>';
}

function remove_admin_bar() {
global $di_data;
if ((current_user_can('administrator') || current_user_can('shop_manager')) && $di_data['show_abar_admin']) {
    add_filter('show_admin_bar', '__return_true');
} else {
    add_filter('show_admin_bar', '__return_false');
}
}
if ($di_data['show_abar'])
	{ 
	add_action('after_setup_theme', 'remove_admin_bar');
}

/**
* Updating the subscriber role
*/
$subscriber_role = get_role( 'subscriber' );
if($subscriber_role){
// Adding a new capability to role
$subscriber_role->add_cap( 'view_ticket' );
$subscriber_role->add_cap( 'create_ticket' );
$subscriber_role->add_cap( 'close_ticket' );
$subscriber_role->add_cap( 'reply_ticket' );
$subscriber_role->add_cap( 'attach_files' );
}

$customer_role = get_role( 'customer' );
if($customer_role){
// Adding a new capability to role
$customer_role->add_cap( 'view_ticket' );
$customer_role->add_cap( 'create_ticket' );
$customer_role->add_cap( 'close_ticket' );
$customer_role->add_cap( 'reply_ticket' );
$customer_role->add_cap( 'attach_files' );
}

$seller_role = get_role( 'seller' );
if($seller_role){
// Adding a new capability to role
$seller_role->add_cap( 'view_ticket' );
$seller_role->add_cap( 'create_ticket' );
$seller_role->add_cap( 'close_ticket' );
$seller_role->add_cap( 'reply_ticket' );
$seller_role->add_cap( 'attach_files' );
}

if( class_exists( 'Awesome_Support' ) ) { 
add_filter( 'page_template', 'ticket_page_template' );
function ticket_page_template( $page_template ) {
        global $post;
        $ticket_id = wpas_get_option( 'ticket_list' );
        $ticket_submit_id = wpas_get_option( 'ticket_submit' );
        if(is_array($ticket_submit_id)){
            $ticket_submit = $ticket_submit_id[0];
        }
        else{
            $ticket_submit = $ticket_submit_id;
        }
        $post_id = $post->ID;
        if( ($post_id === (int)$ticket_id) || ($post_id === (int)$ticket_submit) ) {
                $page_template = get_stylesheet_directory() . '/tickets.php'; 
        } 
    return $page_template;
}
}

if( class_exists( 'Affiliate_WP' ) ) { 
add_filter( 'page_template', 'affiliate_page_template' );
function affiliate_page_template( $page_template ) {
        global $post;
        $post_id = $post->ID;
        if($post_id === affwp_get_affiliate_area_page_id() ) {
                $page_template = get_stylesheet_directory() . '/affiliate-area.php'; 
        } 
    return $page_template;
}
}

add_filter( 'comment_form_fields', 'wpb_move_comment_field_to_bottom');
function wpb_move_comment_field_to_bottom( $fields ) {
$comment_field = $fields['comment'];
unset( $fields['comment'] );
$fields['comment'] = $comment_field;
return $fields;
}

function get_post_primary_category($post_id, $term='category', $return_all_categories=false){
    $return = array();

    if (class_exists('WPSEO_Primary_Term')){
        // Show Primary category by Yoast if it is enabled & set
        $wpseo_primary_term = new WPSEO_Primary_Term( $term, $post_id );
        $primary_term = get_term($wpseo_primary_term->get_primary_term());

        if (!is_wp_error($primary_term)){
            $return['primary_category'] = $primary_term;
        }
    }

    if (empty($return['primary_category']) || $return_all_categories) {
        $categories_list = get_the_terms($post_id, $term);

        if (empty($return['primary_category']) && !empty($categories_list)){
            $return['primary_category'] = $categories_list[0];  //get the first category
        }
        if ($return_all_categories){
            $return['all_categories'] = array();

            if (!empty($categories_list)){
                foreach($categories_list as &$category){
                    $return['all_categories'][] = $category->term_id;
                }
            }
        }
    }
    return $return;
}

function get_jdate_publish_time(){
	$greg_date = get_post_time('j F Y');
    $timestamp = strtotime($greg_date);
    if (defined('PW_VERSION') && PW_VERSION >= '4.0.0') {
        echo get_the_date('j F Y');
    } elseif ( function_exists('jdate') ) {
		echo jdate('j F Y',$timestamp);
	} elseif( function_exists('parsidate') ) {
        echo parsidate('j F Y',$timestamp);
    } elseif( function_exists('wpp_jdate') ) {
        echo wpp_jdate('j F Y',$timestamp);
    } else {
		echo $greg_date;
	}
}

//Add body class for mobile bar
if($di_data['hide_mobile_bar']) { 
add_filter( 'body_class', function( $classes ) {
    return array_merge( $classes, array( 'no-bbar' ) );
} );
}

//Check site direction is RTL
function dina_rtl() {
    if (is_rtl()) {
        echo 'true';
    } else {
        echo 'false';
    }
}

//dina_custom_excerpt_length
add_filter( 'excerpt_length', 'dina_custom_excerpt_length', 999 );
function dina_custom_excerpt_length( $length ) {
    return 20;
}

//dina_remove_brackets_excerpt
function dina_custom_excerpt_more( $excerpt ) {
    return ' ...';
}
add_filter( 'excerpt_more', 'dina_custom_excerpt_more' );

//Dina remove dashes
function dina_remove_dash($input) {
    $output = preg_replace("/[^A-Za-z0-9]/", "", $input);
    return $output;
}

//Dina Header Banner
function dina_header_banner() {
    global $di_data;
    if ( !empty( $di_data['head_banner']['url'] ) ) { ?>

    <div class="row head-banner-row<?php if (!$di_data['show_head_mobile']) { echo ' mobile-hidden'; }?>">
        <div class="col-12 bnr-image shadow-box">
            <a href="<?php echo $di_data['head_banner_link']; ?>" title="<?php echo $di_data['head_banner_title']; ?>" aria-label="<?php echo $di_data['head_banner_title']; ?>">
                <?php
                    $headb_width = (!empty($di_data['head_banner']['width'])) ? $di_data['head_banner']['width'] : '1260';
                    $headb_height = (!empty($di_data['head_banner']['height'])) ? $di_data['head_banner']['height'] : '142'; 
                ?>
                <img src="<?php echo $di_data['head_banner']['url']; ?>" alt="<?php echo $di_data['head_banner_title']; ?>" class="head-banner shadow-box" width="<?php echo $headb_width; ?>" height="<?php echo $headb_height; ?>" />
            </a>
        </div>
    </div>

<?php 
    }
}

//Run Shortcodes in the_excerpt
add_filter( 'the_excerpt', 'shortcode_unautop');
add_filter( 'the_excerpt', 'do_shortcode');