<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>

<?php 
	global $di_data;
	if($di_data['product_col'] == 2){
		$pclasses = 'col-6';
	}
	elseif($di_data['product_col'] == 3){
		$pclasses = 'col-md-4 col-6';
	}
	elseif($di_data['product_col'] == 4){
		$pclasses = 'col-md-3 col-6';
	}
	elseif($di_data['product_col'] == 5){
		$pclasses = 'col-20 col-md-3 col-6';
	}
?>

<li class="<?php echo $pclasses; ?> mini-product-con type-product"> 
<?php global $product;
	$in_stock = $product->is_in_stock();
	$stock_class = ($in_stock ? '' : ' prod-out-stock') ?>
<div class="shadow-box mini-product<?php echo $stock_class; ?>">
	<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="product-link">
		<?php p_img() ?>
		<?php if($in_stock && $product->is_on_sale()) { ?>
		<?php echo dina_dis_price(get_the_ID()); ?>
		<?php } ?>
		<span class="product-title">
			<?php the_title(); ?>
		</span>
		<span class="product-price">
		<?php if($in_stock) { ?>
			<span class="price-con">
			<?php echo $product->get_price_html(); ?>
			</span>
		<?php } else { ?>
			<span class="price-con">
			<?php _e( 'Out of stock', 'dina-kala' ); ?>
			</span>
		<?php } ?>
		</span>
	</a>
	<a href="<?php the_permalink(); ?>" class="btn btn-success btn-buy">
		<i class="fal fa-cart-plus" aria-hidden="true"></i>
		<?php if($in_stock) { ?>
			<?php _e( 'View And Buy', 'dina-kala' ); ?>
		<?php } else { ?>
			<?php _e( 'View Product', 'dina-kala' ); ?>
		<?php } ?>
	</a>
</div>
</li>