<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: Hosseinkhani.ir
*/
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
global $di_data;
get_header(); 
$pside = get_post_meta( get_the_ID(), 'dina_postside', true );
$content_sticky = ($di_data['side_sticky'] ? ' content-sticky' : '');
if($pside == 'lside' || $pside == '') {
    $row = '';
    $article = 'col-lg-9 col-12'.$content_sticky;
} elseif($pside == 'rside') {
    $row = ' right-side';
    $article = 'col-lg-9 col-12'.$content_sticky;
} elseif ($pside == 'wside') {
    $row = '';
    $article = 'col-12'.$content_sticky;
}
?>
<div class="container main-con">
<?php if($di_data['show_bread']) { woocommerce_breadcrumb(); }  ?>
<div class="row<?php echo $row; ?>">
<?php if ( have_posts() ) : ?>
<article role="main"  class="<?php echo $article; ?>" <?php if($di_data['site_schema'] ) {?>itemscope itemtype="https://schema.org/BlogPosting" <?php } ?>>
<?php while ( have_posts() ) : the_post(); ?>
<?php if($di_data['site_schema']) {?>
        <link itemprop="mainEntityOfPage" href="<?php the_permalink(); ?>" />
        <meta itemprop="image" content="<?php the_post_thumbnail_url(); ?>">
        <span itemprop="publisher" itemscope itemtype="https://schema.org/Organization">
            <span itemprop="logo" itemscope itemtype="https://schema.org/ImageObject">
                <meta itemprop="url" content="<?php echo $di_data['site_logo']['url']; ?>">
                <meta itemprop="width" content="140">
                <meta itemprop="height" content="60">
            </span>
            <meta itemprop="name" content="<?php bloginfo('name'); ?>">
        </span>
        <?php } ?>
<div class="shadow-box post-con" id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <h1 class="ptitle" <?php if($di_data['site_schema']) {?>itemprop="headline"<?php } ?>>
        <?php the_title(); ?>
    </h1>
<div class="row post-det">
    <div class="col-md-4 col-12 post-aut">
        <?php 
               $author = get_post_field( 'post_author', get_the_ID() );
               echo get_avatar($author , 32, '' , get_the_author_meta('display_name',$author )); 
        ?>
        <?php echo get_the_author_meta('display_name',$author ); ?>
        <?php if($di_data['site_schema']) { echo '<meta itemprop="editor" content="'.get_the_author_meta('display_name',$author ).'">'; } ?>
    </div>
    <div class="col-md-4 col-12 post-date">
        <i class="fal fa-calendar-alt" aria-hidden="true"></i>
        <?php if($di_data['site_schema']) {?><time datetime="<?php echo get_the_date('Y-m-d');?>" itemprop="datePublished">
            <?php } ?>
            <?php echo get_jdate_publish_time(); ?>
            <?php if($di_data['site_schema']) {?></time>
        <?php } ?>
        <?php if($di_data['site_schema']) {?>
        <meta content="<?php echo get_the_date('Y-m-d');?>" itemprop="dateModified">
        <?php } ?>
    </div>
    <?php setPostViews(get_the_ID()); ?>
    <?php if ($di_data['show_post_view']) { ?>
    <div class="col-md-4 col-12 post-views">
        <i class="fal fa-eye" aria-hidden="true"></i>
        <?php echo getPostViews(get_the_ID()); ?> <?php _e('View','dina-kala') ?>
    </div>
    <?php } ?>
</div>
<div class="post-content" <?php if($di_data['site_schema'] ) {?>itemprop="articleBody" <?php } ?>>
<?php if($di_data['site_schema']) { echo '<meta itemprop="author" content="'.get_the_author_meta('display_name',$author ).'">'; } ?>
<div class="post-img">
<?php
if ( has_post_thumbnail() && $di_data['show_post_thumb']) {
             the_post_thumbnail('larg'); 
    } ?>
</div>
<?php the_content(); ?>
</div>  
<?php
$defaults = array(
    'before'           => '<div class="text-center apage-break">',
    'after'            => '</div>',
    'link_before'      => '',
    'link_after'       => '',
    'next_or_number'   => 'text',
    'separator'        => ' ',
    'nextpagelink'     => '<span class="btn btn-outline-info">'.__('Next Page ', 'dina-kala').'<i aria-hidden="true" class="fal fa-angle-left"></i></span>',
    'previouspagelink' => '<span class="btn btn-outline-info"><i aria-hidden="true" class="fal fa-angle-right"></i>'.__(' Prev Page', 'dina-kala').'</span>',
    'pagelink'         => '%',
    'echo'             => 1
);
wp_link_pages($defaults); ?>
<div class="row post-det">
    <?php if ($di_data['show_post_tags']) { ?>
    <div class="col-12 post-tags">
        <?php the_tags('<span class="fal fa-tags" aria-hidden="true"></span>'.__(' Tags ','dina-kala'), '&nbsp;', ''); ?>
    </div>
    <?php } ?>
    <?php if ($di_data['show_post_cats']) { ?>
    <div class="col-md-6 col-12 post-cats">
        <i class="fal fa-folder-open"></i>
        <?php _e('Category','dina-kala') ?>
        <?php the_category( '&nbsp;' ); ?>
    </div>
    <?php } ?>
    <?php if ($di_data['share_post']) { ?>
    <div class="col-md-6 col-12 post-share">
        <span data-toggle="modal" data-target="#shareModal" class="pshare"">
            <i aria-hidden="true" class="fal fa-share-alt"></i>
            <?php _e('Share','dina-kala') ?>
        </span>
    </div>
    <?php } ?>
</div>
</div>
<?php endwhile; ?>

<?php global 
$di_data;
if ($di_data['show_related_post']) { ?>
    <?php
            $custom_taxterms = wp_get_object_terms( get_the_ID(), $di_data['related_post_by'], array('fields' => 'ids') );
            $args = array(
            'post_type' => 'post',
            'post_status' => 'publish',
            'posts_per_page' => $di_data['related_post_count'],
            'orderby' => 'rand',
            'tax_query' => array(
                array(
                    'taxonomy' => $di_data['related_post_by'],
                    'field' => 'id',
                    'terms' => $custom_taxterms
                )
            ),
            'post__not_in' => array (get_the_ID()),
            );
            $related_items = new WP_Query( $args ); ?>
			<?php
             if ($related_items->have_posts()) { 
				 ?>
			<div class="post-block related block">
                    <div class="block-title">
                        <h2>
                            <i class="fal fa-file-invoice" aria-hidden="true"></i>
                            <?php _e('Related Posts','dina-kala') ?>
                        </h2>
                    </div>
                    <div class="owl-carousel" <?php if ( $di_data['show_post_arrows'] ) { echo 'data-itemnavs="true"'; } else { echo 'data-itemnavs="false"'; } ?> <?php if ( $di_data['post_loop'] ) { echo 'data-itemloop="true"'; } else { echo 'data-itemloop="false"'; } ?> <?php if ( $di_data['auto_post_play'] ) { echo 'data-itemplay="true"'; } else { echo 'data-itemplay="false"'; } ?> data-itemscount="<?php echo $di_data['postcount']; ?>">
                    <?php
                        while ( $related_items->have_posts() ) : $related_items->the_post(); 
                        $post_categories = get_post_primary_category(get_the_ID(), 'category'); 
		                $primary_category = $post_categories['primary_category'];?>
                        <div class="item">
                        <div class="shadow-box mini-post">
                            <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="post-link">
                                <?php p_img() ?>
                                <span class="post-title">
                                    <?php the_title(); ?>
                                </span>
                                <span class="post-cat"><?php echo $primary_category->name; ?></span>
                            </a>
                            <a href="<?php the_permalink(); ?>" class="btn btn-success btn-buy">
                                <i class="fal fa-file-alt" aria-hidden="true"></i>
                                <?php echo __( 'Read More...', 'dina-kala' ); ?>
                            </a>
                        </div>
                        </div>
                        <?php endwhile; ?>
                    </div>
                </div>
    <?php
}
wp_reset_postdata();
} ?>

<?php if ( comments_open() ) : ?>
    <div class="shadow-box comments-list">
            <?php comments_template(); ?> 
    </div>
<?php endif; ?>
</article>
<?php endif; 
 if ($pside != 'wside') {
     get_sidebar();
 } ?>
</div>
</div>
<?php get_footer();