<?php

//Change number or products per row
add_filter('loop_shop_columns', 'dina_loop_columns', 999);
if (!function_exists('dina_loop_columns')) {
    function dina_loop_columns() {
        global $di_data;
        $prods = $di_data['product_col'];
        return $prods;
    }
}

//Change number of products that are displayed per page (shop page)
add_filter( 'loop_shop_per_page', 'dina_product_per_page', 20 );
function dina_product_per_page( $cols ) {
  global $di_data;
  $cols = $di_data['product_num'];
  return $cols;
}

//Check product is free
function dina_woo_free( $id ){
$product = wc_get_product( $id );
if ( '' === $product->get_price() || 0 == $product->get_price() && defined( 'SOMDN_PATH' )) {
    return true;
} else {
    return false;
}
}

//Free Price for free products
add_filter( 'woocommerce_get_price_html', 'aprice_free_zero_empty', 100, 2 );
function aprice_free_zero_empty( $price, $product ){
global $di_data;
$coming = get_post_meta( $product->get_id(), 'dina_coming', true );
if($coming) {
    remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
    $price= '<span class="woocommerce-Price-amount amount">'.__('Coming Soon...','dina-kala').'</span>';
} elseif ( $di_data['show_zero_call'] && ('' === $product->get_price() || 0 == $product->get_price()) ) {
    $price = '<span class="woocommerce-Price-amount amount">'.__('Call!','dina-kala').'</span>';
} elseif ( $di_data['show_free_price'] && ('' === $product->get_price() || 0 == $product->get_price()) ) {
    $price = '<span class="woocommerce-Price-amount amount">'.__('Free!','dina-kala').'</span>';
}
return $price;
}

//Change several of the breadcrumb defaults
add_filter( 'woocommerce_breadcrumb_defaults', 'dina_woocommerce_breadcrumbs' );
function dina_woocommerce_breadcrumbs() {
    return array(
            'delimiter'   => ' &#47; ',
            'wrap_before' => '<div class="row bread-row"><nav class="col-12 shadow-box breadcrumbs" itemprop="breadcrumb">',
            'wrap_after'  => '</nav></div>',
            'before'      => '',
            'after'       => '',
            'home'        => _x( 'Home', 'breadcrumb', 'woocommerce' ),
        );
}

//Show cart contents / total Ajax
add_filter( 'woocommerce_add_to_cart_fragments', 'woocommerce_header_add_to_cart_fragment' );
function woocommerce_header_add_to_cart_fragment( $fragments ) {
	global $woocommerce;
	ob_start();
	?>
	<i class="cart-amount">
    <?php echo $woocommerce->cart->cart_contents_count; ?></i>
	<?php
	$fragments['i.cart-amount'] = ob_get_clean();
	return $fragments;
}

//Total Sales of woocommerce products
function di_woo_get_total_sales() {
$total_orders = count(wc_get_orders( array(
    'status' => 'completed',
    'return' => 'ids',
    'limit' => -1,
)));
return $total_orders;
}

//Woo Dis price
function disw_price ($id){
    $product = wc_get_product( $id );
    if($product->is_type( 'variable' )){
        $r_price = $product->get_variation_regular_price( 'min' );
        $s_price = $product->get_variation_sale_price( 'min' );
    } else {
        $r_price = $product->get_regular_price();
        $s_price = $product->get_sale_price();
    }
    $d_price = (int)$r_price - (int)$s_price;
    $t_price = round(($d_price/$r_price)*100);
    return $t_price;
}

//Dina Dis price
function dina_dis_price ($id){
    $product = wc_get_product( $id );
    if($product->is_type( 'variable' )){
        $s_price = $product->get_variation_sale_price( 'min' );
    } else {
        $s_price = $product->get_sale_price();
    }
    if(!empty($s_price) && disw_price ($id) != 0) {
    $t_price ='<span class="product-dis">٪'. disw_price ($id) .'</span>';
    return $t_price;
    }
}

//dina_woo_before_single_product_summary
add_action('woocommerce_before_single_product_summary', 'dina_woo_before_single_product_summary');
function dina_woo_before_single_product_summary() { ?>
    <div class="shadow-box product-con col-12">
    <ul class="prod-opts">
        <?php 
        global $di_data;
        $rvideo = esc_html(get_post_meta( get_the_ID(), 'dina_rvideo', true ));
        $aparat = esc_html(get_post_meta( get_the_ID(), 'dina_aparat', true ));
        if(!empty($rvideo) || !empty($aparat) && is_singular('product')) { ?>
        <li data-toggle="modal" data-target="#reviewModal">
            <span data-toggle="tooltip" data-placement="left" title="<?php echo __('Product video', 'dina-kala'); ?>">
            <i aria-hidden="true" class="fal fa-play"></i>
            </span>
        </li>
        <?php } ?>
        <?php if ( $di_data['like_prod'] && class_exists( 'JVM_WooCommerce_Wishlist' ) ) { ?>
        <li>
            <span data-toggle="tooltip" data-placement="left" title="<?php echo __('Add to Wishlist', 'dina-kala'); ?>">
            <?php echo do_shortcode('[jvm_woocommerce_add_to_wishlist]'); ?>
            </span>
        </li>
        <?php } ?>
        <?php if ( $di_data['compare_prod'] && defined( 'WCCM_VERISON' ) ) { ?>
        <li>
            <?php 
            $product_id = get_the_ID();
            if ( in_array( $product_id, wccm_get_compare_list() ) ) {
                $url = wccm_get_compare_link( $product_id, 'remove-from-list' );
                $compare_title= __('Remove From Compare', 'dina-kala');
                $compare_class = "in-compare";
            }else{
                $url = wccm_get_compare_link( $product_id, 'add-to-list' );
                $compare_title= __('Compare Product', 'dina-kala');
                $compare_class = "out-compare";
            }
            ?>
            <a href="<?php echo $url; ?>" class="<?php echo $compare_class; ?>">
            <span data-toggle="tooltip" data-placement="left" title="<?php echo $compare_title; ?>">
            <i aria-hidden="true" class="fal fa-random"></i>
            </span>
            </a>
        </li>
        <?php } ?>
        <?php if($di_data['share_prod']){ ?>
        <li data-toggle="modal" data-target="#shareModal">
            <span data-toggle="tooltip" data-placement="left" title="<?php echo __('Share', 'dina-kala'); ?>">
            <i aria-hidden="true" class="fal fa-share-alt"></i>
            </span>
        </li>
        <?php } ?>
    </ul>
<?php } 

//dina_woo_after_single_product_summary
add_action('woocommerce_after_single_product_summary', 'dina_woo_after_single_product_summary');
function dina_woo_after_single_product_summary() {
    echo '</div>';
}

//Sale Flash
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
add_filter( 'woocommerce_sale_flash', 'dina_woo_sale_flash' );
function dina_woo_sale_flash( $example ) {
    global $post;
    $product = new WC_Product($post->ID);
    $in_stock = $product->is_in_stock();
    if($in_stock) {
    return '<span class="onsale">٪'.disw_price($post->ID).' '. __( 'Discount', 'dina-kala' ).'</span>';
    }
}

//dina_woo_show_page_title
add_filter( 'woocommerce_show_page_title', 'dina_woo_show_page_title' );
function dina_woo_show_page_title() {
    return false;
}

//dina_woo_add_product_class
add_filter('post_class', 'dina_woo_add_product_class');
function dina_woo_add_product_class($classes) {
    global $di_data;
    $pside = get_post_meta( get_the_ID(), 'dina_pside', true );
    $content_sticky = ($di_data['side_sticky'] ? 'content-sticky' : '');
    $classes[] .= $content_sticky;
    if($pside == 'wside') { 
     $classes[] .= 'col-12';
    }
    elseif(!empty($pside)){
        $classes[] .= 'col-lg-9 col-12';
    } elseif ($di_data['product_side'] > 0) {
    $classes[] .= 'col-lg-9 col-12';}
    else{
        $classes[] .= 'col-12';
    }
    //if(is_singular('product')) { 
    return $classes;
    //}
}


//dina_customizing_simple_products Page
add_action('woocommerce_before_single_product', 'dina_customizing_simple_products');
function dina_customizing_simple_products(){
    global $product;
    $in_stock = $product->is_in_stock();
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10);
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20);
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50);
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
        add_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 11); 
        if($in_stock) {
        add_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 27);
        }
}

//dina_before_product_title
add_action('woocommerce_single_product_summary', 'dina_before_product_title', 4);
function dina_before_product_title() {
	echo '<div class="ptitle-con">';
}


//dina_after_product_title
add_action('woocommerce_single_product_summary', 'dina_after_product_title', 10); 
function dina_after_product_title() {
	echo '</div>';
}

//Add Product Sub-title
add_action('woocommerce_single_product_summary', 'dina_product_sub_title', 9); 
function dina_product_sub_title() {
    $undertitle = get_post_meta( get_the_ID(), 'dina_under_title', true );
	echo '<div class="psub_title">'.$undertitle.'</div>';
}

//Add Product Extra
add_action('woocommerce_single_product_summary', 'dina_product_extra', 25); 
function dina_product_extra() { 
global $di_data;
    ?>
    <?php if($di_data['show_extra']) { ?>
    <div class="product_extra">
        <ul>
            <?php if($di_data['show_extra_one']) { ?>
            <li>
                <i class="<?php echo $di_data['extra_one_icon']; ?>" aria-hidden="true"></i>
                <span><?php echo $di_data['extra_one_title']; ?></span>
            </li>
            <?php } ?>
            <?php if($di_data['show_extra_two']) { ?>
            <li>
                <i class="<?php echo $di_data['extra_two_icon']; ?>" aria-hidden="true"></i>
                <span><?php echo $di_data['extra_two_title']; ?></span>
            </li>
            <?php } ?>
            <?php if($di_data['show_extra_three']) { ?>
            <li>
                <i class="<?php echo $di_data['extra_three_icon']; ?>" aria-hidden="true"></i>
                <span><?php echo $di_data['extra_three_title']; ?></span>
            </li>
            <?php } ?>
            <?php if($di_data['show_extra_four']) { ?>
            <li>
                <i class="<?php echo $di_data['extra_four_icon']; ?>" aria-hidden="true"></i>
                <span><?php echo $di_data['extra_four_title']; ?></span>
            </li>
            <?php } ?>
            <?php if($di_data['show_extra_five']) { ?>
            <li>
                <i class="<?php echo $di_data['extra_five_icon']; ?>" aria-hidden="true"></i>
                <span><?php echo $di_data['extra_five_title']; ?></span>
            </li>
            <?php } ?>
        </ul>
    </div>
<?php } }

//Delete default related product and add theme's related product
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
add_action( 'woocommerce_after_single_product_summary', 'dina_related_product', 20 );
function dina_related_product() {
global $di_data;
global $product;
if ($di_data['show_related_p']) { ?>
    <?php
            $custom_taxterms = wp_get_object_terms( get_the_ID(), $di_data['related_p_by'], array('fields' => 'ids') );
            $args = array(
            'post_type' => 'product',
            'post_status' => 'publish',
            'posts_per_page' => $di_data['related_p_count'],
            'orderby' => 'rand',
            'tax_query' => array(
                array(
                    'taxonomy' => $di_data['related_p_by'],
                    'field' => 'id',
                    'terms' => $custom_taxterms
                )
            ),
            'post__not_in' => array (get_the_ID()),
            );

            if($di_data['show_out_prod']){
				$args['meta_query'] = array(
						'relation' => 'AND',
						array(
							'key' => '_stock_status',
							'value' => 'instock'
						)
					);
			}

            $related_items = new WP_Query( $args ); ?>
			<?php
             if ($related_items->have_posts()) { 
				 ?>
			<div class="product-block related block">
                    <div class="block-title">
                        <h2>
                            <i class="fal fa-shopping-bag" aria-hidden="true"></i>
                            <?php _e('Related Products','dina-kala') ?>
                        </h2>
                    </div>
                    <div class="owl-carousel" <?php if ( $di_data['show_arrows'] ) { echo 'data-itemnavs="true"'; } else { echo 'data-itemnavs="false"'; } ?> <?php if ( $di_data['prod_loop'] ) { echo 'data-itemloop="true"'; } else { echo 'data-itemloop="false"'; } ?> <?php if ( $di_data['auto_play'] ) { echo 'data-itemplay="true"'; } else { echo 'data-itemplay="false"'; } ?> data-itemscount="<?php echo $di_data['pcount']; ?>">
                    <?php
                        while ( $related_items->have_posts() ) : $related_items->the_post(); ?>
                        <?php global $product;
                            $in_stock = $product->is_in_stock();
                            $stock_class = ($in_stock ? '' : ' prod-out-stock'); ?>
                        <div class="item">
                            <div class="shadow-box mini-product<?php echo $stock_class; ?>">
                                <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="product-link">
                                    <?php p_img() ?>
                                    <?php if($in_stock) { ?>
                                    <?php echo dina_dis_price(get_the_ID()); ?>
                                    <?php } ?>
                                    <span class="product-title">
                                        <?php the_title(); ?>
                                    </span>
                                    <span class="product-price">
                                    <?php if($in_stock) { ?>
                                        <span class="price-con">
                                        <?php echo $product->get_price_html(); ?>
                                        </span>
                                    <?php } else { ?>
                                        <span class="price-con">
                                        <?php _e( 'Out of stock', 'dina-kala' ); ?>
                                        </span>
                                    <?php } ?>
                                    </span>
                                </a>
                                <a href="<?php the_permalink(); ?>" class="btn btn-success btn-buy">
                                    <i class="fal fa-cart-plus" aria-hidden="true"></i>
                                    <?php if($in_stock) { ?>
                                        <?php _e( 'View And Buy', 'dina-kala' ); ?>
                                    <?php } else { ?>
                                        <?php _e( 'View Product', 'dina-kala' ); ?>
                                    <?php } ?>
                                </a>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    </div>
                </div>
    <?php }} 
wp_reset_postdata();
}

//dina_woo_before_main_content
add_action('woocommerce_before_main_content', 'dina_woo_before_main_content',21);
function dina_woo_before_main_content() {
    global $di_data;
    if(!is_singular('product')){
    $side = ($di_data['product_archive_side'] == 2 ? ' right-side' : ''); ?>
    <div class="row prod-row<?php echo $side ?>">
<?php } else {
    $pside = get_post_meta( get_the_ID(), 'dina_pside', true );
    if($pside == 'rside') { 
        $side = ' right-side';
    } 
    elseif ($pside == 'lside') {
        $side = '';
    }
    elseif($di_data['product_side'] == 2){
        $side = ' right-side';
    }
    else{
        $side = '';
    } ?>
    <div class="row prod-row<?php echo $side ?>">
    <?php }
}

//dina_woo_after_main_content
add_action('woocommerce_after_main_content', 'dina_woo_after_main_content');
function dina_woo_after_main_content() { ?>
    </div>    
<?php }

//dina_woo_before_shop_loop
add_action('woocommerce_before_shop_loop', 'dina_woo_before_shop_loop');
function dina_woo_before_shop_loop() { 
global $di_data;
$content_sticky = ($di_data['side_sticky'] ? ' content-sticky' : '');
$ajax_prod = ($di_data['ajax_prod'] ? ' ajax-prod' : '');
$col = ($di_data['product_archive_side'] == 0 ? 'col-12' : 'col-lg-9 col-12'); ?>
<div class="<?php echo $col; ?><?php echo $content_sticky; ?><?php echo $ajax_prod; ?>">
<div class="col-12 shadow-box woocommerce-ordering-con">
<?php }

//dina_woo_after_order
add_action('woocommerce_before_shop_loop', 'dina_woo_after_order',35);
function dina_woo_after_order() { ?>
</div>
<?php }


//dina_woo_after_shop_loop
add_action('woocommerce_after_shop_loop', 'dina_woo_after_shop_loop',15);
function dina_woo_after_shop_loop() { ?>
    </div>    
<?php }

//remove woocommerce_breadcrumb
if(!$di_data['show_bread']) {
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
}

//Product Video Modal
add_action( 'wp_footer', 'dina_video_modal' );
function dina_video_modal() { 
    $rvideo = esc_html(get_post_meta( get_the_ID(), 'dina_rvideo', true ));
    $aparat = esc_html(get_post_meta( get_the_ID(), 'dina_aparat', true ));
    if(!empty($rvideo) || !empty($aparat) && is_singular('product')) {
    ?>
    <!-- The Video Review Modal -->
<div class="modal fade<?php if(!empty($rvideo)){ echo ' vmodal';}else{ echo ' amodal';} ?>" id="reviewModal">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <!-- Video Review Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title"><i class="fal fa-play" aria-hidden="true"></i><?php the_title(); ?></h4>
        <button type="button" class="close" data-dismiss="modal">
            <i class="fal fa-times" aria-hidden="true"></i>
        </button>
      </div>
      <!-- Video Review Modal body -->
      <div class="modal-body">
        <?php 
        if(!empty($rvideo)){
        echo '<video controls><source src="'.$rvideo.'" id="rVideo"></video>';
        } else {
         echo '<div id="15305363563383534"><script type="text/JavaScript" src="https://www.aparat.com/embed/'.$aparat.'?data[rnddiv]=15305363563383534&data[responsive]=yes"></script></div>';
         } ?>
      </div>

    </div>
  </div>
</div>
<?php } }

//Product & Post Share Modal
add_action( 'wp_footer', 'dina_share_modal' );
function dina_share_modal() { 
    global $post;
    if('post' == $post->post_type || 'product' == $post->post_type) {
    ?>
    <!-- The Share Modal -->
<div class="modal fade" id="shareModal">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <!-- Share Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title"><i class="fal fa-share-alt" aria-hidden="true"></i><?php _e('Share on social networks','dina-kala') ?></h4>
        <button type="button" class="close" data-dismiss="modal">
            <i class="fal fa-times" aria-hidden="true"></i>
        </button>
      </div>
      <!-- Share Modal body -->
      <div class="modal-body">
        <ul class="social-box">
            <li><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Facebook', 'dina-kala' ); ?>" href="http://www.facebook.com/sharer.php?u=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="fab fa-facebook-f" aria-hidden="true"></i></a></li>
            <li><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Google+', 'dina-kala' ); ?>" href="https://plus.google.com/share?url=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="fab fa-google-plus-g" aria-hidden="true"></i></a></li>
            <li><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Pinterest', 'dina-kala' ); ?>" href="http://pinterest.com/pin/create/link/?url=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="fab fa-pinterest-p" aria-hidden="true"></i></a></li>
            <li><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Twitter', 'dina-kala' ); ?>" href="http://www.twitter.com/share?url=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="fab fa-twitter" aria-hidden="true"></i></a></li>
            <li><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Linkedin', 'dina-kala' ); ?>" href="http://www.linkedin.com/shareArticle?mini=true&url=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="fab fa-linkedin-in" aria-hidden="true"></i></a></li>
            <li><a data-toggle="tooltip" data-placement="top" title="<?php _e('Cloob','dina-kala'); ?>" href="http://www.cloob.com/share/link/add?url=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="ico-cloob" aria-hidden="true"></i></a></li>
            <li><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Telegram', 'dina-kala' ); ?>" href="https://telegram.me/share/url?url=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="fab fa-telegram-plane" aria-hidden="true"></i></a></li>
            <li><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Whatsapp', 'dina-kala' ); ?>" href="https://wa.me/?text=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="fab fa-whatsapp" aria-hidden="true"></i></a></li>
            <li><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Email', 'dina-kala' ); ?>" href="mailto:?subject=<?php the_title(); ?>&body=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="fal fa-envelope" aria-hidden="true"></i></a></li>
        </ul>
        <div class="short-con">
            <span class="short-text"><?php _e('Shortlink:','dina-kala') ?></span>
            <span class="short-link"><?php echo wp_get_shortlink(); ?></span>
            <span data-toggle="tooltip" data-placement="top" title="<?php _e( 'Copy Link', 'dina-kala' ); ?>" class="short-btn" onclick="copyToClipboard('.short-link')"><i class="fal fa-copy" aria-hidden="true"></i></span>
        </div>
        <div class="link-copy"><?php _e( 'Link copied!', 'dina-kala' ); ?></div>
      </div>

    </div>
  </div>
</div>
<?php } }

//dina_woo_product_features
add_action('woocommerce_single_product_summary', 'dina_woo_product_features', 24);
function dina_woo_product_features(){
    global $di_data;
    $features = get_post_meta( get_the_ID(), 'dina_product_features', true );
    if(!empty($features)) {
    echo '<div class="product-features">';
    if($di_data['show_prodf_title']) { echo '<strong>'.__('Product Features:', 'dina-kala').'</strong>'; }
        echo '<ul>';
            foreach ( (array) $features as $key => $feature ) {
                $ftitle = $fdesc = '';
                if ( isset( $feature['ftitle'] ) ) {
                    $ftitle = esc_html( $feature['ftitle'] );
                }
                if ( isset( $feature['fdesc'] ) ) {
                    $fdesc = esc_html( $feature['fdesc'] );
                }
                if(!empty($ftitle) && !empty($fdesc)){
                echo '<li><span class="ftitle">'.$ftitle.': </span><span class="fdesc">'.$fdesc.'</span></li>';
                }
            }
    echo '</div></ul>';
} }

//dina_before_price
add_action('woocommerce_single_product_summary', 'dina_before_price', 26);
function dina_before_price(){
    echo '<div class="price-con">';
}

//dina_after_price
add_action('woocommerce_single_product_summary', 'dina_after_price', 31);
function dina_after_price(){
    echo '</div>';
}

//dina_override_default_template for product quantity
add_filter('woocommerce_locate_template', 'dina_override_default_template', 9999, 3);
function dina_override_default_template( $template, $template_name, $template_path ) {		
    if ($template_name == 'global/quantity-input.php') {
        $template = DI_DIR . '/includes/quantity.php';;			
    }		
    return $template;
}


//dina_before_account_navigation
add_action('woocommerce_before_account_navigation', 'dina_before_account_navigation');
function dina_before_account_navigation(){
    $before = '<div class="woocommerce-MyAccount-navigation-con">';
    $user = wp_get_current_user(); 
	$before .= get_avatar(get_current_user_id() , 120,'' ,$user->display_name );
    $before .='<span class="side-uname">'. $user->display_name .'</span>';
	if (class_exists('WooWallet'))
	{
        $wallet = woo_wallet()->wallet->get_wallet_balance( get_current_user_id() );
        $before .= '<span class="m-wallet">'.__('Wallet Inventory: ','dina-kala').$wallet.'</span>';
    }
    echo $before;
}

//dina_after_account_navigation
add_action('woocommerce_after_account_navigation', 'dina_after_account_navigation');
function dina_after_account_navigation(){
    echo '</div>';
}

//dina_pagination_args
add_filter( 'woocommerce_pagination_args', 'dina_pagination_args' );
function dina_pagination_args() {
$total   = isset( $total ) ? $total : wc_get_loop_prop( 'total_pages' );
$current = isset( $current ) ? $current : wc_get_loop_prop( 'current_page' );
$base    = isset( $base ) ? $base : esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) );
$format  = isset( $format ) ? $format : '';
if ( $total <= 1 ) {
	return;
}
    return array(
        'base'         => $base,
        'format'       => $format,
        'add_args'     => false,
        'current'      => max( 1, $current ),
        'total'        => $total,
        'prev_text' => __('<i class="fal fa-chevron-right" aria-hidden="true" title="Next"></i>') ,
        'next_text' => __('<i class="fal fa-chevron-left" aria-hidden="true" title="Prev"></i>') ,
        'type'         => 'list',
        'end_size'     => 3,
        'mid_size'     => 3,
        );
}

//dina_cart_item_name
add_filter( 'woocommerce_cart_item_name', 'dina_cart_item_name', 10, 3 );
function dina_cart_item_name( $item_name,  $cart_item,  $cart_item_key ) {

    return '<span class="side-cart-name">'.$item_name.'</span>';
}

//dina_no_products_found
remove_action( 'woocommerce_no_products_found', 'wc_no_products_found' );
add_action('woocommerce_no_products_found', 'dina_no_products_found', 10);
function dina_no_products_found(){
global $di_data;
$content_sticky = ($di_data['side_sticky'] ? ' content-sticky' : '');
$col = ($di_data['product_archive_side'] == 0 ? 'col-12' : 'col-lg-9 col-12');
 ?>
    <div class="<?php echo $col; ?><?php echo $content_sticky; ?>">
     <div class="alert alert-warning" role="alert">
         <strong><span class="fal fa-bell fa-lg" aria-hidden="true">
         </span> <?php _e('No products found!','dina-kala') ?></strong>
      </div>
    </div>
<?php }


//Add WooCommerce the_excerpt before the_content
add_filter('the_content', 'dina_before_woo_content');
function dina_before_woo_content($content) {
    global $post;
    if(is_product() && !empty($post->post_excerpt))
    {
        $beforecontent = '<blockquote class="prod-excerpt blockquote">';
        $beforecontent .= '<i class="fal fa-pen-alt" aria-hidden="true"></i>';
        $beforecontent .= $post->post_excerpt;
        $beforecontent .= '</blockquote>';
        $content = $beforecontent . $content;
        return $content;
    } else {
        return $content;
    }
}

//Remove tabs heading
add_filter( 'woocommerce_product_additional_information_heading','dina_return_empty');
add_filter( 'woocommerce_product_description_heading','dina_return_empty');
function dina_return_empty() {
    return '';
}

//Remove Favorite button product archive pages
if ( class_exists( 'JVM_WooCommerce_Wishlist' ) ) {
    remove_action( 'woocommerce_after_shop_loop_item', 'jvm_woocommerce_add_to_wishlist', 15 );
    remove_action( 'woocommerce_after_add_to_cart_button', 'jvm_woocommerce_add_to_wishlist' );
}

//Remove Compare button product archive pages
if (defined( 'WCCM_VERISON' )) {
    remove_action( 'woocommerce_before_shop_loop', 'wccm_register_add_compare_button_hook' );
    remove_action( 'woocommerce_single_product_summary', 'wccm_add_single_product_compare_buttton', 35 );
    remove_action( 'woocommerce_before_shop_loop', 'wccm_render_catalog_compare_info' );
    remove_action( 'wp_enqueue_scripts', 'wccm_enqueue_catalog_scripts' );
    remove_action( 'widgets_init', 'wccm_widgets_init' );
}


//Show Product Category Description
remove_action( 'woocommerce_archive_description', 'woocommerce_taxonomy_archive_description' );
remove_action( 'woocommerce_archive_description', 'woocommerce_product_archive_description' );
add_action('woocommerce_after_shop_loop', 'dina_product_archive_description', 13);
function dina_product_archive_description() {
    if ( is_search() || is_shop() ) { 
        return;
    } 
    the_archive_description('<div class="shadow-box cat-desc col-12">
    <div class="cat-text" data-more="'.__('Show More','dina-kala').'" data-less="'.__('Show Less','dina-kala').'">','</div>
    </div>');
}


//Ajax Load More
if($di_data['ajax_prod']){
add_action('woocommerce_after_shop_loop', 'dina_product_load_more', 11);
}
function dina_product_load_more() { ?> 
<div class="col-12 load-more">
	<div class="page-load-status">
		<p class="infinite-scroll-request"><i class="fal fa-spinner-third fa-spin" aria-hidden="true"></i></p>
		<p class="infinite-scroll-last alert alert-info"><?php _e('End of content','dina-kala') ?></p>
		<p class="infinite-scroll-error alert alert-info"><?php _e('No more pages to load','dina-kala') ?></p>
	</div>
	<span id="load-more-button" class="btn btn-outline-dina"><?php _e('Load More Products','dina-kala') ?></span>
</div>
<?php }


//Change additional information tab title
add_filter( 'woocommerce_product_tabs', 'dina_rename_tabs', 98 );
function dina_rename_tabs( $tabs ) {
    global $product;
    if( $product->has_attributes() || $product->has_dimensions() || $product->has_weight() ) {
        $tabs['additional_information']['title'] = __( 'Product Features', 'dina-kala' );
    }
    return $tabs;
}

//Add Affiliate link to my account page
if( class_exists( 'Affiliate_WP' ) ) {
add_filter ( 'woocommerce_account_menu_items', 'affiliate_one_more_link' );
function affiliate_one_more_link( $menu_links ){
	// we will hook "affiliate-wp" later
	$new = array( 'affiliate-wp' => __('Affiliates' , 'dina-kala') ); 
	// or in case you need 2 links
	// $new = array( 'link1' => 'Link 1', 'link2' => 'Link 2' );

	// array_slice() is good when you want to add an element between the other ones
	$menu_links = array_slice( $menu_links, 0, 5, true ) 
	+ $new 
	+ array_slice( $menu_links, 1, NULL, true );
	return $menu_links;
}
add_filter( 'woocommerce_get_endpoint_url', 'affiliate_hook_endpoint', 5, 4 );
function affiliate_hook_endpoint( $url, $endpoint, $value, $permalink ){
	if( $endpoint === 'affiliate-wp' ) {
		// ok, here is the place for your custom URL, it could be external
		$url = esc_url( affwp_get_affiliate_area_page_url() );
	}
	return $url;
}
}

//Set template of Dokan dashboard
if( class_exists( 'WeDevs_Dokan' ) ) { 
add_filter( 'page_template', 'dokan_page_template' );
function dokan_page_template( $page_template ) {
    global $post;
    $post_id = $post->ID;
    if($post_id === dokan_get_option( 'dashboard', 'dokan_pages' ) ) {
            $page_template = get_stylesheet_directory() . '/dashboard.php'; 
    } 
    return $page_template;
}
}

//dina_dokan_dashboard_wrap_start
add_action('dokan_dashboard_wrap_start', 'dina_dokan_dashboard_wrap_start', 10);
function dina_dokan_dashboard_wrap_start(){
    global $di_data;
 ?>
    <div class="container main-con">
        <?php if($di_data['show_bread']) { woocommerce_breadcrumb(); }  ?>
        <div class="row">
            <article role="main" class="col-12">
<?php }

//dina_dokan_dashboard_wrap_end
add_action('dokan_dashboard_wrap_end', 'dina_dokan_dashboard_wrap_end', 10);
function dina_dokan_dashboard_wrap_end(){
 ?>
        </article>
    </div>
</div>
<?php }

//Check User is Dokan Seller
function user_seller(){
    if (class_exists('WeDevs_Dokan')) {
        if (is_user_logged_in()) {
            $user = wp_get_current_user();
            $user_id = get_current_user_id();
        }
        $user_seller = dokan_is_user_seller($user_id);
    }
    if($user_seller) {
        return true;
    }
}

//Get Seller Dashboard Address
function user_dashboard() {
    if (class_exists('WeDevs_Dokan')) {
        if (is_user_logged_in()) {
            $user = wp_get_current_user();
        }
    if ( user_can( $user, 'dokandar' ) ) {
            $seller_dashboard = dokan_get_option( 'dashboard', 'dokan_pages' );
            if ( $seller_dashboard != -1 ) {
                $seller_page = get_permalink( $seller_dashboard );
            }
    }
    return $seller_page;
    }
}

//Add Dokan link to my account page
if( class_exists( 'WeDevs_Dokan' ) ) {
    if(user_seller()) {
        add_filter ( 'woocommerce_account_menu_items', 'dokan_acc_link' );
        function dokan_acc_link( $menu_links ) {
            $new = array( 'dokan-link' => __('Vendor Dashboard' , 'dina-kala') ); 
            $menu_links = array_slice( $menu_links, 0, 1, true )
            + $new 
            + array_slice( $menu_links, 1, NULL, true );
            return $menu_links;
        }

        add_filter( 'woocommerce_get_endpoint_url', 'dokan_hook_endpoint', 5, 4 );
        function dokan_hook_endpoint( $url, $endpoint, $value, $permalink ) {
            if( $endpoint === 'dokan-link' ) {
                $url = esc_url( user_dashboard() );
            }
            return $url;
        }
    }
}

//Option to remove product sku
if(!$di_data['show_prod_sku']) {
    add_filter( 'wc_product_sku_enabled', 'sv_remove_product_page_skus' );
}
function sv_remove_product_page_skus( $enabled ) {
    if ( ! is_admin() && is_product() ) {
        return false;
    }
    return $enabled;
}

//Hide Price Range for WooCommerce Variable Products
if($di_data['remove_price_range']) {
add_filter( 'woocommerce_variable_sale_price_html', 
'lw_variable_product_price', 10, 2 );
add_filter( 'woocommerce_variable_price_html', 
'lw_variable_product_price', 10, 2 );

function lw_variable_product_price( $v_price, $v_product ) {

// Product Price
$prod_prices = array( $v_product->get_variation_price( 'min', true ), 
                            $v_product->get_variation_price( 'max', true ) );
$prod_price = $prod_prices[0]!==$prod_prices[1] ? wc_price( $prod_prices[0] ) : wc_price( $prod_prices[0] );

// Regular Price
$regular_prices = array( $v_product->get_variation_regular_price( 'min', true ), 
                          $v_product->get_variation_regular_price( 'max', true ) );
sort( $regular_prices );
$regular_price = $regular_prices[0]!==$regular_prices[1] ? wc_price( $regular_prices[0] ) : wc_price( $regular_prices[0] );

if ( $prod_price !== $regular_price ) {
$prod_price = '<del>'.$regular_price.$v_product->get_price_suffix() . '</del> <ins>' . 
                       $prod_price . $v_product->get_price_suffix() . '</ins>';
}
return $prod_price;
}
}

//Remove dowload item from woo menu
function remove_my_account_download_items( $items ) {
    unset($items['downloads']);
    return $items;
}
if($di_data['remove_download']) {
add_filter( 'woocommerce_account_menu_items', 'remove_my_account_download_items' );
}