<?php
namespace Elementor;

class Special_Offer extends Widget_Base {
	
	public function get_name() {
		return 'special-offer';
	}
	
	public function get_title() {
		return __( 'Special offer', 'dina-kala' );
	}
	
	public function get_icon() {
		return 'fal fa-star';
	}
	
	public function get_categories() {
		return [ 'dina-kala' ];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Special offer', 'dina-kala' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'Title', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your title', 'dina-kala' ),
                'default' => __( 'Special offer', 'dina-kala' ),
			]
		);

		$this->add_control(
			'site_name',
			[
				'label' => __( 'Site name', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your site name', 'dina-kala' ),
                'default' => __( 'Sample', 'dina-kala' ),
			]
        );

        $this->add_control(
			'show_dis',
			[
				'label' => __( 'Only show discounted products', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->add_control(
			'out_stock',
			[
				'label' => __( 'Text finished product in stock', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Out of stock!', 'dina-kala' ),
                'default' => __( 'Out of stock!', 'dina-kala' ),
			]
        );

        $this->add_control(
			'out_icon',
			[
				'label' => __( 'Show out of stock icon', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        $this->add_control(
			'auto_play',
			[
				'label' => __( 'Auto play', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'time',
			[
				'label' => __( 'Auto play speed(ms)', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1000,
				'max' => 20000,
				'step' => 1000,
				'default' => 8000,
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();
        
        ?>
        
        <div class="row shadow-box special-box">
                <?php 

                    $args = array(
                   'posts_per_page' => 5,
                   'post_type' => 'product',
                   'post_status' => 'publish',
                   'meta_query' => array(
                    'relation' => 'AND',
                    array(
                        'key' => 'dina_special',
                        'value' => 'on',
                        'compare' => '='
                    )
                    ),
                   'order' => 'DESC'  );

                    if ( 'yes' === $settings['show_dis'] ) {
                    $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
                    }

                   $specialpost = new \WP_Query( $args );

                if ( $specialpost->have_posts() ) { ?>
                <div class="col-lg-8 col-12 owl-carousel special-slider" <?php if ( 'yes' === $settings['auto_play'] ) { echo 'data-itemplay="true"'; } else { echo 'data-itemplay="false"'; } ?> data-itemtime="<?php echo $settings['time']; ?>">
                    <?php while ( $specialpost->have_posts() ) : $specialpost->the_post();
                    $product = wc_get_product( get_the_ID() );
                    if($product->is_type( 'variable' )) {
                        $r_price = $product->get_variation_regular_price( 'min' ). get_woocommerce_currency_symbol();
                        $s_price = $product->get_variation_sale_price( 'min' ). get_woocommerce_currency_symbol();
                    } else {
                        $r_price = $product->get_regular_price(). get_woocommerce_currency_symbol();
                        $s_price = $product->get_sale_price(). get_woocommerce_currency_symbol();
                    }
                    ?>
                    <?php $stockq=$product->get_stock_quantity(); ?>
                    <div class="col-12 item">
                        <?php if($stockq === 0) { ?>
                        <div class="pnot-in-stock">
                            <span class="not-stock-text">
                                <?php if ( 'yes' === $settings['out_icon'] ) { ?>
                                    <i class="fal fa-frown" aria-hidden="true"></i>
                                <?php } ?>
                                <?php echo $settings['out_stock']; ?>
                            </span>
                        </div>
                        <?php } ?>
                        <?php if($stockq === 0) { ?>
                            <div class="pblur">
                        <?php } ?>
                                <?php if($product->is_on_sale()) { ?>
                                <span class="sp-discount"><span>٪<?php echo disw_price(get_the_ID()) ?> <?php echo __( 'Discount', 'dina-kala' ); ?></span></span>
                                <?php } ?>
                                <div class="col-md-4 special-img">
                                    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                                    <?php p_img(); ?>
                                    </a>
                                </div>
                                <div class="col-md-8 special-text">
                                    <div class="sp-stitle">
                                <?php echo $settings['title']; ?> <span class="sp-red"><?php echo $settings['site_name']; ?></span>
                                    </div>
                                    <div class="col-12 sp-title">
                                        <i class="fal fa-chevron-left" aria-hidden="true"></i>
                                        <?php the_title(); ?>
                                    </div>
                                    
                                    <div class="col-12 sp-price">
                                        <?php if($product->is_on_sale()) { ?>
                                            <span class="sp-rprice"><del><?php echo wc_price($r_price); ?></del></span>
                                            <span class="sp-sprice"><?php echo wc_price($s_price); ?></span>
                                        <?php } else { ?>
                                            <span class="sp-sprice"><?php echo wc_price($r_price); ?></span>
                                        <?php } ?>
                                    </div>
                                    
                                    <?php 
                                        if($product->is_type( 'variable' )){
                                            $children_ids = $product->get_children();
                                            $children_id = $children_ids[0];
                                            $date = get_post_meta( $children_id, '_sale_price_dates_to', true );
                                        } else {
                                            $date = get_post_meta( get_the_ID(), '_sale_price_dates_to', true );
                                        }
                                        if(!empty($date)){
                                        $date += 24*60*60;
                                        $sale_price_date = ( $date ) ? date( 'Y/m/d', $date ) : ''; ?>
                                    <?php if($product->is_on_sale()) { ?>
                                    <div class="col-12">
                                        <div class="salecount" data-countdown="<?php echo $sale_price_date; ?>"></div>
                                    </div>
                                    <?php } ?>
                                    <?php } ?>
                                    
                                    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="btn btn-outline-dina sp-btn">
                                        <i class="fal fa-cart-plus" aria-hidden="true"></i>
                                        <?php echo __( 'Buy product', 'dina-kala' ); ?>
                                    </a>
                                </div>
                        <?php if($stockq === 0) { ?>
                            </div>
                        <?php } ?>
                    </div>
                    <?php endwhile; ?>
                </div>
                <div class="col-lg-4 d-none d-lg-block special-title">
                    <ul id="slider-nav">
                        <?php while ( $specialpost->have_posts() ) : $specialpost->the_post(); ?>
                        <li>
                        <?php the_title(); ?>
                        </li>
                        <?php endwhile; ?>
                    </ul>
                </div>
                <?php } else { 
                    echo '<div class="col-12 not-msg">'.__( 'No product with the desired conditions was found.', 'dina-kala' ).'</div>';
                } ?>
            </div>
         <?php

	}

}