<?php
namespace Elementor;

class Our_Service_Box extends Widget_Base {
	
	public function get_name() {
		return 'our-service-box';
	}
	
	public function get_title() {
		return __( 'Our Service Box', 'dina-kala' );
	}
	
	public function get_icon() {
		return 'fal fa-th-large';
	}
	
	public function get_categories() {
		return [ 'dina-kala' ];
	}
	
	protected function _register_controls() {
		require get_template_directory() . '/includes/widgets/fa.php';
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Our Service Box', 'dina-kala' ),
			]
		);
		
		$this->add_control(
			'title_one',
			[
				'label' => __( 'Title One', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your title', 'dina-kala' ),
                'default' => __( 'Price Guarantee', 'dina-kala' ),
			]
		);

		$this->add_control(
			'subtitle_one',
			[
				'label' => __( 'Subtitle One', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your subtitle', 'dina-kala' ),
                'default' => __( 'Best market price', 'dina-kala' ),
			]
        );
		
		$this->add_control(
			'icon_one',
			[
				'label' => __( 'Icon One', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'credit-card '
			]
		);
        
        $this->add_control(
			'title_two',
			[
				'label' => __( 'Title Two', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your title', 'dina-kala' ),
                'default' => __( 'Excellent support', 'dina-kala' ),
			]
		);

		$this->add_control(
			'subtitle_two',
			[
				'label' => __( 'Subtitle Two', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your subtitle', 'dina-kala' ),
                'default' => __( '24 hours, 7 days a week', 'dina-kala' ),
			]
        );
		
		$this->add_control(
			'icon_two',
			[
				'label' => __( 'Icon Two', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'headset '
			]
		);
        
        $this->add_control(
			'title_three',
			[
				'label' => __( 'Title Three', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your title', 'dina-kala' ),
                'default' => __( 'Refund', 'dina-kala' ),
			]
		);

		$this->add_control(
			'subtitle_three',
			[
				'label' => __( 'Subtitle Three', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your subtitle', 'dina-kala' ),
                'default' => __( 'If not satisfied', 'dina-kala' ),
			]
        );
        
		$this->add_control(
			'icon_three',
			[
				'label' => __( 'Icon Three', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'history '
			]
		);
        
        $this->add_control(
			'title_four',
			[
				'label' => __( 'Title Four', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your title', 'dina-kala' ),
                'default' => __( 'Originality goods', 'dina-kala' ),
			]
		);

		$this->add_control(
			'subtitle_four',
			[
				'label' => __( 'Subtitle Four', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your subtitle', 'dina-kala' ),
                'default' => __( 'From Top Brands', 'dina-kala' ),
			]
        );
		
		$this->add_control(
			'icon_four',
			[
				'label' => __( 'Icon Four', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'certificate '
			]
		);
        
        $this->add_control(
			'title_five',
			[
				'label' => __( 'Title Five', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your title', 'dina-kala' ),
                'default' => __( 'Fast delivery', 'dina-kala' ),
			]
		);

		$this->add_control(
			'subtitle_five',
			[
				'label' => __( 'Subtitle Five', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your subtitle', 'dina-kala' ),
                'default' => __( 'The least time possible', 'dina-kala' ),
			]
        );

		$this->add_control(
			'icon_five',
			[
				'label' => __( 'Icon Five', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'shipping-fast '
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();
        
		?>
		<!-- Services -->
            <div class="row services">
                <div class="col-sm-3">
                    <div class="service shadow-box">
                        <div class="col-lg-3 col-12 service-icon">
							<i class="fal fa-<?php echo $settings['icon_one']; ?>" aria-hidden="true"></i>
                        </div>
                        <div class="col-lg-9 col-12 service-det">
                            <span class="service-title"><?php echo $settings['title_one']; ?></span>
                            <span class="service-desc d-none d-lg-block"><?php echo $settings['subtitle_one']; ?></span>
                        </div>
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="service shadow-box">
                        <div class="col-lg-3 col-12 service-icon">
						<i class="fal fa-<?php echo $settings['icon_two']; ?>" aria-hidden="true"></i>	
                        </div>
                        <div class="col-lg-9 col-12 service-det">
                            <span class="service-title"><?php echo $settings['title_two']; ?></span>
                            <span class="service-desc d-none d-lg-block"><?php echo $settings['subtitle_two']; ?></span>
                        </div>
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="service shadow-box">
                        <div class="col-lg-3 col-12 service-icon">
							<i class="fal fa-<?php echo $settings['icon_three']; ?>" aria-hidden="true"></i>
                        </div>
                        <div class="col-lg-9 col-12 service-det">
                            <span class="service-title"><?php echo $settings['title_three']; ?></span>
                            <span class="service-desc d-none d-lg-block"><?php echo $settings['subtitle_three']; ?></span>
                        </div>
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="service shadow-box">
                        <div class="col-lg-3 col-12 service-icon">
							<i class="fal fa-<?php echo $settings['icon_four']; ?>" aria-hidden="true"></i>
                        </div>
                        <div class="col-lg-9 col-12 service-det">
                            <span class="service-title"><?php echo $settings['title_four']; ?></span>
                            <span class="service-desc d-none d-lg-block"><?php echo $settings['subtitle_four']; ?></span>
                        </div>
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="service shadow-box">
                        <div class="col-lg-3 col-12 service-icon">
							<i class="fal fa-<?php echo $settings['icon_five']; ?>" aria-hidden="true"></i>
                        </div>
                        <div class="col-lg-9 col-12 service-det">
                            <span class="service-title"><?php echo $settings['title_five']; ?></span>
                            <span class="service-desc d-none d-lg-block"><?php echo $settings['subtitle_five']; ?></span>
                        </div>
                    </div>
                </div>
            </div>
        <!-- Services --> <?php

	}

}