<?php
namespace Elementor;

class Dina_Woo_Products extends Widget_Base {

	public function get_name() {
		return 'dina-woo-products';
	}
	
	public function get_title() {
		return __( 'Dina Woo Products', 'dina-kala' );
	}
	
	public function get_icon() {
		return 'fal fa-shopping-cart';
	}
	
	public function get_categories() {
		return [ 'dina-kala' ];
	}
	
	protected function _register_controls() {
	require get_template_directory() . '/includes/widgets/fa.php';
		$prod_cata = array();
		$categories = get_terms("product_cat");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
		foreach ( $categories as $category ) {
		$prod_cata[ $category->term_id ] = $category->name;
		}
		}

		$prod_taga = array();
		$tags = get_terms("product_tag");
		if ( !empty( $tags ) && !is_wp_error( $tags ) ){
		foreach ( $tags as $tag ) {
		$prod_taga[ $tag->term_id ] = $tag->name;
		}
		}

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Dina Woo Products', 'dina-kala' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'Title', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your title', 'dina-kala' ),
			]
		);

		$this->add_control(
			'prod_sort',
			[
				'label' => __( 'Product sorting', 'dina-kala' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'  => __( 'Latest products', 'dina-kala' ),
					'random' => __( 'Random products', 'dina-kala' ),
					'viewed' => __( 'Most viewed products', 'dina-kala' ),
					'saled' => __( 'Best selling products', 'dina-kala' ),
					'discounted' => __( 'Discounted products', 'dina-kala' ),
					'special' => __( 'Special products', 'dina-kala' ),
				],
			]
		);

		$this->add_control(
			'prod_filter',
			[
				'label' => __( 'Product filtering', 'dina-kala' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'category',
				'options' => [
					'category'  => __( 'Products category', 'dina-kala' ),
					'tag' => __( 'Products tag', 'dina-kala' ),
				],
			]
		);

		$this->add_control(
			'product_cat',
			[
				'label' => __( 'Product category', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $prod_cata,
			]
		);

		$this->add_control(
			'product_tag',
			[
				'label' => __( 'Product tag', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $prod_taga,
			]
		);

		$this->add_control(
			'out_prod',
			[
				'label' => __( 'Show in stock products', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'product_icon',
			[
				'label' => __( 'Icon', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
			]
		);

		$this->add_control(
			'white_title',
			[
				'label' => __( 'White title (Suitable for background mode)', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'white_box',
			[
				'label' => __( 'White box style', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'show_arrows',
			[
				'label' => __( 'Show Arrows', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'auto_play',
			[
				'label' => __( 'Auto play', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'prod_loop',
			[
				'label' => __( 'Product loop', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'ptotalcount',
			[
				'label' => __( 'Product total count', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 8,
				'max' => 20,
				'step' => 1,
				'default' => 8,
			]
		);

		$this->add_control(
			'pcount',
			[
				'label' => __( 'Product columns count', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 4,
				'max' => 6,
				'step' => 1,
				'default' => 5,
			]
		);

		$this->add_control(
			'view_all',
			[
				'label' => __( 'Display view all button (If category or tag selected)', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		
		$this->end_controls_section();
	}
	
	protected function render() {
        $settings = $this->get_settings_for_display(); ?>
        <div class="product-block<?php if ( 'yes' === $settings['white_title'] ) { echo ' white-title'; } ?><?php if ( 'yes' === $settings['white_box'] ) { echo ' white-box'; } ?>">
		<?php
		$prod_sort = $settings['prod_sort'];
		$prod_filter = $settings['prod_filter'];
		$product_cat = $settings['product_cat'];
		$product_tag = $settings['product_tag'];

			if($prod_sort != 'special'){
			switch ($prod_sort) {
				case 'latest':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'order' => 'DESC'  );
					break;
				case 'saled':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'meta_key' => 'total_sales',
                    'orderby' => 'meta_value_num',
                    'order' => 'DESC'  );
					break;
				case 'discounted':
					$args = array(
						'posts_per_page'    => $settings['ptotalcount'],
						'post_status'       => 'publish',
						'order' => 'DESC',
						'post_type'         => 'product',
						'post__in'          => array_merge( array( 0 ), wc_get_product_ids_on_sale() )
					);
					break;
				case 'viewed':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'meta_key' => 'post_views_count',
                    'orderby' => 'meta_value_num',
                    'order' => 'DESC'  );
					break;
				case 'random':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'orderby'        => 'rand'  );
					break;
				default:
				$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'order' => 'DESC'  );
				}
				if ( $product_cat || $product_tag ) {
					if ( $prod_filter == 'category') {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'product_cat',
							'field' => 'term_id',
							'terms' => $product_cat
							)
						);
						$view_all_link = get_term_link((int)$product_cat,'product_cat');
					} else {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'product_tag',
							'field' => 'term_id',
							'terms' => $product_tag
							)
						);
						$view_all_link = get_term_link((int)$product_tag,'product_cat');
					}
				}
			}
			elseif ($prod_sort == 'special') {
				$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'order' => 'DESC'  );
				if ( $product_cat || $product_tag ) {
					if ( $prod_filter == 'category') {
						$args['tax_query'] = array(
						'relation' => 'OR',
						array(
							'taxonomy' => 'product_visibility',
							'field'    => 'term_id',
							'terms'    => 'featured',
							'operator' => 'IN',
						),
						array(
						'taxonomy' => 'product_cat',
						'field' => 'term_id',
						'terms' => $product_cat
						)
					);
					} else {
						$args['tax_query'] = array(
						'relation' => 'OR',
						array(
							'taxonomy' => 'product_visibility',
							'field'    => 'term_id',
							'terms'    => 'featured',
							'operator' => 'IN',
						),
						array(
						'taxonomy' => 'product_tag',
							'field' => 'term_id',
							'terms' => $product_tag
						)
					);
					}
				}
			}


			if('yes' === $settings['out_prod']){
				$args['meta_query'] = array(
						'relation' => 'AND',
						array(
							'key' => '_stock_status',
							'value' => 'instock'
						)
					);
			}


			$productsquery = new \WP_Query( $args );
		?>
		
		<?php if ( $productsquery->have_posts() ) { ?>
		<div class="block-title">
			<h2>
				<i class="fal fa-<?php echo $settings['product_icon']; ?>" aria-hidden="true"></i>
				<?php echo $settings['title']; ?>
			</h2>
			<?php if ( 'yes' === $settings['view_all'] && $view_all_link != '' ) { ?>
			<a href="<?php echo $view_all_link; ?>" class="pview-all">
				<?php _e( 'View All' , 'dina-kala' ); ?>
				<i class="fal fa-chevron-left" aria-hidden="true"></i>
			</a>
			<?php } ?>
		</div>
		<div class="owl-carousel" <?php if ( 'yes' === $settings['show_arrows'] ) { echo 'data-itemnavs="true"'; } else { echo 'data-itemnavs="false"'; } ?> <?php if ( 'yes' === $settings['prod_loop'] ) { echo 'data-itemloop="true"'; } else { echo 'data-itemloop="false"'; } ?> <?php if ( 'yes' === $settings['auto_play'] ) { echo 'data-itemplay="true"'; } else { echo 'data-itemplay="false"'; } ?> data-itemscount="<?php echo $settings['pcount']; ?>">
		<?php while ( $productsquery->have_posts() ) : $productsquery->the_post(); ?>
			<?php global $product;
				$in_stock = $product->is_in_stock();
				$stock_class = ($in_stock ? '' : ' prod-out-stock'); ?>
			<div class="item">
				<div class="shadow-box mini-product<?php echo $stock_class; ?>">
					<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="product-link">
						<?php p_img() ?>
						<?php if($in_stock && $product->is_on_sale()) { ?>
						<?php echo dina_dis_price(get_the_ID()); ?>
						<?php } ?>
						<span class="product-title">
							<?php the_title(); ?>
						</span>
						<span class="product-price">
						<?php if($in_stock) { ?>
							<span class="price-con">
							<?php echo $product->get_price_html(); ?>
							</span>
						<?php } else { ?>
							<span class="price-con">
							<?php _e( 'Out of stock', 'dina-kala' ); ?>
							</span>
						<?php } ?>
						</span>
					</a>
					<a href="<?php the_permalink(); ?>" class="btn btn-success btn-buy">
						<i class="fal fa-cart-plus" aria-hidden="true"></i>
						<?php if($in_stock) { ?>
							<?php _e( 'View And Buy', 'dina-kala' ); ?>
						<?php } else { ?>
							<?php _e( 'View Product', 'dina-kala' ); ?>
						<?php } ?>
					</a>
				</div>
			</div>
        <?php endwhile; ?>
        </div>

		<?php 
		} else {		
		echo '<div class="col-12 not-msg">'.__( 'No product with the desired conditions was found.', 'dina-kala' ).'</div>';}
		
		wp_reset_postdata();
		?>
        </div>
        <?php

	}

}