<?php
namespace Elementor;

class Dina_Blog_Posts extends Widget_Base {
	
	public function get_name() {
		return 'dina-blog-posts';
	}
	
	public function get_title() {
		return __( 'Dina blog posts', 'dina-kala' );
	}
	
	public function get_icon() {
		return 'fal fa-file-alt';
	}
	
	public function get_categories() {
		return [ 'dina-kala' ];
	}
	
	protected function _register_controls() {
		require get_template_directory() . '/includes/widgets/fa.php';
		$post_cat = array();
		$categories = get_terms("category");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
		foreach ( $categories as $category ) {
		$post_cat[ $category->term_id ] = $category->name;
		}
		}

		$post_taga = array();
		$tags = get_terms("post_tag");
		if ( !empty( $tags ) && !is_wp_error( $tags ) ){
		foreach ( $tags as $tag ) {
		$post_taga[ $tag->term_id ] = $tag->name;
		}
		}

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Dina blog posts', 'dina-kala' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'Title', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your title', 'dina-kala' ),
			]
		);

		$this->add_control(
			'post_sort',
			[
				'label' => __( 'Posts sorting', 'dina-kala' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'  => __( 'Latest posts', 'dina-kala' ),
					'random' => __( 'Random posts', 'dina-kala' ),
					'viewed' => __( 'Most viewed posts', 'dina-kala' ),
				],
			]
		);

		$this->add_control(
			'post_filter',
			[
				'label' => __( 'Post filtering', 'dina-kala' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'category',
				'options' => [
					'category'  => __( 'Post category', 'dina-kala' ),
					'tag' => __( 'Post tag', 'dina-kala' ),
				],
			]
		);

		$this->add_control(
			'post_cat',
			[
				'label' => __( 'Posts category', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $post_cat,
			]
		);

		$this->add_control(
			'post_tag',
			[
				'label' => __( 'Post tag', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $post_taga,
			]
		);

		$this->add_control(
			'post_icon',
			[
				'label' => __( 'Icon', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
			]
		);

		$this->add_control(
			'white_title',
			[
				'label' => __( 'White title (Suitable for background mode)', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'white_box',
			[
				'label' => __( 'White box style', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'show_arrows',
			[
				'label' => __( 'Show Arrows', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'auto_play',
			[
				'label' => __( 'Auto play', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'post_loop',
			[
				'label' => __( 'Posts loop', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'ptotalcount',
			[
				'label' => __( 'Posts total count', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 8,
				'max' => 20,
				'step' => 1,
				'default' => 8,
			]
		);

		$this->add_control(
			'pcount',
			[
				'label' => __( 'Posts columns count', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 4,
				'max' => 6,
				'step' => 1,
				'default' => 5,
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {
        $settings = $this->get_settings_for_display(); ?>
        <div class="post-block<?php if ( 'yes' === $settings['white_title'] ) { echo ' white-title'; } ?><?php if ( 'yes' === $settings['white_box'] ) { echo ' white-box'; } ?>">
			<div class="block-title">
				<h2>
					<i class="fal fa-<?php echo $settings['post_icon']; ?>" aria-hidden="true"></i>
					<?php echo $settings['title']; ?>
				</h2>
			</div>
		<?php
		$post_sort = $settings['post_sort'];
		$post_filter = $settings['post_filter'];
		$post_cat = $settings['post_cat'];
		$post_tag = $settings['post_tag'];

			switch ($post_sort) {
				case 'latest':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'post',
					'post_status' => 'publish',
					'order' => 'DESC'  );
					break;
				case 'viewed':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'post',
					'post_status' => 'publish',
					'meta_key' => 'post_views_count',
                    'orderby' => 'meta_value_num',
                    'order' => 'DESC'  );
					break;
				case 'random':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'post',
					'post_status' => 'publish',
					'orderby'        => 'rand'  );
					break;
				default:
				$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'post',
					'post_status' => 'publish',
					'order' => 'DESC'  );
				}
				if ( $post_cat || $post_tag ) {
					if ( $post_filter == 'category') {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'category',
							'field' => 'term_id',
							'terms' => $post_cat
							)
						);
					} else {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'post_tag',
							'field' => 'term_id',
							'terms' => $post_tag
							)
						);
					}
				}
			$postsquery = new \WP_Query( $args );
		?>
		
		<?php if ( $postsquery->have_posts() ) { ?>
		
		<div class="owl-carousel" <?php if ( 'yes' === $settings['show_arrows'] ) { echo 'data-itemnavs="true"'; } else { echo 'data-itemnavs="false"'; } ?> <?php if ( 'yes' === $settings['post_loop'] ) { echo 'data-itemloop="true"'; } else { echo 'data-itemloop="false"'; } ?> <?php if ( 'yes' === $settings['auto_play'] ) { echo 'data-itemplay="true"'; } else { echo 'data-itemplay="false"'; } ?> data-itemscount="<?php echo $settings['pcount']; ?>">
		<?php while ( $postsquery->have_posts() ) : $postsquery->the_post(); 
		$post_categories = get_post_primary_category(get_the_ID(), 'category'); 
		$primary_category = $post_categories['primary_category']; ?>
			<div class="item">
				<div class="shadow-box mini-post">
					<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="post-link">
						<?php p_img() ?>
						<span class="post-title">
							<?php the_title(); ?>
						</span>
						<span class="post-cat"><?php echo $primary_category->name; ?></span>
					</a>
					<a href="<?php the_permalink(); ?>" class="btn btn-success btn-buy">
						<i class="fal fa-file-alt" aria-hidden="true"></i>
						<?php echo __( 'Read More...', 'dina-kala' ); ?>
					</a>
				</div>
			</div>
        <?php endwhile; ?>
        </div>

		<?php 
		} else {		
		echo '<div class="col-12 not-msg">'.__( 'No post with the desired conditions was found.', 'dina-kala' ).'</div>';}
		
		wp_reset_postdata();
		?>
        </div>
        <?php

	}

}