<?php
namespace Elementor;

class Dina_Woo_Offer extends Widget_Base {

	public function get_name() {
		return 'dina-woo-offer';
	}
	
	public function get_title() {
		return __( 'Dina Woo Offer', 'dina-kala' );
	}
	
	public function get_icon() {
		return 'fal fa-badge-percent';
	}
	
	public function get_categories() {
		return [ 'dina-kala' ];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Dina Woo Offer', 'dina-kala' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'Title', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Instant Offer', 'dina-kala' ),
				'default' => __( 'Instant Offer', 'dina-kala' ),
			]
		);

		$this->add_control(
			'ptotalcount',
			[
				'label' => __( 'Product total count', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 20,
				'step' => 1,
				'default' => 5,
			]
		);

		$this->add_control(
			'time',
			[
				'label' => __( 'Auto play speed(ms)', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1000,
				'max' => 20000,
				'step' => 1000,
				'default' => 5000,
			]
		);

		$this->add_control(
			'offer_style',
			[
				'label' => __( 'More height (Suitable for use beside boxing products)', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {
        $settings = $this->get_settings_for_display(); ?>
        <div class="offer-block shadow-box<?php if ( 'yes' === $settings['offer_style'] ) { echo ' more-height'; } ?>">
			<div class="block-title">
				<h2>
					<?php echo $settings['title']; ?>
				</h2>
				<div class="slide-progress"></div>
			</div>
		<?php
			$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'post__in'          => array_merge( array( 0 ), wc_get_product_ids_on_sale() ),
					'meta_query' => array(
						array(
						'key' => '_stock_status',
						'value' => 'instock',
						'compare' => '=',
						)
                    ),
                    'orderby' => 'rand'  );
			$offerquery = new \WP_Query( $args );
		?>
		
		<?php if ( $offerquery->have_posts() ) { ?>
		<div class="owl-carousel" data-itemtime="<?php echo $settings['time']; ?>">
        <?php while ( $offerquery->have_posts() ) : $offerquery->the_post(); ?>
			<div class="item">
				<div class="mini-product">
					<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="product-link">
						<?php p_img() ?>
						<?php echo dina_dis_price(get_the_ID()); ?>
						<span class="product-title">
							<?php the_title(); ?>
						</span>
						<span class="product-price">
							<?php 
							global $product;
							if($product->is_type( 'variable' )){
								$r_price = $product->get_variation_regular_price( 'min' ). get_woocommerce_currency_symbol();
								$s_price = $product->get_variation_sale_price( 'min' ). get_woocommerce_currency_symbol();
							} else {
								$r_price = $product->get_regular_price(). get_woocommerce_currency_symbol();
								$s_price = $product->get_sale_price(). get_woocommerce_currency_symbol();
							}
							?>
							<span class="price-con">
							<del>
								<?php echo wc_price($r_price); ?>
							</del>
							<ins>
								<?php echo wc_price($s_price); ?>
							</ins>
							</span>
						</span>
					</a>
				</div>
			</div>
        <?php endwhile; ?>
        </div>

		<?php 
		} else {		
		echo '<div class="col-12 not-msg">'.__( 'No product with the desired conditions was found.', 'dina-kala' ).'</div>';}
		wp_reset_postdata();
		?>
        </div>
        <?php
	}
}