<?php
namespace Elementor;

class Logo_Slider extends Widget_Base {
	
	public function get_name() {
		return 'logo-slider';
	}
	
	public function get_title() {
		return __( 'Logo slider', 'dina-kala' );
	}
	
	public function get_icon() {
		return 'fal fa-forward';
	}
	
	public function get_categories() {
		return [ 'dina-kala' ];
	}
	
	protected function _register_controls() {
	require get_template_directory() . '/includes/widgets/fa.php';
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Logo slider', 'dina-kala' ),
			]
		);

		$logos = new Repeater();

		$logos->add_control(
			'logo_title', [
				'label' => __( 'Logo title', 'dina-kala' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$logos->add_control(
			'logo_link',
			[
				'label' => __( 'Logo link', 'dina-kala' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'dina-kala' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
        
        $logos->add_control(
			'logo_image',
			[
				'label' => __( 'Choose logo', 'dina-kala' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'logos',
			[
				'label' => __( 'Logos', 'dina-kala' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $logos->get_controls(),
				'default' => [
					[
						'logo_title' => __( 'Logo title', 'dina-kala' ),
						'logo_link' => __( 'https://your-link.com', 'dina-kala' ),
					],
				],
				'title_field' => '{{{ logo_title }}}',
			]
		);
		
		$this->add_control(
			'slider_title',
			[
				'label' => __( 'Slider title', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your title', 'dina-kala' ),
                'default' => __( 'Logo slider', 'dina-kala' ),
			]
		);

		$this->add_control(
			'slider_icon',
			[
				'label' => __( 'Slider icon', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'gem '
			]
		);
		
		$this->add_control(
			'white_box',
			[
				'label' => __( 'White box style', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'show_arrows',
			[
				'label' => __( 'Show arrows', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'auto_play',
			[
				'label' => __( 'Auto play', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'time',
			[
				'label' => __( 'Auto play speed(ms)', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1000,
				'max' => 20000,
				'step' => 1000,
				'default' => 8000,
			]
		);

		$this->add_control(
			'logo_loop',
			[
				'label' => __( 'Logo loop', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'lcount',
			[
				'label' => __( 'Logo columns count', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 4,
				'max' => 6,
				'step' => 1,
				'default' => 5,
			]
		);

		$this->add_control(
			'show_dots',
			[
				'label' => __( 'Show navigation\'s dots', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		
        
		$this->end_controls_section();
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();
        
		?>
        <div class="logos<?php if ( 'yes' === $settings['white_box'] ) { echo ' white-box'; } ?>">
            <h2>
            <i class="fal fa-<?php echo $settings['slider_icon']; ?>" aria-hidden="true"></i>
            <?php echo $settings['slider_title']; ?>
            </h2>
            <div class="owl-carousel logo-slider" <?php if ( 'yes' === $settings['show_arrows'] ) { echo 'data-itemnavs="true"'; } else { echo 'data-itemnavs="false"'; } ?> <?php if ( 'yes' === $settings['logo_loop'] ) { echo 'data-itemloop="true"'; } else { echo 'data-itemloop="false"'; } ?> <?php if ( 'yes' === $settings['auto_play'] ) { echo 'data-itemplay="true"'; } else { echo 'data-itemplay="false"'; } ?> <?php if ( 'yes' === $settings['show_dots'] ) { echo 'data-itemdots="true"'; } else { echo 'data-itemdots="false"'; } ?> data-itemscount="<?php echo $settings['lcount']; ?>" data-itemtime="<?php echo $settings['time']; ?>">
                <?php foreach ( $settings['logos'] as $item ) { ?>
                <div class="item">
					<a href="<?php echo $item['logo_link']['url']; ?>" title="<?php echo $item['logo_title']; ?>">
						<img src="<?php echo $item['logo_image']['url']; ?>" alt="<?php echo $item['logo_title']; ?>">
					</a>
                </div>
                <?php } ?>
            </div>
        </div>
         <?php

	}


}