<?php
namespace Elementor;

class Ads_Image extends Widget_Base {
	
	public function get_name() {
		return 'ads-image';
	}
	
	public function get_title() {
		return __( 'Ads image', 'dina-kala' );
	}
	
	public function get_icon() {
		return 'fal fa-image';
	}
	
	public function get_categories() {
		return [ 'dina-kala' ];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Ads image', 'dina-kala' ),
			]
		);
		
		$this->add_control(
			'img_title',
			[
				'label' => __( 'Image title', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter image title', 'dina-kala' ),
                'default' => __( '#', 'dina-kala' ),
			]
        );
        
        $this->add_control(
			'img_link',
			[
				'label' => __( 'Image link', 'dina-kala' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'dina-kala' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
        
        $this->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'dina-kala' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {
        $settings = $this->get_settings_for_display();
        $target = $settings['img_link']['is_external'] ? ' target="_blank"' : '';
		$nofollow = $settings['img_link']['nofollow'] ? ' rel="nofollow"' : '';
		?>
        <div class="ads-image">
            <a href="<?php echo $settings['img_link']['url']; ?>" title="<?php echo $settings['img_title']; ?>"<?php if(!empty($target)) { echo $target;} ?> <?php if(!empty($nofollow)) { echo $nofollow;} ?>>
                <img src="<?php echo $settings['image']['url']; ?>" alt="<?php echo $settings['img_title']; ?>" class="shadow-box">
            </a>
        </div>
         <?php
	}
}