<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: Hosseinkhani.ir
*/
   // Exit if accessed directly
   if (!defined('ABSPATH')) {
    exit;
}

class Site_Logo_widget extends WP_Widget {
      public function __construct() {
         $widget_ops = array('classname' => 'site-logo_widget', 'description' => __('Site logo display widget', 'dina-kala') );
         parent::__construct('site-logo', __('Site logo display (azmoon)', 'dina-kala'), $widget_ops);
         $this->alt_option_name = 'site-logo_widget';
      }
      function widget($args, $instance) {
        extract( $args );
            $title = apply_filters( 'widget_title', empty($instance['title']) ? __('Site logos', 'dina-kala') : $instance['title'], $instance, $this->id_base); 
            $site_logo = $instance['site_logo'];
            echo $before_widget;
   			// Widget title
   			echo $before_title;
   			echo $instance["title"];
   			echo $after_title;
   		?>
    <?php if($site_logo!='') {echo '<div class="col-12 site-logo-con">'.$site_logo.'</div>'; }?>

<?php   echo $after_widget;
   }
   public function update( $new_instance, $old_instance ) {
   $instance = $old_instance;
   $instance['title'] = sanitize_text_field( $new_instance['title'] );
   $instance['site_logo'] = $new_instance['site_logo'];
   return $instance;
   }
   public function form( $instance ) {
   $title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
   $site_logo     = isset( $instance['site_logo'] ) ? $instance['site_logo'] : '';
   ?>
<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title', 'dina-kala'); ?></label>
   <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" />
</p>
<p><label for="<?php echo $this->get_field_id( 'site_logo' ); ?>"><?php _e('Site logo', 'dina-kala'); ?></label>
    <textarea class="widefat code" rows="5" cols="20" id="<?php echo $this->get_field_id( 'site_logo' ); ?>" name="<?php echo $this->get_field_name( 'site_logo' ); ?>"><?php echo $site_logo; ?></textarea>
</p>
<?php
   }
   }
   // register LOGO SLIDER Widget
   add_action('widgets_init', function() {return register_widget("Site_Logo_widget");});