<?php
/**
 * Include and setup custom metaboxes and fields. (make sure you copy this file to outside the CMB2 directory)
 *
 * Be sure to replace all instances of 'dina_' with your project's prefix.
 * http://nacin.com/2010/05/11/in-wordpress-prefix-everything/
 *
 * @category YourThemeOrPlugin
 * @package  Demo_CMB2
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/CMB2/CMB2
 */

/**
 * Get the bootstrap! If using the plugin from wordpress.org, REMOVE THIS!
 */

if ( file_exists( dirname( __FILE__ ) . '/cmb2/init.php' ) ) {
	require_once dirname( __FILE__ ) . '/cmb2/init.php';
} elseif ( file_exists( dirname( __FILE__ ) . '/CMB2/init.php' ) ) {
	require_once dirname( __FILE__ ) . '/CMB2/init.php';
}

/**
 * Conditionally displays a metabox when used as a callback in the 'show_on_cb' cmb2_box parameter
 *
 * @param  CMB2 $product CMB2 object.
 *
 * @return bool      True if metabox should show
 */
function dina_show_if_front_page( $product ) {
	// Don't show this metabox if it's not the front page template.
	if ( get_option( 'page_on_front' ) !== $product->object_id ) {
		return false;
	}
	return true;
}

/**
 * Conditionally displays a field when used as a callback in the 'show_on_cb' field parameter
 *
 * @param  CMB2_Field $field Field object.
 *
 * @return bool              True if metabox should show
 */
function dina_hide_if_no_cats( $field ) {
	// Don't show this field if not in the cats category.
	if ( ! has_tag( 'cats', $field->object_id ) ) {
		return false;
	}
	return true;
}

/**
 * Manually render a field.
 *
 * @param  array      $field_args Array of field arguments.
 * @param  CMB2_Field $field      The field object.
 */
function dina_render_row_cb( $field_args, $field ) {
	$classes     = $field->row_classes();
	$id          = $field->args( 'id' );
	$label       = $field->args( 'name' );
	$name        = $field->args( '_name' );
	$value       = $field->escaped_value();
	$description = $field->args( 'description' );
	?>
	<div class="custom-field-row <?php echo esc_attr( $classes ); ?>">
		<p><label for="<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $label ); ?></label></p>
		<p><input id="<?php echo esc_attr( $id ); ?>" type="text" name="<?php echo esc_attr( $name ); ?>" value="<?php echo $value; ?>"/></p>
		<p class="description"><?php echo esc_html( $description ); ?></p>
	</div>
	<?php
}

/**
 * Manually render a field column display.
 *
 * @param  array      $field_args Array of field arguments.
 * @param  CMB2_Field $field      The field object.
 */
function dina_display_text_small_column( $field_args, $field ) {
	?>
	<div class="custom-column-display <?php echo esc_attr( $field->row_classes() ); ?>">
		<p><?php echo $field->escaped_value(); ?></p>
		<p class="description"><?php echo esc_html( $field->args( 'description' ) ); ?></p>
	</div>
	<?php
}

/**
 * Conditionally displays a message if the $post_id is 2
 *
 * @param  array      $field_args Array of field parameters.
 * @param  CMB2_Field $field      Field object.
 */
function dina_before_row_if_2( $field_args, $field ) {
	if ( 2 == $field->object_id ) {
		echo '<p>Testing <b>"before_row"</b> parameter (on $post_id 2)</p>';
	} else {
		echo '<p>Testing <b>"before_row"</b> parameter (<b>NOT</b> on $post_id 2)</p>';
	}
}

add_action( 'cmb2_admin_init', 'dina_register_metabox' );
/**
 * Hook in and add a demo metabox. Can only happen on the 'cmb2_admin_init' or 'cmb2_init' hook.
 */
function dina_register_metabox() {
	$prefix = 'dina_';

	/**
	 * Sample metabox to demonstrate each field type included
	 */
	$product = new_cmb2_box( array(
		'id'            => $prefix . 'metabox',
		'title'         => esc_html__( 'Product Settings', 'dina-kala' ),
		'object_types'  => array( 'product' ), // Post type
		// 'show_on_cb' => 'dina_show_if_front_page', // function should return a bool value
		// 'context'    => 'normal',
		'priority'   => 'high',
		// 'show_names' => true, // Show field names on the left
		// 'cmb_styles' => false, // false to disable the CMB stylesheet
		// 'closed'     => true, // true to keep the metabox closed by default
		// 'classes'    => 'extra-class', // Extra cmb2-wrap classes
		// 'classes_cb' => 'dina_add_some_classes', // Add classes through a callback.
		// 'mb_callback_args' => array( '__block_editor_compatible_meta_box' => false ),
	) );

	$product->add_field( array(
		'name'       => esc_html__( 'Text under product title (under title)', 'dina-kala' ),
		'id'         => $prefix . 'under_title',
		'type'       => 'text',
	) );

	$product->add_field( array(
	'name' => esc_html__( 'Comingsoon Mode', 'dina-kala' ),
	'desc' => esc_html__( 'View Comingsoon instead of price', 'dina-kala' ),
	'id'   => $prefix . 'coming',
	'type' => 'checkbox',
	) );

	$product->add_field( array(
	'name' => esc_html__( 'Special Product', 'dina-kala' ),
	'desc' => esc_html__( 'View Product in Special Products section', 'dina-kala' ),
	'id'   => $prefix . 'special',
	'type' => 'checkbox',
	) );

	$product->add_field( array(
		'name' => esc_html__( 'Review Video', 'dina-kala' ),
		'desc' => esc_html__( 'Upload Video Review of the Product', 'dina-kala' ),
		'id'   => $prefix . 'rvideo',
		'text'    => array(
		'add_upload_file_text' => esc_html__( 'Add Video', 'dina-kala' )
		),
		'type' => 'file',
	) );

	$product->add_field( array(
		'name' => esc_html__( 'Aparat Video', 'dina-kala' ),
		'desc' => esc_html__( 'Enter only id of the video (example: 4pN2B)', 'dina-kala' ),
		'id'   => $prefix . 'aparat',
		'type' => 'text_small',
	) );

	$product->add_field( array(
		'name'             => esc_html__( 'Product Sidebar Setting', 'dina-kala' ),
		'id'               => $prefix . 'pside',
		'type'             => 'radio_inline',
		'show_option_none' => esc_html__( 'Defualt Settings', 'dina-kala' ),
		'options'          => array(
			'wside' => esc_html__( 'Without Sidebar', 'dina-kala' ),
			'rside'   => esc_html__( 'Right Sidebar', 'dina-kala' ),
			'lside'     => esc_html__( 'Left Sidebar', 'dina-kala' ),
		),
	) );

	$group_field_id = $product->add_field( array(
		'id'          => $prefix . 'product_features',
		'type'        => 'group',
		'description' => esc_html__( 'Product features shown above product price', 'dina-kala' ),
		'options'     => array(
			'group_title'    => esc_html__( 'Feature {#}', 'dina-kala' ),
			'add_button'     => esc_html__( 'Add Another Feature', 'dina-kala' ),
			'remove_button'  => esc_html__( 'Remove Feature', 'dina-kala' ),
			'sortable'       => true,
			'closed'      => true, // true to have the groups closed by default
			'remove_confirm' => esc_html__( 'Are you sure you want to remove this feature?', 'dina-kala' ),
		),
	) );

	$product->add_group_field( $group_field_id, array(
		'name'       => esc_html__( 'Feature Title', 'dina-kala' ),
		'id'         => 'ftitle',
		'type'       => 'text',
	) );

	$product->add_group_field( $group_field_id, array(
		'name'       => esc_html__( 'Feature Description', 'dina-kala' ),
		'id'         => 'fdesc',
		'type'       => 'text',
	) );


	$page = new_cmb2_box( array(
		'id'            => $prefix . 'pagesetting',
		'title'         => esc_html__( 'Page Settings', 'dina-kala' ),
		'object_types'  => array( 'page' ),
		'priority'   => 'high',
    ) );
    
    $page->add_field( array(
		'name'             => esc_html__( 'Page Sidebar Setting', 'dina-kala' ),
		'id'               => $prefix . 'pageside',
		'type'             => 'radio_inline',
		'options'          => array(
			'wside' => esc_html__( 'Without Sidebar', 'dina-kala' ),
			'rside'   => esc_html__( 'Right Sidebar', 'dina-kala' ),
			'lside'     => esc_html__( 'Left Sidebar', 'dina-kala' ),
		),
	) );

	$post = new_cmb2_box( array(
		'id'            => $prefix . 'postsetting',
		'title'         => esc_html__( 'Post Settings', 'dina-kala' ),
		'object_types'  => array( 'post' ),
		'priority'   => 'high',
    ) );
    
    $post->add_field( array(
		'name'             => esc_html__( 'Post Sidebar Setting', 'dina-kala' ),
		'id'               => $prefix . 'postside',
		'type'             => 'radio_inline',
		'options'          => array(
			'wside' => esc_html__( 'Without Sidebar', 'dina-kala' ),
			'rside'   => esc_html__( 'Right Sidebar', 'dina-kala' ),
			'lside'     => esc_html__( 'Left Sidebar', 'dina-kala' ),
		),
	) );
}


/*add_action( 'cmb2_admin_init', 'dina_register_user_profile_metabox' );
function dina_register_user_profile_metabox() {
	$prefix = 'dina_user_';

	$product_user = new_cmb2_box( array(
		'id'               => $prefix . 'edit',
		'title'            => esc_html__( 'User Profile Metabox', 'dina-kala' ), // Doesn't output for user boxes
		'object_types'     => array( 'user' ), // Tells CMB2 to use user_meta vs post_meta
		'show_names'       => true,
		'new_user_section' => 'add-new-user', // where form will show on new user page. 'add-existing-user' is only other valid option.
	) );

	$product_user->add_field( array(
		'name'     => esc_html__( 'Extra Info', 'dina-kala' ),
		'desc'     => esc_html__( 'field description (optional)', 'dina-kala' ),
		'id'       => $prefix . 'extra_info',
		'type'     => 'title',
		'on_front' => false,
	) );

	$product_user->add_field( array(
		'name'    => esc_html__( 'Avatar', 'dina-kala' ),
		'desc'    => esc_html__( 'field description (optional)', 'dina-kala' ),
		'id'      => $prefix . 'avatar',
		'type'    => 'file',
	) );

	$product_user->add_field( array(
		'name' => esc_html__( 'Facebook URL', 'dina-kala' ),
		'desc' => esc_html__( 'field description (optional)', 'dina-kala' ),
		'id'   => $prefix . 'facebookurl',
		'type' => 'text_url',
	) );

	$product_user->add_field( array(
		'name' => esc_html__( 'Twitter URL', 'dina-kala' ),
		'desc' => esc_html__( 'field description (optional)', 'dina-kala' ),
		'id'   => $prefix . 'twitterurl',
		'type' => 'text_url',
	) );

	$product_user->add_field( array(
		'name' => esc_html__( 'Google+ URL', 'dina-kala' ),
		'desc' => esc_html__( 'field description (optional)', 'dina-kala' ),
		'id'   => $prefix . 'googleplusurl',
		'type' => 'text_url',
	) );

	$product_user->add_field( array(
		'name' => esc_html__( 'Linkedin URL', 'dina-kala' ),
		'desc' => esc_html__( 'field description (optional)', 'dina-kala' ),
		'id'   => $prefix . 'linkedinurl',
		'type' => 'text_url',
	) );

	$product_user->add_field( array(
		'name' => esc_html__( 'User Field', 'dina-kala' ),
		'desc' => esc_html__( 'field description (optional)', 'dina-kala' ),
		'id'   => $prefix . 'user_text_field',
		'type' => 'text',
	) );

} */
