<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: Hosseinkhani.ir
*/
   // Exit if accessed directly
   if (!defined('ABSPATH')) {
    exit;
}

/**
    *  /!\ This is a copy of Walker_Nav_Menu_Edit class in core
    * 
    * Create HTML list of nav menu input items.
    *
    * @package WordPress
    * @since 3.0.0
    * @uses Walker_Nav_Menu
    */
   class Walker_Nav_Menu_Edit_Custom extends Walker_Nav_Menu  {
   	private $icons_font_awesome = array(
		   "abacus"=>"","acorn"=>"","ad"=>"","address-book"=>"","address-card"=>"","adjust"=>"","air-conditioner"=>"","air-freshener"=>"","alarm-clock"=>"","alarm-exclamation"=>"","alarm-plus"=>"","alarm-snooze"=>"","album"=>"","album-collection"=>"","alicorn"=>"","alien"=>"","alien-monster"=>"","align-center"=>"","align-justify"=>"","align-left"=>"","align-right"=>"","align-slash"=>"","allergies"=>"","ambulance"=>"","american-sign-language-interpreting"=>"","amp-guitar"=>"","analytics"=>"","anchor"=>"","angel"=>"","angle-double-down"=>"","angle-double-left"=>"","angle-double-right"=>"","angle-double-up"=>"","angle-down"=>"","angle-left"=>"","angle-right"=>"","angle-up"=>"","angry"=>"","ankh"=>"","apple-alt"=>"","apple-crate"=>"","archive"=>"","archway"=>"","arrow-alt-circle-down"=>"","arrow-alt-circle-left"=>"","arrow-alt-circle-right"=>"","arrow-alt-circle-up"=>"","arrow-alt-down"=>"","arrow-alt-from-bottom"=>"","arrow-alt-from-left"=>"","arrow-alt-from-right"=>"","arrow-alt-from-top"=>"","arrow-alt-left"=>"","arrow-alt-right"=>"","arrow-alt-square-down"=>"","arrow-alt-square-left"=>"","arrow-alt-square-right"=>"","arrow-alt-square-up"=>"","arrow-alt-to-bottom"=>"","arrow-alt-to-left"=>"","arrow-alt-to-right"=>"","arrow-alt-to-top"=>"","arrow-alt-up"=>"","arrow-circle-down"=>"","arrow-circle-left"=>"","arrow-circle-right"=>"","arrow-circle-up"=>"","arrow-down"=>"","arrow-from-bottom"=>"","arrow-from-left"=>"","arrow-from-right"=>"","arrow-from-top"=>"","arrow-left"=>"","arrow-right"=>"","arrow-square-down"=>"","arrow-square-left"=>"","arrow-square-right"=>"","arrow-square-up"=>"","arrow-to-bottom"=>"","arrow-to-left"=>"","arrow-to-right"=>"","arrow-to-top"=>"","arrow-up"=>"","arrows"=>"","arrows-alt"=>"","arrows-alt-h"=>"","arrows-alt-v"=>"","arrows-h"=>"","arrows-v"=>"","assistive-listening-systems"=>"","asterisk"=>"","at"=>"","atlas"=>"","atom"=>"","atom-alt"=>"","audio-description"=>"","award"=>"","axe"=>"","axe-battle"=>"","baby"=>"","baby-carriage"=>"","backpack"=>"","backspace"=>"","backward"=>"","bacon"=>"","badge"=>"","badge-check"=>"","badge-dollar"=>"","badge-percent"=>"","badge-sheriff"=>"","badger-honey"=>"","bags-shopping"=>"","bahai"=>"","balance-scale"=>"","balance-scale-left"=>"","balance-scale-right"=>"","ball-pile"=>"","ballot"=>"","ballot-check"=>"","ban"=>"","band-aid"=>"","banjo"=>"","barcode"=>"","barcode-alt"=>"","barcode-read"=>"","barcode-scan"=>"","bars"=>"","baseball"=>"","baseball-ball"=>"","basketball-ball"=>"","basketball-hoop"=>"","bat"=>"","bath"=>"","battery-bolt"=>"","battery-empty"=>"","battery-full"=>"","battery-half"=>"","battery-quarter"=>"","battery-slash"=>"","battery-three-quarters"=>"","bed"=>"","bed-alt"=>"","bed-bunk"=>"","bed-empty"=>"","beer"=>"","bell"=>"","bell-exclamation"=>"","bell-on"=>"","bell-plus"=>"","bell-school"=>"","bell-school-slash"=>"","bell-slash"=>"","bells"=>"","betamax"=>"","bezier-curve"=>"","bible"=>"","bicycle"=>"","biking"=>"","biking-mountain"=>"","binoculars"=>"","biohazard"=>"","birthday-cake"=>"","blanket"=>"","blender"=>"","blender-phone"=>"","blind"=>"","blinds"=>"","blinds-open"=>"","blinds-raised"=>"","blog"=>"","bold"=>"","bolt"=>"","bomb"=>"","bone"=>"","bone-break"=>"","bong"=>"","book"=>"","book-alt"=>"","book-dead"=>"","book-heart"=>"","book-medical"=>"","book-open"=>"","book-reader"=>"","book-spells"=>"","book-user"=>"","bookmark"=>"","books"=>"","books-medical"=>"","boombox"=>"","boot"=>"","booth-curtain"=>"","border-all"=>"","border-bottom"=>"","border-center-h"=>"","border-center-v"=>"","border-inner"=>"","border-left"=>"","border-none"=>"","border-outer"=>"","border-right"=>"","border-style"=>"","border-style-alt"=>"","border-top"=>"","bow-arrow"=>"","bowling-ball"=>"","bowling-pins"=>"","box"=>"","box-alt"=>"","box-ballot"=>"","box-check"=>"","box-fragile"=>"","box-full"=>"","box-heart"=>"","box-open"=>"","box-up"=>"","box-usd"=>"","boxes"=>"","boxes-alt"=>"","boxing-glove"=>"","brackets"=>"","brackets-curly"=>"","braille"=>"","brain"=>"","bread-loaf"=>"","bread-slice"=>"","briefcase"=>"","briefcase-medical"=>"","bring-forward"=>"","bring-front"=>"","broadcast-tower"=>"","broom"=>"","browser"=>"","brush"=>"","bug"=>"","building"=>"","bullhorn"=>"","bullseye"=>"","bullseye-arrow"=>"","bullseye-pointer"=>"","burger-soda"=>"","burn"=>"","burrito"=>"","bus"=>"","bus-alt"=>"","bus-school"=>"","business-time"=>"","cabinet-filing"=>"","cactus"=>"","calculator"=>"","calculator-alt"=>"","calendar"=>"","calendar-alt"=>"","calendar-check"=>"","calendar-day"=>"","calendar-edit"=>"","calendar-exclamation"=>"","calendar-minus"=>"","calendar-plus"=>"","calendar-star"=>"","calendar-times"=>"","calendar-week"=>"","camcorder"=>"","camera"=>"","camera-alt"=>"","camera-home"=>"","camera-movie"=>"","camera-polaroid"=>"","camera-retro"=>"","campfire"=>"","campground"=>"","candle-holder"=>"","candy-cane"=>"","candy-corn"=>"","cannabis"=>"","capsules"=>"","car"=>"","car-alt"=>"","car-battery"=>"","car-building"=>"","car-bump"=>"","car-bus"=>"","car-crash"=>"","car-garage"=>"","car-mechanic"=>"","car-side"=>"","car-tilt"=>"","car-wash"=>"","caravan"=>"","caravan-alt"=>"豈","caret-circle-down"=>"","caret-circle-left"=>"","caret-circle-right"=>"","caret-circle-up"=>"","caret-down"=>"","caret-left"=>"","caret-right"=>"","caret-square-down"=>"","caret-square-left"=>"","caret-square-right"=>"","caret-square-up"=>"","caret-up"=>"","carrot"=>"","cars"=>"","cart-arrow-down"=>"","cart-plus"=>"","cash-register"=>"","cassette-tape"=>"","cat"=>"","cat-space"=>"更","cauldron"=>"","cctv"=>"","certificate"=>"","chair"=>"","chair-office"=>"","chalkboard"=>"","chalkboard-teacher"=>"","charging-station"=>"","chart-area"=>"","chart-bar"=>"","chart-line"=>"","chart-line-down"=>"","chart-network"=>"","chart-pie"=>"","chart-pie-alt"=>"","chart-scatter"=>"","check"=>"","check-circle"=>"","check-double"=>"","check-square"=>"","cheese"=>"","cheese-swiss"=>"","cheeseburger"=>"","chess"=>"","chess-bishop"=>"","chess-bishop-alt"=>"","chess-board"=>"","chess-clock"=>"","chess-clock-alt"=>"","chess-king"=>"","chess-king-alt"=>"","chess-knight"=>"","chess-knight-alt"=>"","chess-pawn"=>"","chess-pawn-alt"=>"","chess-queen"=>"","chess-queen-alt"=>"","chess-rook"=>"","chess-rook-alt"=>"","chevron-circle-down"=>"","chevron-circle-left"=>"","chevron-circle-right"=>"","chevron-circle-up"=>"","chevron-double-down"=>"","chevron-double-left"=>"","chevron-double-right"=>"","chevron-double-up"=>"","chevron-down"=>"","chevron-left"=>"","chevron-right"=>"","chevron-square-down"=>"","chevron-square-left"=>"","chevron-square-right"=>"","chevron-square-up"=>"","chevron-up"=>"","child"=>"","chimney"=>"","church"=>"","circle"=>"","circle-notch"=>"","city"=>"","clarinet"=>"","claw-marks"=>"","clinic-medical"=>"","clipboard"=>"","clipboard-check"=>"","clipboard-list"=>"","clipboard-list-check"=>"","clipboard-prescription"=>"","clipboard-user"=>"","clock"=>"","clone"=>"","closed-captioning"=>"","cloud"=>"","cloud-download"=>"","cloud-download-alt"=>"","cloud-drizzle"=>"","cloud-hail"=>"","cloud-hail-mixed"=>"","cloud-meatball"=>"","cloud-moon"=>"","cloud-moon-rain"=>"","cloud-music"=>"","cloud-rain"=>"","cloud-rainbow"=>"","cloud-showers"=>"","cloud-showers-heavy"=>"","cloud-sleet"=>"","cloud-snow"=>"","cloud-sun"=>"","cloud-sun-rain"=>"","cloud-upload"=>"","cloud-upload-alt"=>"","clouds"=>"","clouds-moon"=>"","clouds-sun"=>"","club"=>"","cocktail"=>"","code"=>"","code-branch"=>"","code-commit"=>"","code-merge"=>"","coffee"=>"","coffee-pot"=>"車","coffee-togo"=>"","coffin"=>"","cog"=>"","cogs"=>"","coin"=>"","coins"=>"","columns"=>"","comet"=>"賈","comment"=>"","comment-alt"=>"","comment-alt-check"=>"","comment-alt-dollar"=>"","comment-alt-dots"=>"","comment-alt-edit"=>"","comment-alt-exclamation"=>"","comment-alt-lines"=>"","comment-alt-medical"=>"","comment-alt-minus"=>"","comment-alt-music"=>"","comment-alt-plus"=>"","comment-alt-slash"=>"","comment-alt-smile"=>"","comment-alt-times"=>"","comment-check"=>"","comment-dollar"=>"","comment-dots"=>"","comment-edit"=>"","comment-exclamation"=>"","comment-lines"=>"","comment-medical"=>"","comment-minus"=>"","comment-music"=>"","comment-plus"=>"","comment-slash"=>"","comment-smile"=>"","comment-times"=>"","comments"=>"","comments-alt"=>"","comments-alt-dollar"=>"","comments-dollar"=>"","compact-disc"=>"","compass"=>"","compass-slash"=>"","compress"=>"","compress-alt"=>"","compress-arrows-alt"=>"","compress-wide"=>"","computer-classic"=>"","computer-speaker"=>"","concierge-bell"=>"","construction"=>"","container-storage"=>"","conveyor-belt"=>"","conveyor-belt-alt"=>"","cookie"=>"","cookie-bite"=>"","copy"=>"","copyright"=>"","corn"=>"","couch"=>"","cow"=>"","cowbell"=>"","cowbell-more"=>"","credit-card"=>"","credit-card-blank"=>"","credit-card-front"=>"","cricket"=>"","croissant"=>"","crop"=>"","crop-alt"=>"","cross"=>"","crosshairs"=>"","crow"=>"","crown"=>"","crutch"=>"","crutches"=>"","cube"=>"","cubes"=>"","curling"=>"","cut"=>"","dagger"=>"","database"=>"","deaf"=>"","debug"=>"","deer"=>"","deer-rudolph"=>"","democrat"=>"","desktop"=>"","desktop-alt"=>"","dewpoint"=>"","dharmachakra"=>"","diagnoses"=>"","diamond"=>"","dice"=>"","dice-d10"=>"","dice-d12"=>"","dice-d20"=>"","dice-d4"=>"","dice-d6"=>"","dice-d8"=>"","dice-five"=>"","dice-four"=>"","dice-one"=>"","dice-six"=>"","dice-three"=>"","dice-two"=>"","digging"=>"","digital-tachograph"=>"","diploma"=>"","directions"=>"","disc-drive"=>"","disease"=>"","divide"=>"","dizzy"=>"","dna"=>"","do-not-enter"=>"","dog"=>"","dog-leashed"=>"","dollar-sign"=>"","dolly"=>"","dolly-empty"=>"","dolly-flatbed"=>"","dolly-flatbed-alt"=>"","dolly-flatbed-empty"=>"","donate"=>"","door-closed"=>"","door-open"=>"","dot-circle"=>"","dove"=>"","download"=>"","drafting-compass"=>"","dragon"=>"","draw-circle"=>"","draw-polygon"=>"","draw-square"=>"","dreidel"=>"","drone"=>"","drone-alt"=>"","drum"=>"","drum-steelpan"=>"","drumstick"=>"","drumstick-bite"=>"","dryer"=>"","dryer-alt"=>"","duck"=>"","dumbbell"=>"","dumpster"=>"","dumpster-fire"=>"","dungeon"=>"","ear"=>"","ear-muffs"=>"","eclipse"=>"","eclipse-alt"=>"","edit"=>"","egg"=>"","egg-fried"=>"","eject"=>"","elephant"=>"","ellipsis-h"=>"","ellipsis-h-alt"=>"","ellipsis-v"=>"","ellipsis-v-alt"=>"","empty-set"=>"","engine-warning"=>"","envelope"=>"","envelope-open"=>"","envelope-open-dollar"=>"","envelope-open-text"=>"","envelope-square"=>"","equals"=>"","eraser"=>"","ethernet"=>"","euro-sign"=>"","exchange"=>"","exchange-alt"=>"","exclamation"=>"","exclamation-circle"=>"","exclamation-square"=>"","exclamation-triangle"=>"","expand"=>"","expand-alt"=>"","expand-arrows"=>"","expand-arrows-alt"=>"","expand-wide"=>"","external-link"=>"","external-link-alt"=>"","external-link-square"=>"","external-link-square-alt"=>"","eye"=>"","eye-dropper"=>"","eye-evil"=>"","eye-slash"=>"","fan"=>"","fan-table"=>"滑","farm"=>"","fast-backward"=>"","fast-forward"=>"","faucet"=>"串","faucet-drip"=>"句","fax"=>"","feather"=>"","feather-alt"=>"","female"=>"","field-hockey"=>"","fighter-jet"=>"","file"=>"","file-alt"=>"","file-archive"=>"","file-audio"=>"","file-certificate"=>"","file-chart-line"=>"","file-chart-pie"=>"","file-check"=>"","file-code"=>"","file-contract"=>"","file-csv"=>"","file-download"=>"","file-edit"=>"","file-excel"=>"","file-exclamation"=>"","file-export"=>"","file-image"=>"","file-import"=>"","file-invoice"=>"","file-invoice-dollar"=>"","file-medical"=>"","file-medical-alt"=>"","file-minus"=>"","file-music"=>"","file-pdf"=>"","file-plus"=>"","file-powerpoint"=>"","file-prescription"=>"","file-search"=>"","file-signature"=>"","file-spreadsheet"=>"","file-times"=>"","file-upload"=>"","file-user"=>"","file-video"=>"","file-word"=>"","files-medical"=>"","fill"=>"","fill-drip"=>"","film"=>"","film-alt"=>"","film-canister"=>"","filter"=>"","fingerprint"=>"","fire"=>"","fire-alt"=>"","fire-extinguisher"=>"","fire-smoke"=>"","fireplace"=>"","first-aid"=>"","fish"=>"","fish-cooked"=>"","fist-raised"=>"","flag"=>"","flag-alt"=>"","flag-checkered"=>"","flag-usa"=>"","flame"=>"","flashlight"=>"","flask"=>"","flask-poison"=>"","flask-potion"=>"","flower"=>"","flower-daffodil"=>"","flower-tulip"=>"","flushed"=>"","flute"=>"","flux-capacitor"=>"","fog"=>"","folder"=>"","folder-minus"=>"","folder-open"=>"","folder-plus"=>"","folder-times"=>"","folder-tree"=>"","folders"=>"","font"=>"","font-case"=>"","football-ball"=>"","football-helmet"=>"","forklift"=>"","forward"=>"","fragile"=>"","french-fries"=>"","frog"=>"","frosty-head"=>"","frown"=>"","frown-open"=>"","function"=>"","funnel-dollar"=>"","futbol"=>"","galaxy"=>"龜","game-board"=>"","game-board-alt"=>"","game-console-handheld"=>"","gamepad"=>"","gamepad-alt"=>"","garage"=>"契","garage-car"=>"金","garage-open"=>"喇","gas-pump"=>"","gas-pump-slash"=>"","gavel"=>"","gem"=>"","genderless"=>"","ghost"=>"","gift"=>"","gift-card"=>"","gifts"=>"","gingerbread-man"=>"","glass"=>"","glass-champagne"=>"","glass-cheers"=>"","glass-citrus"=>"","glass-martini"=>"","glass-martini-alt"=>"","glass-whiskey"=>"","glass-whiskey-rocks"=>"","glasses"=>"","glasses-alt"=>"","globe"=>"","globe-africa"=>"","globe-americas"=>"","globe-asia"=>"","globe-europe"=>"","globe-snow"=>"","globe-stand"=>"","golf-ball"=>"","golf-club"=>"","gopuram"=>"","graduation-cap"=>"","gramophone"=>"","greater-than"=>"","greater-than-equal"=>"","grimace"=>"","grin"=>"","grin-alt"=>"","grin-beam"=>"","grin-beam-sweat"=>"","grin-hearts"=>"","grin-squint"=>"","grin-squint-tears"=>"","grin-stars"=>"","grin-tears"=>"","grin-tongue"=>"","grin-tongue-squint"=>"","grin-tongue-wink"=>"","grin-wink"=>"","grip-horizontal"=>"","grip-lines"=>"","grip-lines-vertical"=>"","grip-vertical"=>"","guitar"=>"","guitar-electric"=>"","guitars"=>"","h-square"=>"","h1"=>"","h2"=>"","h3"=>"","h4"=>"","hamburger"=>"","hammer"=>"","hammer-war"=>"","hamsa"=>"","hand-heart"=>"","hand-holding"=>"","hand-holding-box"=>"","hand-holding-heart"=>"","hand-holding-magic"=>"","hand-holding-seedling"=>"","hand-holding-usd"=>"","hand-holding-water"=>"","hand-lizard"=>"","hand-middle-finger"=>"","hand-paper"=>"","hand-peace"=>"","hand-point-down"=>"","hand-point-left"=>"","hand-point-right"=>"","hand-point-up"=>"","hand-pointer"=>"","hand-receiving"=>"","hand-rock"=>"","hand-scissors"=>"","hand-spock"=>"","hands"=>"","hands-heart"=>"","hands-helping"=>"","hands-usd"=>"","handshake"=>"","handshake-alt"=>"","hanukiah"=>"","hard-hat"=>"","hashtag"=>"","hat-chef"=>"","hat-cowboy"=>"","hat-cowboy-side"=>"","hat-santa"=>"","hat-winter"=>"","hat-witch"=>"","hat-wizard"=>"","hdd"=>"","head-side"=>"","head-side-brain"=>"","head-side-headphones"=>"","head-side-medical"=>"","head-vr"=>"","heading"=>"","headphones"=>"","headphones-alt"=>"","headset"=>"","heart"=>"","heart-broken"=>"","heart-circle"=>"","heart-rate"=>"","heart-square"=>"","heartbeat"=>"","heat"=>"奈","helicopter"=>"","helmet-battle"=>"","hexagon"=>"","highlighter"=>"","hiking"=>"","hippo"=>"","history"=>"","hockey-mask"=>"","hockey-puck"=>"","hockey-sticks"=>"","holly-berry"=>"","home"=>"","home-alt"=>"","home-heart"=>"","home-lg"=>"","home-lg-alt"=>"","hood-cloak"=>"","horizontal-rule"=>"","horse"=>"","horse-head"=>"","horse-saddle"=>"","hospital"=>"","hospital-alt"=>"","hospital-symbol"=>"","hospital-user"=>"","hospitals"=>"","hot-tub"=>"","hotdog"=>"","hotel"=>"","hourglass"=>"","hourglass-end"=>"","hourglass-half"=>"","hourglass-start"=>"","house"=>"懶","house-damage"=>"","house-day"=>"癩","house-flood"=>"","house-leave"=>"羅","house-night"=>"蘿","house-return"=>"螺","house-signal"=>"裸","hryvnia"=>"","humidity"=>"","hurricane"=>"","i-cursor"=>"","ice-cream"=>"","ice-skate"=>"","icicles"=>"","icons"=>"","icons-alt"=>"","id-badge"=>"","id-card"=>"","id-card-alt"=>"","igloo"=>"","image"=>"","image-polaroid"=>"","images"=>"","inbox"=>"","inbox-in"=>"","inbox-out"=>"","indent"=>"","industry"=>"","industry-alt"=>"","infinity"=>"","info"=>"","info-circle"=>"","info-square"=>"","inhaler"=>"","integral"=>"","intersection"=>"","inventory"=>"","island-tropical"=>"","italic"=>"","jack-o-lantern"=>"","jedi"=>"","joint"=>"","journal-whills"=>"","joystick"=>"","jug"=>"","kaaba"=>"","kazoo"=>"","kerning"=>"","key"=>"","key-skeleton"=>"","keyboard"=>"","keynote"=>"","khanda"=>"","kidneys"=>"","kiss"=>"","kiss-beam"=>"","kiss-wink-heart"=>"","kite"=>"","kiwi-bird"=>"","knife-kitchen"=>"","lambda"=>"","lamp"=>"","lamp-desk"=>"樂","lamp-floor"=>"洛","landmark"=>"","landmark-alt"=>"","language"=>"","laptop"=>"","laptop-code"=>"","laptop-medical"=>"","lasso"=>"","laugh"=>"","laugh-beam"=>"","laugh-squint"=>"","laugh-wink"=>"","layer-group"=>"","layer-minus"=>"","layer-plus"=>"","leaf"=>"","leaf-heart"=>"","leaf-maple"=>"","leaf-oak"=>"","lemon"=>"","less-than"=>"","less-than-equal"=>"","level-down"=>"","level-down-alt"=>"","level-up"=>"","level-up-alt"=>"","life-ring"=>"","light-ceiling"=>"烙","light-switch"=>"珞","light-switch-off"=>"落","light-switch-on"=>"酪","lightbulb"=>"","lightbulb-dollar"=>"","lightbulb-exclamation"=>"","lightbulb-on"=>"","lightbulb-slash"=>"","lights-holiday"=>"","line-columns"=>"","line-height"=>"","link"=>"","lips"=>"","lira-sign"=>"","list"=>"","list-alt"=>"","list-music"=>"","list-ol"=>"","list-ul"=>"","location"=>"","location-arrow"=>"","location-circle"=>"","location-slash"=>"","lock"=>"","lock-alt"=>"","lock-open"=>"","lock-open-alt"=>"","long-arrow-alt-down"=>"","long-arrow-alt-left"=>"","long-arrow-alt-right"=>"","long-arrow-alt-up"=>"","long-arrow-down"=>"","long-arrow-left"=>"","long-arrow-right"=>"","long-arrow-up"=>"","loveseat"=>"","low-vision"=>"","luchador"=>"","luggage-cart"=>"","lungs"=>"","mace"=>"","magic"=>"","magnet"=>"","mail-bulk"=>"","mailbox"=>"","male"=>"","mandolin"=>"","map"=>"","map-marked"=>"","map-marked-alt"=>"","map-marker"=>"","map-marker-alt"=>"","map-marker-alt-slash"=>"","map-marker-check"=>"","map-marker-edit"=>"","map-marker-exclamation"=>"","map-marker-minus"=>"","map-marker-plus"=>"","map-marker-question"=>"","map-marker-slash"=>"","map-marker-smile"=>"","map-marker-times"=>"","map-pin"=>"","map-signs"=>"","marker"=>"","mars"=>"","mars-double"=>"","mars-stroke"=>"","mars-stroke-h"=>"","mars-stroke-v"=>"","mask"=>"","meat"=>"","medal"=>"","medkit"=>"","megaphone"=>"","meh"=>"","meh-blank"=>"","meh-rolling-eyes"=>"","memory"=>"","menorah"=>"","mercury"=>"","meteor"=>"","microchip"=>"","microphone"=>"","microphone-alt"=>"","microphone-alt-slash"=>"","microphone-slash"=>"","microphone-stand"=>"","microscope"=>"","microwave"=>"亂","mind-share"=>"","minus"=>"","minus-circle"=>"","minus-hexagon"=>"","minus-octagon"=>"","minus-square"=>"","mistletoe"=>"","mitten"=>"","mobile"=>"","mobile-alt"=>"","mobile-android"=>"","mobile-android-alt"=>"","money-bill"=>"","money-bill-alt"=>"","money-bill-wave"=>"","money-bill-wave-alt"=>"","money-check"=>"","money-check-alt"=>"","money-check-edit"=>"","money-check-edit-alt"=>"","monitor-heart-rate"=>"","monkey"=>"","monument"=>"","moon"=>"","moon-cloud"=>"","moon-stars"=>"","mortar-pestle"=>"","mosque"=>"","motorcycle"=>"","mountain"=>"","mountains"=>"","mouse"=>"","mouse-alt"=>"","mouse-pointer"=>"","mp3-player"=>"","mug"=>"","mug-hot"=>"","mug-marshmallows"=>"","mug-tea"=>"","music"=>"","music-alt"=>"","music-alt-slash"=>"","music-slash"=>"","narwhal"=>"","network-wired"=>"","neuter"=>"","newspaper"=>"","not-equal"=>"","notes-medical"=>"","object-group"=>"","object-ungroup"=>"","octagon"=>"","oil-can"=>"","oil-temp"=>"","om"=>"","omega"=>"","ornament"=>"","otter"=>"","outdent"=>"","outlet"=>"卵","oven"=>"欄","overline"=>"","page-break"=>"","pager"=>"","paint-brush"=>"","paint-brush-alt"=>"","paint-roller"=>"","palette"=>"","pallet"=>"","pallet-alt"=>"","paper-plane"=>"","paperclip"=>"","parachute-box"=>"","paragraph"=>"","paragraph-rtl"=>"","parking"=>"","parking-circle"=>"","parking-circle-slash"=>"","parking-slash"=>"","passport"=>"","pastafarianism"=>"","paste"=>"","pause"=>"","pause-circle"=>"","paw"=>"","paw-alt"=>"","paw-claws"=>"","peace"=>"","pegasus"=>"","pen"=>"","pen-alt"=>"","pen-fancy"=>"","pen-nib"=>"","pen-square"=>"","pencil"=>"","pencil-alt"=>"","pencil-paintbrush"=>"","pencil-ruler"=>"","pennant"=>"","people-carry"=>"","pepper-hot"=>"","percent"=>"","percentage"=>"","person-booth"=>"","person-carry"=>"","person-dolly"=>"","person-dolly-empty"=>"","person-sign"=>"","phone"=>"","phone-alt"=>"","phone-laptop"=>"","phone-office"=>"","phone-plus"=>"","phone-rotary"=>"","phone-slash"=>"","phone-square"=>"","phone-square-alt"=>"","phone-volume"=>"","photo-video"=>"","pi"=>"","piano"=>"","piano-keyboard"=>"","pie"=>"","pig"=>"","piggy-bank"=>"","pills"=>"","pizza"=>"","pizza-slice"=>"","place-of-worship"=>"","plane"=>"","plane-alt"=>"","plane-arrival"=>"","plane-departure"=>"","planet-moon"=>"蘭","planet-ringed"=>"鸞","play"=>"","play-circle"=>"","plug"=>"","plus"=>"","plus-circle"=>"","plus-hexagon"=>"","plus-octagon"=>"","plus-square"=>"","podcast"=>"","podium"=>"","podium-star"=>"","police-box"=>"嵐","poll"=>"","poll-h"=>"","poll-people"=>"","poo"=>"","poo-storm"=>"","poop"=>"","popcorn"=>"","portal-enter"=>"濫","portal-exit"=>"藍","portrait"=>"","pound-sign"=>"","power-off"=>"","pray"=>"","praying-hands"=>"","prescription"=>"","prescription-bottle"=>"","prescription-bottle-alt"=>"","presentation"=>"","print"=>"","print-search"=>"","print-slash"=>"","procedures"=>"","project-diagram"=>"","projector"=>"","pumpkin"=>"","puzzle-piece"=>"","qrcode"=>"","question"=>"","question-circle"=>"","question-square"=>"","quidditch"=>"","quote-left"=>"","quote-right"=>"","quran"=>"","rabbit"=>"","rabbit-fast"=>"","racquet"=>"","radar"=>"襤","radiation"=>"","radiation-alt"=>"","radio"=>"","radio-alt"=>"","rainbow"=>"","raindrops"=>"","ram"=>"","ramp-loading"=>"","random"=>"","raygun"=>"拉","receipt"=>"","record-vinyl"=>"","rectangle-landscape"=>"","rectangle-portrait"=>"","rectangle-wide"=>"","recycle"=>"","redo"=>"","redo-alt"=>"","refrigerator"=>"臘","registered"=>"","remove-format"=>"","repeat"=>"","repeat-1"=>"","repeat-1-alt"=>"","repeat-alt"=>"","reply"=>"","reply-all"=>"","republican"=>"","restroom"=>"","retweet"=>"","retweet-alt"=>"","ribbon"=>"","ring"=>"","rings-wedding"=>"","road"=>"","robot"=>"","rocket"=>"","rocket-launch"=>"蠟","route"=>"","route-highway"=>"","route-interstate"=>"","router"=>"","rss"=>"","rss-square"=>"","ruble-sign"=>"","ruler"=>"","ruler-combined"=>"","ruler-horizontal"=>"","ruler-triangle"=>"","ruler-vertical"=>"","running"=>"","rupee-sign"=>"","rv"=>"","sack"=>"","sack-dollar"=>"","sad-cry"=>"","sad-tear"=>"","salad"=>"","sandwich"=>"","satellite"=>"","satellite-dish"=>"","sausage"=>"","save"=>"","sax-hot"=>"","saxophone"=>"","scalpel"=>"","scalpel-path"=>"","scanner"=>"","scanner-image"=>"","scanner-keyboard"=>"","scanner-touchscreen"=>"","scarecrow"=>"","scarf"=>"","school"=>"","screwdriver"=>"","scroll"=>"","scroll-old"=>"","scrubber"=>"","scythe"=>"","sd-card"=>"","search"=>"","search-dollar"=>"","search-location"=>"","search-minus"=>"","search-plus"=>"","seedling"=>"","send-back"=>"","send-backward"=>"","sensor"=>"廊","sensor-alert"=>"朗","sensor-fire"=>"浪","sensor-on"=>"狼","sensor-smoke"=>"郎","server"=>"","shapes"=>"","share"=>"","share-all"=>"","share-alt"=>"","share-alt-square"=>"","share-square"=>"","sheep"=>"","shekel-sign"=>"","shield"=>"","shield-alt"=>"","shield-check"=>"","shield-cross"=>"","ship"=>"","shipping-fast"=>"","shipping-timed"=>"","shish-kebab"=>"","shoe-prints"=>"","shopping-bag"=>"","shopping-basket"=>"","shopping-cart"=>"","shovel"=>"","shovel-snow"=>"","shower"=>"","shredder"=>"","shuttle-van"=>"","shuttlecock"=>"","sickle"=>"","sigma"=>"","sign"=>"","sign-in"=>"","sign-in-alt"=>"","sign-language"=>"","sign-out"=>"","sign-out-alt"=>"","signal"=>"","signal-1"=>"","signal-2"=>"","signal-3"=>"","signal-4"=>"","signal-alt"=>"","signal-alt-1"=>"","signal-alt-2"=>"","signal-alt-3"=>"","signal-alt-slash"=>"","signal-slash"=>"","signal-stream"=>"","signature"=>"","sim-card"=>"","siren"=>"來","siren-on"=>"冷","sitemap"=>"","skating"=>"","skeleton"=>"","ski-jump"=>"","ski-lift"=>"","skiing"=>"","skiing-nordic"=>"","skull"=>"","skull-cow"=>"","skull-crossbones"=>"","slash"=>"","sledding"=>"","sleigh"=>"","sliders-h"=>"","sliders-h-square"=>"","sliders-v"=>"","sliders-v-square"=>"","smile"=>"","smile-beam"=>"","smile-plus"=>"","smile-wink"=>"","smog"=>"","smoke"=>"","smoking"=>"","smoking-ban"=>"","sms"=>"","snake"=>"","snooze"=>"","snow-blowing"=>"","snowboarding"=>"","snowflake"=>"","snowflakes"=>"","snowman"=>"","snowmobile"=>"","snowplow"=>"","socks"=>"","solar-panel"=>"","solar-system"=>"勞","sort"=>"","sort-alpha-down"=>"","sort-alpha-down-alt"=>"","sort-alpha-up"=>"","sort-alpha-up-alt"=>"","sort-alt"=>"","sort-amount-down"=>"","sort-amount-down-alt"=>"","sort-amount-up"=>"","sort-amount-up-alt"=>"","sort-circle"=>"擄","sort-circle-down"=>"櫓","sort-circle-up"=>"爐","sort-down"=>"","sort-numeric-down"=>"","sort-numeric-down-alt"=>"","sort-numeric-up"=>"","sort-numeric-up-alt"=>"","sort-shapes-down"=>"","sort-shapes-down-alt"=>"","sort-shapes-up"=>"","sort-shapes-up-alt"=>"","sort-size-down"=>"","sort-size-down-alt"=>"","sort-size-up"=>"","sort-size-up-alt"=>"","sort-up"=>"","soup"=>"","spa"=>"","space-shuttle"=>"","space-station-moon"=>"盧","space-station-moon-alt"=>"老","spade"=>"","sparkles"=>"","speaker"=>"","speakers"=>"","spell-check"=>"","spider"=>"","spider-black-widow"=>"","spider-web"=>"","spinner"=>"","spinner-third"=>"","splotch"=>"","spray-can"=>"","sprinkler"=>"蘆","square"=>"","square-full"=>"","square-root"=>"","square-root-alt"=>"","squirrel"=>"","staff"=>"","stamp"=>"","star"=>"","star-and-crescent"=>"","star-christmas"=>"","star-exclamation"=>"","star-half"=>"","star-half-alt"=>"","star-of-david"=>"","star-of-life"=>"","star-shooting"=>"虜","starfighter"=>"路","starfighter-alt"=>"露","stars"=>"","starship"=>"魯","starship-freighter"=>"鷺","steak"=>"","steering-wheel"=>"","step-backward"=>"","step-forward"=>"","stethoscope"=>"","sticky-note"=>"","stocking"=>"","stomach"=>"","stop"=>"","stop-circle"=>"","stopwatch"=>"","store"=>"","store-alt"=>"","stream"=>"","street-view"=>"","stretcher"=>"","strikethrough"=>"","stroopwafel"=>"","subscript"=>"","subway"=>"","suitcase"=>"","suitcase-rolling"=>"","sun"=>"","sun-cloud"=>"","sun-dust"=>"","sun-haze"=>"","sunglasses"=>"","sunrise"=>"","sunset"=>"","superscript"=>"","surprise"=>"","swatchbook"=>"","swimmer"=>"","swimming-pool"=>"","sword"=>"","sword-laser"=>"碌","sword-laser-alt"=>"祿","swords"=>"","swords-laser"=>"綠","synagogue"=>"","sync"=>"","sync-alt"=>"","syringe"=>"","table"=>"","table-tennis"=>"","tablet"=>"","tablet-alt"=>"","tablet-android"=>"","tablet-android-alt"=>"","tablet-rugged"=>"","tablets"=>"","tachometer"=>"","tachometer-alt"=>"","tachometer-alt-average"=>"","tachometer-alt-fast"=>"","tachometer-alt-fastest"=>"","tachometer-alt-slow"=>"","tachometer-alt-slowest"=>"","tachometer-average"=>"","tachometer-fast"=>"","tachometer-fastest"=>"","tachometer-slow"=>"","tachometer-slowest"=>"","taco"=>"","tag"=>"","tags"=>"","tally"=>"","tanakh"=>"","tape"=>"","tasks"=>"","tasks-alt"=>"","taxi"=>"","teeth"=>"","teeth-open"=>"","telescope"=>"菉","temperature-down"=>"錄","temperature-frigid"=>"","temperature-high"=>"","temperature-hot"=>"","temperature-low"=>"","temperature-up"=>"鹿","tenge"=>"","tennis-ball"=>"","terminal"=>"","text"=>"","text-height"=>"","text-size"=>"","text-width"=>"","th"=>"","th-large"=>"","th-list"=>"","theater-masks"=>"","thermometer"=>"","thermometer-empty"=>"","thermometer-full"=>"","thermometer-half"=>"","thermometer-quarter"=>"","thermometer-three-quarters"=>"","theta"=>"","thumbs-down"=>"","thumbs-up"=>"","thumbtack"=>"","thunderstorm"=>"","thunderstorm-moon"=>"","thunderstorm-sun"=>"","ticket"=>"","ticket-alt"=>"","tilde"=>"","times"=>"","times-circle"=>"","times-hexagon"=>"","times-octagon"=>"","times-square"=>"","tint"=>"","tint-slash"=>"","tire"=>"","tire-flat"=>"","tire-pressure-warning"=>"","tire-rugged"=>"","tired"=>"","toggle-off"=>"","toggle-on"=>"","toilet"=>"","toilet-paper"=>"","toilet-paper-alt"=>"","tombstone"=>"","tombstone-alt"=>"","toolbox"=>"","tools"=>"","tooth"=>"","toothbrush"=>"","torah"=>"","torii-gate"=>"","tornado"=>"","tractor"=>"","trademark"=>"","traffic-cone"=>"","traffic-light"=>"","traffic-light-go"=>"","traffic-light-slow"=>"","traffic-light-stop"=>"","trailer"=>"論","train"=>"","tram"=>"","transgender"=>"","transgender-alt"=>"","transporter"=>"壟","transporter-1"=>"弄","transporter-2"=>"籠","transporter-3"=>"聾","transporter-empty"=>"牢","trash"=>"","trash-alt"=>"","trash-restore"=>"","trash-restore-alt"=>"","trash-undo"=>"","trash-undo-alt"=>"","treasure-chest"=>"","tree"=>"","tree-alt"=>"","tree-christmas"=>"","tree-decorated"=>"","tree-large"=>"","tree-palm"=>"","trees"=>"","triangle"=>"","triangle-music"=>"","trophy"=>"","trophy-alt"=>"","truck"=>"","truck-container"=>"","truck-couch"=>"","truck-loading"=>"","truck-monster"=>"","truck-moving"=>"","truck-pickup"=>"","truck-plow"=>"","truck-ramp"=>"","trumpet"=>"","tshirt"=>"","tty"=>"","turkey"=>"","turntable"=>"","turtle"=>"","tv"=>"","tv-alt"=>"","tv-music"=>"","tv-retro"=>"","typewriter"=>"","ufo"=>"磊","ufo-beam"=>"賂","umbrella"=>"","umbrella-beach"=>"","underline"=>"","undo"=>"","undo-alt"=>"","unicorn"=>"","union"=>"","universal-access"=>"","university"=>"","unlink"=>"","unlock"=>"","unlock-alt"=>"","upload"=>"","usb-drive"=>"","usd-circle"=>"","usd-square"=>"","user"=>"","user-alien"=>"壘","user-alt"=>"","user-alt-slash"=>"","user-astronaut"=>"","user-chart"=>"","user-check"=>"","user-circle"=>"","user-clock"=>"","user-cog"=>"","user-cowboy"=>"","user-crown"=>"","user-edit"=>"","user-friends"=>"","user-graduate"=>"","user-hard-hat"=>"","user-headset"=>"","user-injured"=>"","user-lock"=>"","user-md"=>"","user-md-chat"=>"","user-minus"=>"","user-music"=>"","user-ninja"=>"","user-nurse"=>"","user-plus"=>"","user-robot"=>"屢","user-secret"=>"","user-shield"=>"","user-slash"=>"","user-tag"=>"","user-tie"=>"","user-times"=>"","user-visor"=>"樓","users"=>"","users-class"=>"","users-cog"=>"","users-crown"=>"","users-medical"=>"","utensil-fork"=>"","utensil-knife"=>"","utensil-spoon"=>"","utensils"=>"","utensils-alt"=>"","vacuum"=>"淚","vacuum-robot"=>"漏","value-absolute"=>"","vector-square"=>"","venus"=>"","venus-double"=>"","venus-mars"=>"","vhs"=>"","vial"=>"","vials"=>"","video"=>"","video-plus"=>"","video-slash"=>"","vihara"=>"","violin"=>"","voicemail"=>"","volcano"=>"","volleyball-ball"=>"","volume"=>"","volume-down"=>"","volume-mute"=>"","volume-off"=>"","volume-slash"=>"","volume-up"=>"","vote-nay"=>"","vote-yea"=>"","vr-cardboard"=>"","wagon-covered"=>"","walker"=>"","walkie-talkie"=>"","walking"=>"","wallet"=>"","wand"=>"","wand-magic"=>"","warehouse"=>"","warehouse-alt"=>"","washer"=>"","watch"=>"","watch-calculator"=>"","watch-fitness"=>"","water"=>"","water-lower"=>"","water-rise"=>"","wave-sine"=>"","wave-square"=>"","wave-triangle"=>"","waveform"=>"","waveform-path"=>"","webcam"=>"","webcam-slash"=>"","weight"=>"","weight-hanging"=>"","whale"=>"","wheat"=>"","wheelchair"=>"","whistle"=>"","wifi"=>"","wifi-1"=>"","wifi-2"=>"","wifi-slash"=>"","wind"=>"","wind-turbine"=>"","wind-warning"=>"","window"=>"","window-alt"=>"","window-close"=>"","window-frame"=>"累","window-frame-open"=>"縷","window-maximize"=>"","window-minimize"=>"","window-restore"=>"","windsock"=>"","wine-bottle"=>"","wine-glass"=>"","wine-glass-alt"=>"","won-sign"=>"","wreath"=>"","wrench"=>"","x-ray"=>"","yen-sign"=>"","yin-yang"=>""
   	);
   	/**
   	 * @see Walker_Nav_Menu::start_lvl()
   	 * @since 3.0.0
   	 *
   	 * @param string $output Passed by reference.
   	 */
   	function start_lvl(&$output, $depth = 0, $args = array()) {   
   }
   	
   	/**
   	 * @see Walker_Nav_Menu::end_lvl()
   	 * @since 3.0.0
   	 *
   	 * @param string $output Passed by reference.
   	 */
   	function end_lvl(&$output, $depth = 0, $args = array()) {
   }
   	
   	/**
   	 * @see Walker::start_el()
   	 * @since 3.0.0
   	 *
   	 * @param string $output Passed by reference. Used to append additional content.
   	 * @param object $item Menu item data object.
   	 * @param int $depth Depth of menu item. Used for padding.
   	 * @param object $args
   	 */
   	function start_el(&$output, $item,  $depth = 0, $args = array(), $current_object_id = 0){
   	    global $_wp_nav_menu_max_depth;
   	   
   	    $_wp_nav_menu_max_depth = $depth > $_wp_nav_menu_max_depth ? $depth : $_wp_nav_menu_max_depth;
   	
   	    $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
   	
   	    ob_start();
   	    $item_id = esc_attr( $item->ID );
   	    $removed_args = array(
   	        'action',
   	        'customlink-tab',
   	        'edit-menu-item',
   	        'menu-item',
   	        'page-tab',
   	        '_wpnonce',
   	    );
   	
   	    $original_title = '';
   	    if ( 'taxonomy' == $item->type ) {
   	        $original_title = get_term_field( 'name', $item->object_id, $item->object, 'raw' );
   	        if ( is_wp_error( $original_title ) )
   	            $original_title = false;
   	    } elseif ( 'post_type' == $item->type ) {
   	        $original_object = get_post( $item->object_id );
   	        $original_title = $original_object->post_title;
   	    }
   	
   	    $classes = array(
   	        'menu-item menu-item-depth-' . $depth,
   	        'menu-item-' . esc_attr( $item->object ),
   	        'menu-item-edit-' . ( ( isset( $_GET['edit-menu-item'] ) && $item_id == $_GET['edit-menu-item'] ) ? 'active' : 'inactive'),
   	    );
   	
   	    $title = $item->title;
   	
   	    if ( ! empty( $item->_invalid ) ) {
   	        $classes[] = 'menu-item-invalid';
   	        /* translators: %s: title of menu item which is invalid */
   	        $title = sprintf( __( '%s (Invalid)' ), $item->title );
   	    } elseif ( isset( $item->post_status ) && 'draft' == $item->post_status ) {
   	        $classes[] = 'pending';
   	        /* translators: %s: title of menu item in draft status */
   	        $title = sprintf( __('%s (Pending)'), $item->title );
   	    }
   	
   	    $title = empty( $item->label ) ? $title : $item->label;
   	
   	    ?>
<li id="menu-item-<?php echo $item_id; ?>" class="<?php echo implode(' ', $classes ); ?>">
   <dl class="menu-item-bar">
      <dt class="menu-item-handle">
         <span class="item-title"><?php echo esc_html( $title ); ?></span>
         <span class="item-controls">
         <span class="item-type"><?php echo esc_html( $item->type_label ); ?></span>
         <span class="item-order hide-if-js">
         <a href="<?php
            echo wp_nonce_url(
                add_query_arg(
                    array(
                        'action' => 'move-up-menu-item',
                        'menu-item' => $item_id,
                    ),
                    remove_query_arg($removed_args, admin_url( 'nav-menus.php' ) )
                ),
                'move-menu_item'
            );
            ?>" class="item-move-up"><abbr title="<?php esc_attr_e('Move up','dina-kala'); ?>">&#8593;</abbr></a>
         |
         <a href="<?php
            echo wp_nonce_url(
                add_query_arg(
                    array(
                        'action' => 'move-down-menu-item',
                        'menu-item' => $item_id,
                    ),
                    remove_query_arg($removed_args, admin_url( 'nav-menus.php' ) )
                ),
                'move-menu_item'
            );
            ?>" class="item-move-down"><abbr title="<?php esc_attr_e('Move down','dina-kala'); ?>">&#8595;</abbr></a>
         </span>
         <a class="item-edit" id="edit-<?php echo $item_id; ?>" title="<?php esc_attr_e('Edit Menu Item','dina-kala'); ?>" href="<?php
            echo ( isset( $_GET['edit-menu-item'] ) && $item_id == $_GET['edit-menu-item'] ) ? admin_url( 'nav-menus.php' ) : add_query_arg( 'edit-menu-item', $item_id, remove_query_arg( $removed_args, admin_url( 'nav-menus.php#menu-item-settings-' . $item_id ) ) );
            ?>"><?php _e( 'Edit Menu Item','dina-kala' ); ?></a>
         </span>
      </dt>
   </dl>
   <div class="menu-item-settings" id="menu-item-settings-<?php echo $item_id; ?>">
      <?php if( 'custom' == $item->type ) : ?>
      <p class="field-url description description-wide">
         <label for="edit-menu-item-url-<?php echo $item_id; ?>">
         <?php _e( 'URL' ); ?><br />
         <input type="text" id="edit-menu-item-url-<?php echo $item_id; ?>" class="widefat code edit-menu-item-url" name="menu-item-url[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->url ); ?>" />
         </label>
      </p>
      <?php endif; ?>
      <p class="description description-thin">
         <label for="edit-menu-item-title-<?php echo $item_id; ?>">
         <?php _e( 'Navigation Label' ); ?><br />
         <input type="text" id="edit-menu-item-title-<?php echo $item_id; ?>" class="widefat edit-menu-item-title" name="menu-item-title[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->title ); ?>" />
         </label>
      </p>
      <p class="description description-thin">
         <label for="edit-menu-item-attr-title-<?php echo $item_id; ?>">
         <?php _e( 'Title Attribute' ); ?><br />
         <input type="text" id="edit-menu-item-attr-title-<?php echo $item_id; ?>" class="widefat edit-menu-item-attr-title" name="menu-item-attr-title[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->post_excerpt ); ?>" />
         </label>
      </p>
      <p class="field-link-target description">
         <label for="edit-menu-item-target-<?php echo $item_id; ?>">
         <input type="checkbox" id="edit-menu-item-target-<?php echo $item_id; ?>" value="_blank" name="menu-item-target[<?php echo $item_id; ?>]"<?php checked( $item->target, '_blank' ); ?> />
         <?php _e( 'Open link in a new window/tab' ); ?>
         </label>
      </p>
      <p class="field-css-classes description description-thin">
         <label for="edit-menu-item-classes-<?php echo $item_id; ?>">
         <?php _e( 'CSS Classes (optional)','dina-kala' ); ?><br />
         <input type="text" id="edit-menu-item-classes-<?php echo $item_id; ?>" class="widefat code edit-menu-item-classes" name="menu-item-classes[<?php echo $item_id; ?>]" value="<?php echo esc_attr( implode(' ', $item->classes ) ); ?>" />
         </label>
      </p>
      <p class="field-xfn description description-thin">
         <label for="edit-menu-item-xfn-<?php echo $item_id; ?>">
         <?php _e( 'Link Relationship (XFN)' ); ?><br />
         <input type="text" id="edit-menu-item-xfn-<?php echo $item_id; ?>" class="widefat code edit-menu-item-xfn" name="menu-item-xfn[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->xfn ); ?>" />
         </label>
      </p>
      <p class="field-description description description-wide">
         <label for="edit-menu-item-description-<?php echo $item_id; ?>">
         <?php _e( 'Description' ); ?><br />
         <textarea id="edit-menu-item-description-<?php echo $item_id; ?>" class="widefat edit-menu-item-description" rows="3" cols="20" name="menu-item-description[<?php echo $item_id; ?>]"><?php echo esc_html( $item->description ); // textarea_escaped ?></textarea>
         <span class="description"><?php _e('The description will be displayed in the menu if the current theme supports it.'); ?></span>
         </label>
      </p>
      <?php
         /* New fields insertion starts here */
         ?>      
      <p class="field-custom description description-wide">
         <label for="edit-menu-item-icon-<?php echo $item_id; ?>">
         <?php _e( 'Menu Icon' , 'dina-kala' ); ?><br />
         <?php $icon_font_awesome = '
            <select id="edit-menu-item-icon-'.$item_id.'" name="menu-item-icon['.$item_id.']" class="widefat code edit-menu-item-custom js-example-basic-single icons-font-awesome">
            	<option value="none" '.selected(esc_attr( $item->icon ), 'none', FALSE).'>'.__( '-- none --' , 'dina-kala' ).'</option>';
            foreach($this->icons_font_awesome as $name => $code)
            {
            $icon_font_awesome .= '
            	<option value="fal fa-'.$name.'" '.selected(esc_attr( $item->icon ), 'fal fa-'.$name, FALSE).'>'.$code.'&nbsp;&nbsp;'.$name.'</option>';
            }
            
            $icon_font_awesome .= '
            </select>';
            
            echo $icon_font_awesome;
            
            ?>
         </label>
      </p>
      <p class="field-custom description description-wide">
         <label style="margin-top:5px;float:right;" for="edit-menu-item-cmega-<?php echo $item_id; ?>">
         <?php echo '<input type="checkbox" id="edit-menu-item-cmega-'.$item_id.'" name="menu-item-cmega['.$item_id.']" class="menu-item-cmega widefat"';
        if ($item->cmega) {echo 'checked';}
        echo '/>';
			?>
		<?php _e( 'Disable MegaMenu' , 'dina-kala' ); ?>
         </label>
      </p>
      <p class="field-custom description description-wide">
         <label style="margin-top:5px;float:right;" for="edit-menu-item-cimage-<?php echo $item_id; ?>">
         <?php echo '<input type="checkbox" id="edit-menu-item-cimage-'.$item_id.'" name="menu-item-cimage['.$item_id.']" class="menu-item-cimage widefat"';
        if ($item->cimage) {echo 'checked';}
        echo '/>';
			?>
		<?php _e( 'Use as Menu Image' , 'dina-kala' ); ?>
         </label>
      </p>
      <p class="field-custom menu-image description description-wide">
		 <label for="edit-menu-item-image-<?php echo $item_id; ?>">
		 <?php _e( 'Menu Image' , 'dina-kala' ); ?>
         <?php echo '<input type="text" id="edit-menu-item-image-'.$item_id.'" name="menu-item-image['.$item_id.']" class="widefat code custom_media_url" value="'.esc_attr( $item->image ).'" />';
            ?>
            <input type="button" class="button button-primary custom_media_button" id="custom_media_button" name="menu-item-image-btn[<?php echo $item_id; ?>]" value="<?php _e( 'Select Image' , 'dina-kala' ); ?>" style="margin-top:5px;" />
         </label>
      </p>
      <?php
         /* New fields insertion ends here */
         ?>
      <div class="menu-item-actions description-wide submitbox">
         <?php if( 'custom' != $item->type && $original_title !== false ) : ?>
         <p class="link-to-original">
            <?php printf( __('Original: %s','dina-kala'), '<a href="' . esc_attr( $item->url ) . '">' . esc_html( $original_title ) . '</a>' ); ?>
         </p>
         <?php endif; ?>
         <a class="item-delete submitdelete deletion" id="delete-<?php echo $item_id; ?>" href="<?php
            echo wp_nonce_url(
                add_query_arg(
                    array(
                        'action' => 'delete-menu-item',
                        'menu-item' => $item_id,
                    ),
                    remove_query_arg($removed_args, admin_url( 'nav-menus.php' ) )
                ),
                'delete-menu_item_' . $item_id
            ); ?>"><?php _e('Remove','dina-kala'); ?></a> <span class="meta-sep"> | </span> <a class="item-cancel submitcancel" id="cancel-<?php echo $item_id; ?>" href="<?php echo esc_url( add_query_arg( array('edit-menu-item' => $item_id, 'cancel' => time()), remove_query_arg( $removed_args, admin_url( 'nav-menus.php' ) ) ) );
            ?>#menu-item-settings-<?php echo $item_id; ?>"><?php _e('Cancel','dina-kala'); ?></a>
      </div>
      <input class="menu-item-data-db-id" type="hidden" name="menu-item-db-id[<?php echo $item_id; ?>]" value="<?php echo $item_id; ?>" />
      <input class="menu-item-data-object-id" type="hidden" name="menu-item-object-id[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->object_id ); ?>" />
      <input class="menu-item-data-object" type="hidden" name="menu-item-object[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->object ); ?>" />
      <input class="menu-item-data-parent-id" type="hidden" name="menu-item-parent-id[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->menu_item_parent ); ?>" />
      <input class="menu-item-data-position" type="hidden" name="menu-item-position[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->menu_order ); ?>" />
      <input class="menu-item-data-type" type="hidden" name="menu-item-type[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->type ); ?>" />
   </div>
   <!-- .menu-item-settings-->
   <ul class="menu-item-transport"></ul>
   <?php
      $output .= ob_get_clean();
      
      }
      }
            