<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */
    load_theme_textdomain( 'dina-kala', get_template_directory() . '/languages' );
    if ( ! class_exists( 'Redux' ) ) {
        return;
    }
    if ( ! class_exists( 'ReduxFramework_extension_vendor_support' ) ) {
        if ( file_exists( dirname( __FILE__ ) . '/sample/vendor_support/extension_vendor_support.php' ) ) {
            require dirname( __FILE__ ) . '/sample/vendor_support/extension_vendor_support.php';
            new ReduxFramework_extension_vendor_support();
        }
    }
    //FontAwesome Icons
    require_once( dirname( __FILE__ ) . '/sample/fa.php' );
    // This is your option name where all the Redux data is stored.
    $opt_name = "di_data";

    //Redux's constants
    define ('RE_URI' , get_template_directory_uri() . '/includes/ReduxCore/');
    define ('RE_DIR' , get_template_directory() . '/includes/ReduxCore/');

    // Background Patterns Reader
    $sample_patterns_path = RE_DIR . 'assets/img/patterns/';
    $sample_patterns_url  = RE_URI . 'assets/img/patterns/';
    $sample_patterns      = array();
    
    if ( is_dir( $sample_patterns_path ) ) {

        if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
            $sample_patterns = array();

            while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

                if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $sample_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                    $sample_patterns[] = array(
                        'alt' => $name,
                        'img' => $sample_patterns_url . $sample_patterns_file
                    );
                }
            }
        }
    }

    //Footer Background Patterns Reader
    $footer_patterns_path = RE_DIR . 'assets/img/fbg/';
    $footer_patterns_url  = RE_URI . 'assets/img/fbg/';
    $footer_patterns      = array();
    
    if ( is_dir( $footer_patterns_path ) ) {

        if ( $footer_patterns_dir = opendir( $footer_patterns_path ) ) {
            $footer_patterns = array();

            while ( ( $footer_patterns_file = readdir( $footer_patterns_dir ) ) !== false ) {

                if ( stristr( $footer_patterns_file, '.png' ) !== false || stristr( $footer_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $footer_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $footer_patterns_file );
                    $footer_patterns[] = array(
                        'alt' => $name,
                        'img' => $footer_patterns_url . $footer_patterns_file
                    );
                }
            }
        }
    }

    $col_number = [];
    foreach(range(1, 24) as $number)
    {
        $col_number[$number] = $number;
    }

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'submenu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'Theme Settings', 'dina-kala' ),
        'page_title'           => __( 'Theme Settings', 'dina-kala' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-admin-generic',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => true,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => false,
        'show_options_object' => false,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );
    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        $args['intro_text'] = '';
    } else {
        $args['intro_text'] = '';
    }

    // Add content after the form.
    $args['footer_text'] = '';

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => __( 'Template guide', 'dina-kala' ),
            'content' => __( 'If you have questions about working with the template, contact meysam98@gmail.com.', 'dina-kala' )
        ),
    );
    Redux::setHelpTab( $opt_name, $tabs );
    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    // -> START Basic Fields
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Home Settings', 'dina-kala' ),
        'id'               => 'menu_home',
        'desc'             => __( 'Home page settings', 'dina-kala' ),
        'customizer_width' => '400px',
        'icon'             => 'el el-home'
    ) );

    Redux::setSection( $opt_name, array(
        'title'            => __( 'Site logo', 'dina-kala' ),
        'icon'             => 'el el-picasa',
        'id'               => 'sitelogo',
        'subsection'       => true,
        'customizer_width' => '450px',
        'desc'             => __( 'Site Logo Settings', 'dina-kala' ),
        'fields'           => array(
            array(
                'id'       => 'site_logo',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'Your logo', 'dina-kala' ),
                'compiler' => 'true',
                'desc'     => __( 'Upload your site logo from this section.', 'dina-kala' ),
                'subtitle' => __( 'Appropriate size: 57 in 160', 'dina-kala' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/logo.png" ),
            ),
            array(
                'id'       => 'site_logo_retina',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'Retina logo', 'dina-kala' ),
                'compiler' => 'true',
                'desc'     => __( 'Upload a site logo in a two-dimensional size to the current logo', 'dina-kala' ),
                'subtitle' => __( 'Appropriate size: 114 in 320', 'dina-kala' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/logo2x.png" ),
            ),
            array(
                'id'       => 'site_favicon',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'Favicon', 'dina-kala' ),
                'compiler' => 'true',
                'mode'      => false, 
                'desc'     => __( 'Upload your site icons. This icon is displayed in some browsers next to your site URL.', 'dina-kala' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/favicon.png" ),
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'            => __( 'Template style', 'dina-kala' ),
        'icon'             => 'el el-brush',
        'id'               => 'theme-style',
        'subsection'       => true,
        'customizer_width' => '500px',
        'desc'             => __( 'Customize and change the color and style of the template', 'dina-kala' ),
        'fields'           => array(
            array(
            'id'       => 'custom_color',
            'type'     => 'color',
            'title'    => __( 'Template color', 'dina-kala' ),
            'subtitle' => __( 'Choose the color scheme for the template, this color will be displayed as the main theme of the site in most sections, such as the menu and widgets.', 'dina-kala' ),
            'default'  => '#17A2B8',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'price_color',
            'type'     => 'color',
            'title'    => __( 'Price color', 'dina-kala' ),
            'subtitle' => __( 'Choose the color for the prices.', 'dina-kala' ),
            'default'  => '#39b156',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'read_product_color',
            'type'     => 'color',
            'title'    => __( 'Read more and View product button color', 'dina-kala' ),
            'default'  => '#28A745',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'read_product_text_color',
            'type'     => 'color',
            'title'    => __( 'Read more and View product button text color', 'dina-kala' ),
            'default'  => '#fff',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'read_product_hover_color',
            'type'     => 'color',
            'title'    => __( 'Read more and View product button hover and click color', 'dina-kala' ),
            'default'  => '#1E7E34',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'read_product_hover_text_color',
            'type'     => 'color',
            'title'    => __( 'Read more and View product button hover and click text color', 'dina-kala' ),
            'default'  => '#fff',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'dis_color',
            'type'     => 'color',
            'title'    => __( 'Discount badge color', 'dina-kala' ),
            'subtitle' => __( 'Choose the color for the Discount badge.', 'dina-kala' ),
            'default'  => '#ef5350',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'dis_text_color',
            'type'     => 'color',
            'title'    => __( 'Discount badge text color', 'dina-kala' ),
            'subtitle' => __( 'Choose the color for the Discount badge text.', 'dina-kala' ),
            'default'  => '#fff',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'rounded_corners',
            'type'     => 'switch',
            'title'    => __( 'Rounded Corners', 'dina-kala' ),
            'subtitle' => __( 'Round corners for different parts of the site.', 'dina-kala' ),
            'default'  => true
            ),
            array(
                'id'       => 'site_bg',
                'type'     => 'image_select',
                'output'    => array('body'), // An array of CSS selectors
                'tiles'    => true,
                'title'    => __( 'Background', 'dina-kala' ),
                'subtitle' => __( 'Select a picture as a background.', 'dina-kala' ),
                'options'  => $sample_patterns,
                'required' => array( 'bg_switch', '!=', true ),
            ),
            array(
                'id'       => 'bg_switch',
                'type'     => 'switch',
                'title'    => __( 'Custom background', 'dina-kala' ),
                'subtitle' => __( 'Choose a background color or upload a custom photo', 'dina-kala' ),
                'default'  => false
            ),
            array(         
                'id'       => 'site_bg_custom',
                'output'    => array('body'), // An array of CSS selectors
                'type'     => 'background',
                'title'    => __( 'Customize the site background according to your taste.', 'dina-kala' ),
                'default'  => array(
                    'background-color' => '#F5F5F5',
                ),
                'required' => array( 'bg_switch', '=', true ),
            ),
        )
    ) );

    // -> START Editors
    Redux::setSection( $opt_name, array(
        'title'            => __( 'General settings', 'dina-kala' ),
        'id'               => 'general_setting',
        'customizer_width' => '500px',
        'icon'             => 'el el-cogs',
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Maintenance mode', 'dina-kala' ),
        'icon'       => 'el el-wrench',
        'id'         => 'maintenance_mode',
        'desc'       => __( 'In the site maintenance mode it will be unavailable to users and only the administrator can view it', 'dina-kala' ),
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'maintenance',
                'type'     => 'switch',
                'title'    => __( 'Enable maintenance mode', 'dina-kala' ),
                'subtitle' => __( 'In this case, the site will be unavailable to users', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id'       => 'maintenance_title',
                'type'     => 'text',
                'title'    => __( 'Title', 'dina-kala' ),
                'subtitle' => __( 'Maintenance mode title', 'dina-kala' ),
                'default'  => __( 'Maintenance Mode', 'dina-kala' ),
                'required' => array( 'maintenance', '=', true ),
            ),
            array(
                'id'      => 'maintenance_msg',
                'type'    => 'editor',
                'title'   => __( 'Message', 'dina-kala' ),
                'default'  => __( 'Site is under construction, please be patient.', 'dina-kala' ),
                'args'    => array(
                    'wpautop'       => false,
                    'media_buttons' => false,
                    'textarea_rows' => 5,
                    'teeny'         => false,
                    'quicktags'     => true,
                ),
                'required' => array( 'maintenance', '=', true ),
            ),
        ),
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Header settings', 'dina-kala' ),
        'icon'       => 'el el-credit-card',
        'id'         => 'header-setting',
        'subsection' => true,
        'desc'       => __( 'Customize site header', 'dina-kala' ),
        'fields'     => array(
            array(
                'id'       => 'head_pos',
                'type'     => 'image_select',
                'title'    =>  __( 'Header Menu position', 'dina-kala' ),
                'subtitle' => __( 'Locate the Header Menu.', 'dina-kala' ),
                'options'  => array(
                    '1' => array(
                        'alt' => __( 'Right', 'dina-kala' ),
                        'img' => RE_URI . 'assets/img/rmenu.png'
                    ),
                    '2' => array(
                        'alt' => __( 'Left', 'dina-kala' ),
                        'img' => RE_URI . 'assets/img/lmenu.png'
                    ),
                ),
                'default'  => '1'
            ),
            array(
                'id'       => 'logo_pos',
                'type'     => 'image_select',
                'title'    =>  __( 'Logo position', 'dina-kala' ),
                'subtitle' => __( 'Locate the site logo.', 'dina-kala' ),
                'options'  => array(
                    '1' => array(
                        'alt' => __( 'Right side', 'dina-kala' ),
                        'img' => RE_URI . 'assets/img/rlogo.png'
                    ),
                    '2' => array(
                        'alt' => __( 'Left side', 'dina-kala' ),
                        'img' => RE_URI . 'assets/img/llogo.png'
                    ),
                ),
                'default'  => '1'
            ),
            array(
                'id'       => 'hide_top_bar',
                'type'     => 'switch',
                'title'    => __('Hide Site Top Bar (Contact, Menu and Social)','dina-kala'),
                'subtitle' => __('By Activating this option site top bar not displayed.','dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'ajax_search',
                'type'     => 'switch',
                'title'    => __('Ajax Live Search','dina-kala'),
                'subtitle' => __('Enabling this feature will show search results by entering a keyword','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'search_cat',
                'type'     => 'switch',
                'title'    => __('Show Search Category','dina-kala'),
                'subtitle' => __('Show category box in search section','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'fixed_head_top',
                'type'     => 'switch',
                'title'    => __( 'Fixed menu', 'dina-kala' ),
                'subtitle' => __( 'Fixed the header menu when scrolling through the site', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'focus_nav',
                'type'     => 'switch',
                'title'    => __( 'Page darkening', 'dina-kala' ),
                'subtitle' => __( 'Darken the page by hovering over the menu', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'show_user_btn',
                'type'     => 'switch',
                'title'    => __( 'User Buttons', 'dina-kala' ),
                'subtitle' => __( 'Show user buttons (login, register and user menu) in the header section', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'user_btn_style',
                'type'     => 'switch',
                'title'    => __( 'User Buttons Text style', 'dina-kala' ),
                'subtitle' => __( 'Show user buttons (login and register) in text style', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id'       => 'show_mo_btn',
                'type'     => 'switch',
                'title'    => __( 'Show user buttons in mobile mode', 'dina-kala' ),
                'default'  => true,
                'required' => array( 'show_user_btn', '=', true ),
            ),
            array(
                'id'       => 'digits_mode',
                'type'     => 'switch',
                'title'    => __( 'Compatibility with Digits plugin', 'dina-kala' ),
                'subtitle' => __('If you have a Digit plugin installed, the login and registration buttons will be connected to this plugin','dina-kala'),
                'default'  => true,
                'required' => array( 'show_user_btn', '=', true ),
            ),
            array(
                'id'       => 'digits_page',
                'type'     => 'switch',
                'title'    => __( 'Link to Digits page instead of pop-up mode', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'digits_mode', '=', true ),
            ),
            array(
                'id'       => 'recapcha_login',
                'type'     => 'switch',
                'title'    => __('Google Captcha in the login section','dina-kala'),
                'subtitle' => __('Activate Google Captcha in login form','dina-kala'),
                'default'  => false,
                'required' => array( 'show_user_btn', '=', true ),
            ),
            array(
                'id'       => 'site_key',
                'type'     => 'text',
                'title' => __('Site key','dina-kala'),
                'description' => __('Get it from the link: <a href="https://www.google.com/recaptcha/" target="_blank"> Google</a>','dina-kala'),
                'required' => array( 'recapcha_login', '=', true ),
            ),
            array(
                'id'       => 'site_secret',
                'type'     => 'text',
                'title' => __('Security key','dina-kala'),
                'description' => __('Get it from the link: <a href="https://www.google.com/recaptcha/" target="_blank"> Google</a>','dina-kala'),
                'required' => array( 'recapcha_login', '=', true ),
            ),
            array(
                'id'       => 'ch_login_link',
                'type'     => 'switch',
                'title' => __( 'Change link to the login page', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_user_btn', '=', true ),
            ),
            array(
                'id'       => 'login_link',
                'type'     => 'text',
                'title' => __( 'Link to the login page', 'dina-kala' ),
                'Subtitle' => __( 'Full page link', 'dina-kala' ),
                'description' => __( 'Example: http://example.com/login', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'ch_login_link', '=', true ),
            ),
            array(
                'id'       => 'ch_register_link',
                'type'     => 'switch',
                'title' => __( 'Change link to the register page', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_user_btn', '=', true ),
            ),
            array(
                'id'       => 'register_link',
                'type'     => 'text',
                'title'    => __( 'Link to the register page', 'dina-kala' ),
                'subtitle' => __( 'Full page link', 'dina-kala' ),
                'description' => __( 'Example: http://example.com/register', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'ch_register_link', '=', true ),
            ),
            array(
                'id'       => 'show_cart_btn',
                'type'     => 'switch',
                'title'    => __( 'Show Cart button', 'dina-kala' ),
                'subtitle' => __( 'Show Cart button in menu bar', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'show_wish_list',
                'type'     => 'switch',
                'title'    => __( 'Show Wishlist button', 'dina-kala' ),
                'subtitle' => __( 'Show Wishlist button in menu bar', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'show_compare_btn',
                'type'     => 'switch',
                'title'    => __( 'Show Compare button', 'dina-kala' ),
                'subtitle' => __( 'Show Compare button in menu bar', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'show_bread',
                'type'     => 'switch',
                'title'    => __( 'Breadcrumbs', 'dina-kala' ),
                'subtitle' => __( 'Show the breadcrumbs (your links on the route sign)', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'show_loading_bar',
                'type'     => 'switch',
                'title'    => __( 'Loading bar', 'dina-kala' ),
                'subtitle' => __( 'View the loading bar at the top of the site', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'show_msg',
                'type'     => 'switch',
                'title'    => __( 'Show message', 'dina-kala' ),
                'subtitle' => __( 'Show message section', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'=>'site_msg',
                'type' => 'textarea',
                'title' => __( 'Text message', 'dina-kala' ),
                'default' => __( 'Sell Easy with DinaKala and Start Making Your Internet Money!', 'dina-kala' ),
                'allowed_html' => array(
                    'a' => array(
                        'href' => array(),
                        'title' => array()
                    ),
                    'br' => array(),
                    'em' => array(),
                    'strong' => array()
                ),
                'required' => array( 'show_msg', '=', true ),
            ),
            array(
                'id'       => 'msg_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __( 'Icon', 'dina-kala' ),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-bell',
                'options'  => $iconArray,
                'required' => array( 'show_msg', '=', true ),
            ),
            array(
                'id'       => 'msg_btn',
                'type'     => 'switch',
                'title'    => __( 'Show button', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_msg', '=', true ),
            ),
            array(
                'id'       => 'msg_btn_color',
                'type'     => 'select',
                'title' => __( 'Button color', 'dina-kala' ),
                'options'  => array(
                    'btn-info'  =>  __( 'Blue', 'dina-kala' ),
                    'btn-warning' =>  __( 'Yellow', 'dina-kala' ),
                    'btn-success'  =>  __( 'Green', 'dina-kala' ),
                    'btn-danger'  =>  __( 'Red', 'dina-kala' )
                ),
                'default'  => 'btn-success',
                'required' => array( 'msg_btn', '=', true ),
            ),
            array(
                'id'       => 'msg_btn_text',
                'type'     => 'text',
                'title' => __( 'Button text', 'dina-kala' ),
                'default'  => __( 'View and buy', 'dina-kala' ),
                'required' => array( 'msg_btn', '=', true ),
            ),
            array(
                'id'       => 'msg_btn_link',
                'type'     => 'text',
                'title' => __( 'Button link', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'msg_btn', '=', true ),
            ),
            array(
                'id'       => 'user_close',
                'type'     => 'switch',
                'title'    => __( 'User closure', 'dina-kala' ),
                'default'  => true,
                'required' => array( 'show_msg', '=', true ),
            ),
            array(
            'id'       => 'msg_bgcolor',
            'type'     => 'color',
            'title'    => __( 'Background color', 'dina-kala' ),
            'default'  => '#37474F',
            'validate' => 'color',
            'transparent' => false,
            'required' => array( 'show_msg', '=', true ),
            ),
            array(
            'id'       => 'msg_fcolor',
            'type'     => 'color',
            'title'    => __( 'Text message color', 'dina-kala' ),
            'default'  => '#ffffff',
            'validate' => 'color',
            'transparent' => false,
            'required' => array( 'show_msg', '=', true ),
            ),
            array(
                'id'       => 'show_contact',
                'type'     => 'switch',
                'title'    => __( 'Contact information', 'dina-kala' ),
                'subtitle' => __( 'Show contact information', 'dina-kala' ),
                'default'  => true,
                'required' => array( 'show_head_social', '!=', true ),
            ),
            array(
                'id'       => 'site_tel',
                'type'     => 'text',
                'title'    => __( 'Phone', 'dina-kala' ),
                'default'  => '9123332222 98+',
                'required' => array( 'show_contact', '=', true ),
            ),
            array(
                'id'       => 'site_email',
                'type'     => 'text',
                'title' => __( 'Email', 'dina-kala' ),
                'default'  => 'info@site.com',
                'required' => array( 'show_contact', '=', true ),
            ),
            array(
                'id'       => 'show_head_social',
                'type'     => 'switch',
                'title'    => __( 'View social networks in header', 'dina-kala' ),
                'subtitle' => __( 'View social networks instead of contact information', 'dina-kala' ),
                'default'  => false,
            ),
            array(
            'id'       => 'head_bg_color',
            'type'     => 'color',
            'title'    => __( 'Header background color', 'dina-kala' ),
            'subtitle' => __( 'Choose the color scheme for the site header background color', 'dina-kala' ),
            'default'  => '#fff',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'head_text_color',
            'type'     => 'color',
            'title'    => __( 'Header text color', 'dina-kala' ),
            'subtitle' => __( 'Choose the color scheme for the site header text color', 'dina-kala' ),
            'default'  => '#505763',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'menu_bg_color',
            'type'     => 'color',
            'title'    => __( 'Primary menu background color', 'dina-kala' ),
            'subtitle' => __( 'Choose the color scheme for the primary menu background color', 'dina-kala' ),
            'default'  => '#F7F6F6',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'menu_text_color',
            'type'     => 'color',
            'title'    => __( 'Primary menu text color', 'dina-kala' ),
            'subtitle' => __( 'Choose the color scheme for the primary menu text color', 'dina-kala' ),
            'default'  => '#4D4D4D',
            'validate' => 'color',
            'transparent' => false,
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Footer settings', 'dina-kala' ),
        'icon'       => 'el el-credit-card',
        'id'         => 'footer-setting',
        'subsection' => true,
        'desc'       => __( 'Customize site footer', 'dina-kala' ),
        'fields'     => array(
            array(
                'id'       => 'footer_widgets',
                'type'     => 'image_select',
                'title'    =>  __( 'Footer widgets columns', 'dina-kala' ),
                'options'  => array(
                    '4' => array(
                        'alt' => __( 'Four columns', 'dina-kala' ),
                        'img' => RE_URI . 'assets/img/4col.png'
                    ),
                    '3' => array(
                        'alt' => __( 'Three columns', 'dina-kala' ),
                        'img' => RE_URI . 'assets/img/3col.png'
                    ),
                ),
                'default'  => '4'
            ),
            array(
                'id'       => 'show_info_bar',
                'type'     => 'switch',
                'title' => __( 'Site information section', 'dina-kala' ),
                'subtitle' => __( 'Display information section in the footer section to show the number of users, purchases and ...', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id'       => 'info_bar_prods',
                'type'     => 'switch',
                'title' => __( 'Show products count', 'dina-kala' ),
                'default'  => true,
                'required' => array( 'show_info_bar', '=', true ),
            ),
            array(
                'id'       => 'info_bar_sales',
                'type'     => 'switch',
                'title' => __( 'Show sales count', 'dina-kala' ),
                'default'  => true,
                'required' => array( 'show_info_bar', '=', true ),
            ),
            array(
                'id'       => 'info_bar_users',
                'type'     => 'switch',
                'title' => __( 'Show users count', 'dina-kala' ),
                'default'  => true,
                'required' => array( 'show_info_bar', '=', true ),
            ),
            array(
                'id'       => 'info_bar_posts',
                'type'     => 'switch',
                'title' => __( 'Show posts count', 'dina-kala' ),
                'default'  => true,
                'required' => array( 'show_info_bar', '=', true ),
            ),
            array(
                'id'       => 'show_addr',
                'type'     => 'switch',
                'title' => __( 'Address section', 'dina-kala' ),
                'subtitle' => __( 'Display the Address section in the footer', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id'       => 'show_faddr',
                'type'     => 'switch',
                'title' => __( 'View Address', 'dina-kala' ),
                'subtitle' => __( 'View Address in the footer', 'dina-kala' ),
                'default'  => true,
                'required' => array( 'show_addr', '=', true ),
            ),
            array(
                'id'       => 'addr_text',
                'type'     => 'text',
                'title' => __( 'Address', 'dina-kala' ),
                'default'  => __( 'Tehran Province, Tehran, Central Street, Central Building, No. 7', 'dina-kala' ),
                'required' => array( 'show_faddr', '=', true ),
            ),
            array(
                'id'       => 'show_ftel',
                'type'     => 'switch',
                'title' => __( 'View phone', 'dina-kala' ),
                'subtitle' => __( 'View phone in the footer', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_addr', '=', true ),
            ),
            array(
                'id'       => 'show_fmail',
                'type'     => 'switch',
                'title' => __( 'View email', 'dina-kala' ),
                'subtitle' => __( 'View email in the footer', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_addr', '=', true ),
            ),
            array(
                'id'       => 'show_apps',
                'type'     => 'switch',
                'title' => __( 'Application Buttons', 'dina-kala' ),
                'subtitle' => __( 'Display application buttons in the footer', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_addr', '=', true ),
            ),
            array(
                'id'       => 'and_link',
                'type'     => 'text',
                'title' => __( 'Android Link', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'show_apps', '=', true ),
            ),
            array(
                'id'       => 'ios_link',
                'type'     => 'text',
                'title' => __( 'IOS Link', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'show_apps', '=', true ),
            ),
            array(
                'id'       => 'show_footer_text',
                'type'     => 'switch',
                'title'    => __('Display text section of footer', 'dina-kala'),
                'subtitle' => __('Show a section to display text in the footer area', 'dina-kala'),
                'default'  => false
            ),
            array(
                'id'       => 'ftext_title',
                'default'  => __( 'Footer text', 'dina-kala' ),
                'type'     => 'text',
                'title'    => __( 'Footer text section title', 'dina-kala' ),
                'required' => array( 'show_footer_text', '=', true ),
            ),
            array(
                'id'      => 'ftext_text',
                'type'    => 'editor',
                'title'   => __( 'Footer section text', 'dina-kala' ),
                'default' => __('<p>This text is editable through the theme settings section. You can display text in the footer section of the site.</p>', 'dina-kala'),
                'args'    => array(
                    'wpautop'       => false,
                    'media_buttons' => false,
                    'textarea_rows' => 5,
                    'teeny'         => false,
                    'quicktags'     => true,
                ),
                'required' => array( 'show_footer_text', '=', true ),            
            ),
            array(
                'id'=>'copy_text',
                'type' => 'textarea',
                'title' => __( 'Copyright text', 'dina-kala' ),
                'subtitle' => __( 'Change the text in the site footer.', 'dina-kala' ),
                'default' => __( 'All rights reserved to our site.', 'dina-kala' ),
                'allowed_html' => array(
                    'a' => array(
                        'href' => array(),
                        'title' => array()
                    ),
                    'br' => array(),
                    'em' => array(),
                    'strong' => array()
                ),
            ),
            array(
            'id'       => 'copy_bg_color',
            'type'     => 'color',
            'title'    => __( 'Copyright Background color', 'dina-kala' ),
            'subtitle' => __( 'Choose the color scheme for the copyright background color', 'dina-kala' ),
            'default'  => '#fff',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'copy_text_color',
            'type'     => 'color',
            'title'    => __( 'Copyright Text color', 'dina-kala' ),
            'subtitle' => __( 'Choose the color scheme for the copyright text color', 'dina-kala' ),
            'default'  => '#212529',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
                'id'       => 'footer_bg',
                'type'     => 'image_select',
                'output'    => array('.sfooter'),
                'tiles'    => true,
                'title'    => __('Footer site background','dina-kala'),
                'subtitle' => __("Select an image as the background of the site's footer.",'dina-kala'),
                'options'  => $footer_patterns,
                'required' => array( 'fbg_switch', '!=', true ),
            ),
            array(
                'id'       => 'fbg_switch',
                'type'     => 'switch',
                'title'    => __('Custom Footer Background','dina-kala'),
                'subtitle' => __('Choose a background color or upload a custom photo to the site footer','dina-kala'),
                'default'  => false
            ),
            array(         
                'id'       => 'site_fbg_custom',
                'output'    => array('.sfooter'),
                'type'     => 'background',
                'title'    => __("Customize the background of the site's footer to your liking.",'dina-kala'),
                'default'  => array(
                    'background-color' => '#2d2d2d',
                ),
                'required' => array( 'fbg_switch', '=', true ),
            )
        )
    ) );

        Redux::setSection( $opt_name, array(
        'title'      => __( 'Other settings', 'dina-kala' ),
        'icon'       => 'el el-cog',
        'id'         => 'side-setting',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'mobile_side',
                'type'     => 'switch',
                'title' => __( 'Sidebar display on mobile and tablet' , 'dina-kala'),
                'subtitle' => __( 'Displays the sidebar of the site in mobile and tablet mode' , 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'side_sticky',
                'type'     => 'switch',
                'title' => __( 'Sticky Sidebar' , 'dina-kala'),
                'subtitle' => __( 'In this case the widgets and the content section remain fixed while scrolling the page so that no space is left.' , 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'hide_mobile_bar',
                'type'     => 'switch',
                'title' => __( 'Hide Mobile Bottom Bar' , 'dina-kala'),
                'subtitle' => __( 'Hide the bottom bar displayed at the bottom of the site in mobile mode' , 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'site_schema',
                'type'     => 'switch',
                'title' => __( 'Schema Codes' , 'dina-kala'),
                'subtitle' => __( 'Add Schema codes to product sections and content' , 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'remove_download',
                'type'     => 'switch',
                'title' => __( 'Remove download option' , 'dina-kala'),
                'subtitle' => __( 'Remove download option from menu and user panel' , 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'show_return_top',
                'type'     => 'switch',
                'title' => __( 'Back to top button', 'dina-kala' ),
                'subtitle' => __( 'Show back to top button', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'return_top_bottom',
                'type'     => 'text',
                'title' =>  __( 'Distance from the bottom', 'dina-kala' ),
                'default'  => '40',
                'required' => array( 'show_return_top', '=', true ),
            ),
            array(
                'id'       => 'return_top_right',
                'type'     => 'text',
                'title' => __( 'Distance from the right', 'dina-kala' ),
                'default'  => '20',
                'required' => array( 'show_return_top', '=', true ),
            ),
            array(
                'id'       => 'tag_number',
                'type'     => 'text',
                'title' => __( 'Number of Widget tags', 'dina-kala' ),
                'subtitle' => __( 'The number of tags displayed in the cloud tag widget.', 'dina-kala' ),
                'default'  => 32,
            ),
            array(
                'id'       => 'show_abar',
                'type'     => 'switch',
                'title' => __( 'Hide the Admin Bar', 'dina-kala' ),
                'subtitle' => __( 'Hide admin bar when viewing site', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'show_abar_admin',
                'type'     => 'switch',
                'title' => __( 'Show only for admin', 'dina-kala' ),
                'subtitle' => __( 'Show admin bar only for site admin', 'dina-kala' ),
                'default'  => true,
                'required' => array( 'show_abar', '=', true ),
            ),
            array(
                'id'       => 'show_page_loading',
                'type'     => 'switch',
                'title' => __( 'Display loading', 'dina-kala' ),
                'subtitle' => __( 'Show loading mode when loading pages', 'dina-kala' ),
                'default'  => true,
            ),
            array( 
                'id'       => 'load_img',
                'type'     => 'select_image',
                'title'    => __( 'Loading image', 'dina-kala' ),
                'subtitle' => __( 'Select image loading', 'dina-kala' ),
                'options'  => Array(
                    Array (
                         'alt'  => __( 'Image 1', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader0.gif',
                    ),
                    Array (
                         'alt'  => __( 'Image 2', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader1.gif',
                    ),
                    Array (
                         'alt'  => __( 'Image 3', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader2.gif',
                    ),
                    Array (
                         'alt'  => __( 'Image 4', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader3.gif',
                    ),
                    Array (
                         'alt'  => __( 'Image 5', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader4.gif',
                    ),
                    Array (
                         'alt'  => __( 'Image 6', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader5.gif',
                    ),
                    Array (
                         'alt'  => __( 'Image 7', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader6.gif',
                    ),
                    Array (
                         'alt'  => __( 'Image 8', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader7.gif',
                    ),
                    Array (
                         'alt'  => __( 'Image 9', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader8.gif',
                    ),
                    Array (
                         'alt'  => __( 'Image 10', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader9.gif',
                    ),
                    Array (
                         'alt'  => __( 'Image 11', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader10.gif',
                    )
                    
                ),
                'required' => array( 'show_page_loading', '=', true ),
                'default'  => RE_URI .'assets/img/loading/loader0.gif'
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Product Settings', 'dina-kala' ),
        'id'         => 'product_setting',
        'desc'       => __( "Enter the link to the site's social pages", 'dina-kala' ),
        'icon'       => 'el el-shopping-cart',
        'fields'     => array(
            array(
                'id'       => 'product_side',
                'type'     => 'image_select',
                'title'    => __('Products Sidebar','dina-kala'),
                'subtitle' => __('Specify the location of the products sidebar, this feature is also customizable for each product.','dina-kala'),
                'options'  => array(
                    '0' => array(
                        'alt' => __('No sidebar','dina-kala'),
                        'img' => RE_URI . 'assets/img/1c.png'
                    ),
                    '1' => array(
                        'alt' => __('Left side','dina-kala'),
                        'img' => RE_URI . 'assets/img/2cl.png'
                    ),
                    '2' => array(
                        'alt' => __('Right side','dina-kala'),
                        'img' => RE_URI . 'assets/img/2cr.png'
                    )
                ),
                'default'  => '0'
            ),
            array(
                'id'       => 'product_archive_side',
                'type'     => 'image_select',
                'title'    => __('Products Archive Sidebar','dina-kala'),
                'subtitle' => __('Specify the location of the products sidebar in archive pages (Category page, Tag page, ...)','dina-kala'),
                'options'  => array(
                    '0' => array(
                        'alt' => __('No sidebar','dina-kala'),
                        'img' => RE_URI . 'assets/img/1c.png'
                    ),
                    '1' => array(
                        'alt' => __('Left side','dina-kala'),
                        'img' => RE_URI . 'assets/img/2cl.png'
                    ),
                    '2' => array(
                        'alt' => __('Right side','dina-kala'),
                        'img' => RE_URI . 'assets/img/2cr.png'
                    )
                ),
                'default'  => '1'
            ),
            array(
                'id'       => 'product_num',
                'type'     => 'select',
                'title' => __('Number of products', 'dina-kala'),
                'subtitle' => __('Number of products in archive pages', 'dina-kala'),
                'options'  => $col_number,
                'default'  => 12,
            ),
            array(
                'id'       => 'product_col',
                'type'     => 'select',
                'title' => __('Number of products columns', 'dina-kala'),
                'subtitle' => __('Number of products columns in archive pages', 'dina-kala'),
                'options'  => array(
                    2 =>  2,
                    3 =>  3,
                    4 =>  4,
                    5 =>  5,
                ),
                'default'  => 4,
            ),
            array(
                'id'       => 'show_free_price',
                'type'     => 'switch',
                'title'    => __('Show Free Price instead of zero price','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'show_zero_call',
                'type'     => 'switch',
                'title'    => __('Show Call instead of Free Price','dina-kala'),
                'subtitle' => __('Show phrase call instead of free quote for zero price products','dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'remove_price_range',
                'type'     => 'switch',
                'title'    => __('Remove price range','dina-kala'),
                'subtitle' => __('Remove price range and display the lowest price','dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'ajax_prod',
                'type'     => 'switch',
                'title'    => __('Ajax Products Loading','dina-kala'),
                'subtitle' => __('Loading products ajax and remove pagination','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'ajax_add',
                'type'     => 'switch',
                'title'    => __('Ajax add to cart','dina-kala'),
                'subtitle' => __('Product has been added Ajax to the cart (without loading page again)','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'like_prod',
                'type'     => 'switch',
                'title' => __('Like Product Button','dina-kala'),
                'subtitle' => __('Show Like Product Button in product page','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'compare_prod',
                'type'     => 'switch',
                'title' => __('Compare Product Button','dina-kala'),
                'subtitle' => __('Show Compare Product Button in product page','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'share_prod',
                'type'     => 'switch',
                'title' => __('Share Product Button','dina-kala'),
                'subtitle' => __('Show Share Product Button in product page','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'show_prod_sku',
                'type'     => 'switch',
                'title' => __('Show product SKU','dina-kala'),
                'subtitle' => __('Show product SKU in product page','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'show_prodf_title',
                'type'     => 'switch',
                'title' => __('Show product features title','dina-kala'),
                'subtitle' => __('Show product features title in product page','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'show_related_p',
                'type'     => 'switch',
                'title' => __('Related Product','dina-kala'),
                'subtitle' => __('Show related product section in product page','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'related_p_title',
                'type'     => 'text',
                'title' => __('Block title','dina-kala'),
                'default'  => __('Related Produts','dina-kala'),   
                'required' => array( 'show_related_p', '=', true ),
            ),
            array(
                'id'       => 'related_p_count',
                'type'     => 'text',
                'title' => __('Product total count','dina-kala'),
                'default'  => 8,   
                'required' => array( 'show_related_p', '=', true ),
            ),
            array(
                'id'       => 'related_p_by',
                'type'     => 'select',
                'title' => __('Show related product by','dina-kala'),
                'options'  => array(
                    'product_cat' =>  __('Product category','dina-kala'),
                    'product_tag'  =>  __('Product tag','dina-kala'),
                ),
                'default'  => 'product_cat',
                'required' => array( 'show_related_p', '=', true ),
            ),
            array(
                'id'       => 'show_out_prod',
                'type'     => 'switch',
                'title' => __('Show in stock products','dina-kala'),
                'default'  => true,
                'required' => array( 'show_related_p', '=', true ),
            ),
            array(
                'id'       => 'show_arrows',
                'type'     => 'switch',
                'title' => __('Show arrows','dina-kala'),
                'default'  => true,
                'required' => array( 'show_related_p', '=', true ),
            ),
            array(
                'id'       => 'prod_loop',
                'type'     => 'switch',
                'title' => __('Product loop','dina-kala'),
                'default'  => false,
                'required' => array( 'show_related_p', '=', true ),
            ),
            array(
                'id'       => 'auto_play',
                'type'     => 'switch',
                'title' => __('Auto play','dina-kala'),
                'default'  => false,
                'required' => array( 'show_related_p', '=', true ),
            ),
            array(
                'id'       => 'pcount',
                'type'     => 'text',
                'title' => __('Product count','dina-kala'),
                'default'  => 5,                
                'required' => array( 'show_related_p', '=', true ),
            ),
            array(
                'id'       => 'show_extra',
                'type'     => 'switch',
                'title'    => __('View site features section','dina-kala'),
                'default'  => true
            ),
            array(
                'id'       => 'show_extra_mobile',
                'type'     => 'switch',
                'title'    => __('View site features section in mobile mode','dina-kala'),
                'default'  => true,
                'required' => array( 'show_extra', '=', true ),
            ),
            array(
                'id'       => 'show_extra_one',
                'type'     => 'switch',
                'title'    => __('Show first feature','dina-kala'),
                'default'  => true,
                'required' => array( 'show_extra', '=', true ),
            ),
            array(
                'id'       => 'extra_one_title',
                'type'     => 'text',
                'title' => __('First feature title','dina-kala'),
                'default'  => __('Guarantee the best market price','dina-kala'),
                'required' => array( 'show_extra_one', '=', true ),
            ),
            array(
                'id'       => 'extra_one_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __('Icon','dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-credit-card',
                'options'  => $iconArray,
                'required' => array( 'show_extra_one', '=', true ),
            ),
            array(
                'id'       => 'show_extra_two',
                'type'     => 'switch',
                'title'    => __('Show second feature','dina-kala'),
                'default'  => true,
                'required' => array( 'show_extra', '=', true ),
            ),
            array(
                'id'       => 'extra_two_title',
                'type'     => 'text',
                'title'    => __('Second feature title','dina-kala'),
                'default'  => __('Excellent support, 7 days a week','dina-kala'),
                'required' => array( 'show_extra_two', '=', true ),
            ),
            array(
                'id'       => 'extra_two_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __('Icon','dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-headset',
                'options'  => $iconArray,
                'required' => array( 'show_extra_two', '=', true ),
            ),
            array(
                'id'       => 'show_extra_three',
                'type'     => 'switch',
                'title'    => __('Show third feature','dina-kala'),
                'default'  => true,
                'required' => array( 'show_extra', '=', true ),
            ),
            array(
                'id'       => 'extra_three_title',
                'type'     => 'text',
                'title'    => __('Third feature title','dina-kala'),
                'default'  => __('Refund if unsatisfied','dina-kala'),
                'required' => array( 'show_extra_three', '=', true ),
            ),
            array(
                'id'       => 'extra_three_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __('Icon','dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-history',
                'options'  => $iconArray,
                'required' => array( 'show_extra_three', '=', true ),
            ),
            array(
                'id'       => 'show_extra_four',
                'type'     => 'switch',
                'title'    => __('Show fourth feature','dina-kala'),
                'default'  => true,
                'required' => array( 'show_extra', '=', true ),
            ),
            array(
                'id'       => 'extra_four_title',
                'type'     => 'text',
                'title'    => __('Fourth feature title','dina-kala'),
                'default'  => __('Originality of goods from top brands','dina-kala'),
                'required' => array( 'show_extra_four', '=', true ),
            ),
            array(
                'id'       => 'extra_four_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __('Icon','dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-certificate',
                'options'  => $iconArray,
                'required' => array( 'show_extra_four', '=', true ),
            ),
            array(
                'id'       => 'show_extra_five',
                'type'     => 'switch',
                'title'    => __('Show fifth feature','dina-kala'),
                'default'  => true,
                'required' => array( 'show_extra', '=', true ),
            ),
            array(
                'id'       => 'extra_five_title',
                'type'     => 'text',
                'title'    => __('Fifth feature title','dina-kala'),
                'default'  => __('Falt delivery in the shortest possible time','dina-kala'),
                'required' => array( 'show_extra_five', '=', true ),
            ),
            array(
                'id'       => 'extra_five_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __('Icon','dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-shipping-fast',
                'options'  => $iconArray,
                'required' => array( 'show_extra_five', '=', true ),
            ),
        ),
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Post Settings', 'dina-kala' ),
        'id'         => 'post_setting',
        'desc'       => __( "Enter the link to the site's social pages", 'dina-kala' ),
        'icon'       => 'el el-list-alt',
        'fields'     => array(
            array(
                'id'       => 'post_archive_side',
                'type'     => 'image_select',
                'title'    => __('Posts Archive Sidebar','dina-kala'),
                'subtitle' => __('Specify the location of the posts sidebar in archive pages (Category page, Tag page, ...)','dina-kala'),
                'options'  => array(
                    '1' => array(
                        'alt' => __('Left side','dina-kala'),
                        'img' => RE_URI . 'assets/img/2cl.png'
                    ),
                    '2' => array(
                        'alt' => __('Right side','dina-kala'),
                        'img' => RE_URI . 'assets/img/2cr.png'
                    )
                ),
                'default'  => '1'
            ),
            array(
                'id'       => 'post_col',
                'type'     => 'select',
                'title' => __('Number of posts columns', 'dina-kala'),
                'subtitle' => __('Number of posts columns in archive pages', 'dina-kala'),
                'options'  => array(
                    2 =>  2,
                    3 =>  3,
                    4 =>  4,
                ),
                'default'  => 4,
            ),
            array(
                'id'       => 'ajax_post',
                'type'     => 'switch',
                'title'    => __('Ajax Posts loading','dina-kala'),
                'subtitle' => __('Loading posts ajax and remove pagination','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'show_post_thumb',
                'type'     => 'switch',
                'title' => __('Show Post Thumbnail','dina-kala'),
                'subtitle' => __('Show Post Thumbnail in top of post content','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'show_post_tags',
                'type'     => 'switch',
                'title'    => __('View Post tags section','dina-kala'),
                'default'  => true
            ),
            array(
                'id'       => 'show_post_cats',
                'type'     => 'switch',
                'title'    => __('View Post category section','dina-kala'),
                'default'  => true
            ),
            array(
                'id'       => 'show_post_view',
                'type'     => 'switch',
                'title'    => __('View Post view section','dina-kala'),
                'default'  => true
            ),
            array(
                'id'       => 'share_post',
                'type'     => 'switch',
                'title' => __('Share Post Button','dina-kala'),
                'subtitle' => __('Show Share Post Button in post page','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'show_related_post',
                'type'     => 'switch',
                'title' => __('Related Post','dina-kala'),
                'subtitle' => __('Show related post section in post page','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'related_post_title',
                'type'     => 'text',
                'title' => __('Block title','dina-kala'),
                'default'  => __('Related Posts','dina-kala'),   
                'required' => array( 'show_related_post', '=', true ),
            ),
            array(
                'id'       => 'related_post_count',
                'type'     => 'text',
                'title' => __('Post total count','dina-kala'),
                'default'  => 8,   
                'required' => array( 'show_related_post', '=', true ),
            ),
            array(
                'id'       => 'related_post_by',
                'type'     => 'select',
                'title' => __('Show related post by','dina-kala'),
                'options'  => array(
                    'category' =>  __('Post category','dina-kala'),
                    'post_tag'  =>  __('Post tag','dina-kala'),
                ),
                'default'  => 'category',
                'required' => array( 'show_related_post', '=', true ),
            ),
            array(
                'id'       => 'show_post_arrows',
                'type'     => 'switch',
                'title' => __('Show arrows','dina-kala'),
                'default'  => true,
                'required' => array( 'show_related_post', '=', true ),
            ),
            array(
                'id'       => 'post_loop',
                'type'     => 'switch',
                'title' => __('Post loop','dina-kala'),
                'default'  => false,
                'required' => array( 'show_related_post', '=', true ),
            ),
            array(
                'id'       => 'auto_post_play',
                'type'     => 'switch',
                'title' => __('Auto play','dina-kala'),
                'default'  => false,
                'required' => array( 'show_related_post', '=', true ),
            ),
            array(
                'id'       => 'postcount',
                'type'     => 'text',
                'title' => __('Post count','dina-kala'),
                'default'  => 5,                
                'required' => array( 'show_related_post', '=', true ),
            ),
        ),
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Social Media', 'dina-kala' ),
        'id'         => 'menu_social',
        'desc'       => __( "Enter the link to the site's social pages", 'dina-kala' ),
        'icon'       => 'el el-facebook',
        'fields'     => array(
            array(
                'id'       => 'so_facebook',
                'type'     => 'switch',
                'title' => __( 'Facebook', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'so_facebook_link',
                'type'     => 'text',
                'title' => __('Link','dina-kala'),
                'default'  => '#',                
                'required' => array( 'so_facebook', '=', true ),
            ),
            array(
                'id'       => 'so_google',
                'type'     => 'switch',
                'title' => __('Google+','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'so_google_link',
                'type'     => 'text',
                'title' => __('Link','dina-kala'),
                'default'  => '#',
                'required' => array( 'so_google', '=', true ),
            ),
            array(
                'id'       => 'so_twitter',
                'type'     => 'switch',
                'title' => __('Twitter','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'so_twitter_link',
                'type'     => 'text',
                'title' => __('Link','dina-kala'),
                'default'  => '#',
                'required' => array( 'so_twitter', '=', true ),
            ),
            array(
                'id'       => 'so_youtube',
                'type'     => 'switch',
                'title' => __('Youtube','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'so_youtube_link',
                'type'     => 'text',
                'title' => __('Link','dina-kala'),
                'default'  => '#',
                'required' => array( 'so_youtube', '=', true ),
            ),
            array(
                'id'       => 'so_dribble',
                'type'     => 'switch',
                'title' => __('Dribble','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'so_dribble_link',
                'type'     => 'text',
                'title' => __('Link','dina-kala'),
                'default'  => '#',
                'required' => array( 'so_dribble', '=', true ),
            ),
            array(
                'id'       => 'so_linkedin',
                'type'     => 'switch',
                'title' => __('Linkedin','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'so_linkedin_link',
                'type'     => 'text',
                'title' => __('Link','dina-kala'),
                'default'  => '#',
                'required' => array( 'so_linkedin', '=', true ),
            ),
            array(
                'id'       => 'so_instagram',
                'type'     => 'switch',
                'title' => __('Instagram','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'so_instagram_link',
                'type'     => 'text',
                'title' => __('Link','dina-kala'),
                'default'  => '#',
                'required' => array( 'so_instagram', '=', true ),
            ),
            array(
                'id'       => 'so_telegram',
                'type'     => 'switch',
                'title' => __('Telegram','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'so_telegram_link',
                'type'     => 'text',
                'title' => __('Link','dina-kala'),
                'default'  => '#',
                'required' => array( 'so_telegram', '=', true ),
            ),
            array(
                'id'       => 'so_pinterest',
                'type'     => 'switch',
                'title' => __('Pinterest','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'so_pinterest_link',
                'type'     => 'text',
                'title' => __('Link','dina-kala'),
                'default'  => '#',
                'required' => array( 'so_pinterest', '=', true ),
            ),
            array(
                'id'       => 'so_whatsapp',
                'type'     => 'switch',
                'title' => __('Whatsapp','dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'so_whatsapp_link',
                'type'     => 'text',
                'title' => __('Link','dina-kala'),
                'default'  => '#',
                'required' => array( 'so_whatsapp', '=', true ),
            ),
            array(
                'id'       => 'so_aparat',
                'type'     => 'switch',
                'title' => __('Aparat','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'so_aparat_link',
                'type'     => 'text',
                'title' => __('Link','dina-kala'),
                'default'  => '#',
                'required' => array( 'so_aparat', '=', true ),
            ),
            array(
                'id'       => 'so_cloob',
                'type'     => 'switch',
                'title' => __('Cloob','dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'so_cloob_link',
                'type'     => 'text',
                'title' => __('Link','dina-kala'),
                'default'  => '#',
                'required' => array( 'so_cloob', '=', true ),
            ),
            array(
                'id'       => 'so_soroush',
                'type'     => 'switch',
                'title' => __('Soroush','dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'so_soroush_link',
                'type'     => 'text',
                'title' => __('Link','dina-kala'),
                'default'  => '#',
                'required' => array( 'so_soroush', '=', true ),
            ),
            array(
                'id'       => 'so_gap',
                'type'     => 'switch',
                'title' => __('Gap','dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'so_gap_link',
                'type'     => 'text',
                'title' => __('Link','dina-kala'),
                'default'  => '#',
                'required' => array( 'so_gap', '=', true ),
            ),
            array(
                'id'       => 'so_eitaa',
                'type'     => 'switch',
                'title' => __('Eitaa','dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'so_eitaa_link',
                'type'     => 'text',
                'title' => __('Link','dina-kala'),
                'default'  => '#',
                'required' => array( 'so_eitaa', '=', true ),
            ),
            array(
                'id'       => 'so_bisphone',
                'type'     => 'switch',
                'title' => __('Bisphone','dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'so_bisphone_link',
                'type'     => 'text',
                'title' => __('Link','dina-kala'),
                'default'  => '#',
                'required' => array( 'so_bisphone', '=', true ),
            ),
            array(
                'id'       => 'so_bale',
                'type'     => 'switch',
                'title' => __('Bale','dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'so_bale_link',
                'type'     => 'text',
                'title' => __('Link','dina-kala'),
                'default'  => '#',
                'required' => array( 'so_bale', '=', true ),
            ),
            array(
                'id'       => 'so_igap',
                'type'     => 'switch',
                'title' => __('iGap','dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'so_igap_link',
                'type'     => 'text',
                'title' => __('Link','dina-kala'),
                'default'  => '#',
                'required' => array( 'so_igap', '=', true ),
            ),
        ),
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Custom Codes', 'dina-kala' ),
        'id'         => 'menu_example',
        'desc'       => __( 'Custom Codes Settings', 'dina-kala' ),
        'icon'       => 'el el-css',
        'fields'     => array(
            array(
                'id'       => 'custom_css',
                'type'     => 'ace_editor',
                'title'    => __( 'Custom style sheet', 'dina-kala' ),
                'subtitle' => __( 'Add your custom style sheets quickly to the template.', 'dina-kala' ),
                'mode'     => 'css',
                'theme'    => 'chrome'
            ),
            array(
                'id'       => 'header_codes',
                'type'     => 'ace_editor',
                'title'    => __( 'Header script', 'dina-kala' ),
                'subtitle' => __( 'Enter the codes you need to add to the header section of the template (like meta tags) here.', 'dina-kala' ),
                'mode'     => 'javascript',
                'theme'    => 'chrome'
            ),
            array(
                'id'       => 'footer_codes',
                'type'     => 'ace_editor',
                'title'    => __( 'Footer script', 'dina-kala' ),
                'subtitle' => __( 'Add the codes you need to add to the footer template (like Google Analytics) here.', 'dina-kala' ),
                'mode'     => 'javascript',
                'theme'    => 'chrome'
            ),
        ),
    ) );
    /*
     * <--- END SECTIONS
     */


    /*
     *
     * YOU MUST PREFIX THE FUNCTIONS BELOW AND ACTION FUNCTION CALLS OR ANY OTHER CONFIG MAY OVERRIDE YOUR CODE.
     *
     */

    /*
    *
    * --> Action hook examples
    *
    */

    // If Redux is running as a plugin, this will remove the demo notice and links
    //add_action( 'redux/loaded', 'remove_demo' );

    // Function to test the compiler hook and demo CSS output.
    // Above 10 is a priority, but 2 in necessary to include the dynamically generated CSS to be sent to the function.
    //add_filter('redux/options/' . $opt_name . '/compiler', 'compiler_action', 10, 3);

    // Change the arguments after they've been declared, but before the panel is created
    //add_filter('redux/options/' . $opt_name . '/args', 'change_arguments' );

    // Change the default value of a field after it's been set, but before it's been useds
    //add_filter('redux/options/' . $opt_name . '/defaults', 'change_defaults' );

    // Dynamically add a section. Can be also used to modify sections/fields
    //add_filter('redux/options/' . $opt_name . '/sections', 'dynamic_section');

    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    /**
     * Custom function for the callback validation referenced above
     * */
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $field['msg']    = 'your custom error message';
                $return['error'] = $field;
            }

            if ( $warning == true ) {
                $field['msg']      = 'your custom warning message';
                $return['warning'] = $field;
            }

            return $return;
        }
    }

    /**
     * Custom function for the callback referenced above
     */
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => __( 'Section via hook', 'dina-kala' ),
                'desc'   => __( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'dina-kala' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    /**
     * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
     * */
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    /**
     * Filter hook for filtering the default value of any given field. Very useful in development mode.
     * */
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }

    /**
     * Removes the demo link and the notice of integrated demo from the redux-framework plugin
     */
    if ( ! function_exists( 'remove_demo' ) ) {
        function remove_demo() {
            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
                remove_filter( 'plugin_row_meta', array(
                    ReduxFrameworkPlugin::instance(),
                    'plugin_metalinks'
                ), null, 2 );

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
            }
        }
    }

function removeDemoModeLink() { // Be sure to rename this function to something more unique
    if ( class_exists('ReduxFrameworkPlugin') ) {
        remove_filter( 'plugin_row_meta', array( ReduxFrameworkPlugin::get_instance(), 'plugin_metalinks'), null, 2 );
    }
    if ( class_exists('ReduxFrameworkPlugin') ) {
        remove_action('admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );    
    }
}
add_action('init', 'removeDemoModeLink');