<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: Hosseinkhani.ir
*/
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
global $di_data;
dfile_scheck();
if (!current_user_can('administrator'))
	{
	if ($di_data['maintenance'])
		{
		get_template_part('under-page');
		die();
		}
	}
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

    <head>
        <link rel="shortcut icon" href="<?php echo $di_data['site_favicon']['url']; ?>" type="image/x-icon" />
        <meta http-equiv="Content-Type" content="text/html; charset=<?php bloginfo('charset'); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <meta name="theme-color" content="<?php echo $di_data['custom_color']; ?>" />
        <meta name="fontiran.com:license" content="B3L8B">
        <?php if (is_singular()) { wp_enqueue_script('comment-reply'); } ?>
        <link rel="alternate" type="appliction/rss+xml" href="<?php bloginfo('rss2_url'); ?>" title="<?php printf(__('Latest Articles %s', 'dina-kala') , esc_html(get_bloginfo('name') , 1)); ?>" />
        <link rel="alternate" type="appliction/rss+xml" href="<?php bloginfo('comments_rss2_url'); ?>" title="<?php printf(__('Last comments %s', 'dina-kala') , esc_html(get_bloginfo('name') , 1)); ?>" />
        <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
        <?php wp_head(); ?>
    </head>

    <body <?php body_class(); ?> <?php if($di_data['site_schema']) {?>itemscope itemtype="https://schema.org/WebPage"
    <?php } ?>>

    <?php if ($di_data['show_page_loading']) { ?>
    <!-- Page Loding -->
    <div class="se-pre-con"></div>
    <?php } ?>

        <?php if(!$di_data['hide_mobile_bar']) { ?>
        <div class="mobile-footer">
            <ul>

                <li class="return-top">
                    <span title="<?php echo __('Return Top', 'dina-kala'); ?>">
                        <i aria-hidden="true" class="fal fa-chevron-up"></i>
                    </span>
                </li>

                <?php if($di_data['show_wish_list'] && class_exists( 'JVM_WooCommerce_Wishlist' )) { ?>
                <li>
                    <a href="<?php echo jvm_get_wishlist_url(); ?>" title="<?php echo __('Wishlist', 'dina-kala'); ?>">
                    <span title="<?php echo __('Wishlist', 'dina-kala'); ?>">
                        <i aria-hidden="true" class="fal fa-heart"></i>
                    </span>
                    </a>
                </li>
                <?php } ?>

                <?php global $post; if(is_singular('product')) { ?>
                <li>
                    <span class="go-to-add" title="<?php echo __('Add to cart', 'dina-kala'); ?>">
                        <i aria-hidden="true" class="fal fa-cart-plus"></i>
                    </span>
                </li>
                <?php } else { ?>
                <li>
                    <a href="<?php echo esc_url(home_url()); ?>" title="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>">
                    <span title="<?php echo __('Home', 'dina-kala'); ?>">
                        <i aria-hidden="true" class="fal fa-home"></i>
                    </span>
                    </a>
                </li>
                <?php } ?>

                <?php 
                if ( defined( 'WCCM_VERISON' ) ) {
                $compare_url = wccm_get_compare_page_link( wccm_get_compare_list() );
                $compare_count = count(wccm_get_compare_list()); ?>
                <li>
                    <a href="<?php echo $compare_url; ?>">
                    <span title="<?php echo __('Compare', 'dina-kala'); ?>">
                        <i aria-hidden="true" class="fal fa-random"></i>
                        <i class="compare-amount"><?php echo $compare_count; ?></i>
                    </span>
                    </a>
                </li>
                <?php } ?>
                <li onclick="openCart()">
                    <span class="fshop-icon" title="<?php echo __('Shopping Cart', 'dina-kala'); ?>">
                        <i aria-hidden="true" class="fal fa-shopping-bag"></i>
                        <i class="cart-amount"><?php echo WC()->cart->get_cart_contents_count(); ?></i>
                    </span>
                </li>
            </ul>
        </div>
        <?php } ?>
    
    <header class="site-header" <?php if($di_data['site_schema'] ) {?>itemscope itemtype="https://schema.org/Organization" <?php } ?>>
    <?php if($di_data['site_schema']) { echo '<meta itemprop="url" content="'.esc_url(home_url()).'">'; } ?>
    <?php if($di_data['site_schema']) { echo '<meta itemprop="name" content="'.esc_html(get_bloginfo('name')).'">'; } ?>
    <?php if($di_data['show_msg']) { ?>
    <!-- Header Massage Div -->
    <div class="container-fluid head-msg">
        <div class="container">
            <div class="row">
                <div class="col-12 col-md-10 msg-text">
                    <i aria-hidden="true" class="fal <?php echo $di_data['msg_icon']; ?> msg-icon"></i>
                    <?php echo $di_data['site_msg']; ?>
                </div>
                <?php if($di_data['msg_btn']) { ?>
                <div class="col-12 col-md-2">
                    <a class="btn <?php echo $di_data['msg_btn_color']; ?> msg-btn" href="<?php echo $di_data['msg_btn_link']; ?>" title="<?php echo $di_data['msg_btn_text']; ?>">
                        <?php echo $di_data['msg_btn_text']; ?>
                        <i class="fal fa-arrow-left" aria-hidden="true"></i>
                    </a>
                </div>
                <?php } ?>
            </div>
        </div>
        <?php if($di_data['user_close']) { ?>
        <i class="fal fa-times msg-close" aria-hidden="true"></i>
        <?php } ?>
    </div>
    <!-- Header Massage Div -->
    <?php } ?>

    <!-- Header Div -->
    <div class="container-fluid header">
        <div class="container">
            
            <?php if(!$di_data['hide_top_bar']) { ?>
            <div class="row head-mc<?php if ($di_data['head_pos'] == 2) {echo ' left-head';} ?>">

                <!-- Header Menu -->
                <nav class="col-md-6 head-menu" <?php if($di_data['site_schema']) {?>itemscope itemtype="https://schema.org/SiteNavigationElement" <?php } ?>>
                    <?php
                        wp_nav_menu( array(
                            'menu'              => 'header',
                            'theme_location'    => 'header',
                            'depth'             => 1,
                            'container'         => 'div'
                            )
                        );
                    ?>
                </nav>
                <!-- Header Menu -->
                
                <?php if($di_data['show_contact'] && !$di_data['show_head_social']) { ?>
                <!-- Header Contact -->
                <div class="col-md-6 head-contact">
                    <div class="head-phone" <?php if($di_data['site_schema']) {?>itemprop="telephone"<?php } ?>>
                        <i class="fal fa-phone" aria-hidden="true"></i>
                        <?php echo $di_data['site_tel']; ?>
                    </div>
                    <div class="head-email" <?php if($di_data['site_schema']) {?>itemprop="email"<?php } ?>>
                        <i class="fal fa-envelope" aria-hidden="true"></i>
                        <?php echo $di_data['site_email']; ?>
                    </div>
                </div>
                <!-- Header Contact -->
                <?php } ?>

                <?php if($di_data['show_head_social']) { ?>
                <!-- Header Social -->
                <div class="col-md-6 head-social">
                    <ul>
                        <?php if($di_data['so_twitter']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_twitter_link']; ?>" title="<?php echo __( 'Twitter', 'dina-kala' ); ?>">
                                <i class="fab fa-twitter"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_facebook']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_facebook_link']; ?>" title="<?php echo __( 'Facebook', 'dina-kala' ); ?>">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_google']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_google_link']; ?>" title="<?php echo __( 'Google+', 'dina-kala' ); ?>">
                                <i class="fab fa-google-plus-g"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_whatsapp']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_whatsapp_link']; ?>" title="<?php echo __( 'Whatsapp', 'dina-kala' ); ?>">
                                <i class="fab fa-whatsapp"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_telegram']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_telegram_link']; ?>" title="<?php echo __( 'Telegram', 'dina-kala' ); ?>">
                                <i class="fab fa-telegram-plane"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_instagram']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_instagram_link']; ?>" title="<?php echo __( 'Instagram', 'dina-kala' ); ?>">
                                <i class="fab fa-instagram"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_youtube']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_youtube_link']; ?>" title="<?php echo __( 'Youtube', 'dina-kala' ); ?>">
                                <i class="fab fa-youtube"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_linkedin']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_linkedin_link']; ?>" title="<?php echo __( 'Linkedin', 'dina-kala' ); ?>">
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_dribble']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_dribble_link']; ?>" title="<?php echo __( 'Dribble', 'dina-kala' ); ?>">
                                <i class="fab fa-dribbble"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_pinterest']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_pinterest_link']; ?>" title="<?php echo __( 'Pinterest', 'dina-kala' ); ?>">
                                <i class="fab fa-pinterest-p"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_aparat']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_aparat_link']; ?>" title="<?php echo __('Aparat','dina-kala'); ?>">
                                <i class="ico-aparat"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_cloob']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_cloob_link']; ?>" title="<?php echo __('Aparat','dina-kala'); ?>">
                                <i class="ico-cloob"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_soroush']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_soroush_link']; ?>" title="<?php echo __('Soroush','dina-kala'); ?>">
                                <i class="ico-Soroush"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_gap']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_gap_link']; ?>" title="<?php echo __('Gap','dina-kala'); ?>">
                                <i class="ico-Gap"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_eitaa']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_eitaa_link']; ?>" title="<?php echo __('Eitaa','dina-kala'); ?>">
                                <i class="ico-Eitaa"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_bisphone']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_bisphone_link']; ?>" title="<?php echo __('Bisphone','dina-kala'); ?>">
                                <i class="ico-Bisphone"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_bale']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_bale_link']; ?>" title="<?php echo __('Bale','dina-kala'); ?>">
                                <i class="ico-Bale"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <?php if($di_data['so_igap']) { ?>
                        <li>
                            <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_igap_link']; ?>" title="<?php echo __('iGap','dina-kala'); ?>">
                                <i class="ico-iGap"></i>
                            </a>
                        </li>
                        <?php } ?>
                    </ul>
                </div>
                <!-- Header Social -->
                <?php } ?>

            </div>
            <?php } ?>

            <div class="row logo-box<?php if ($di_data['logo_pos'] == 2) {echo ' left-logo';} ?>">

                    <div class="col-6 mobile-btns d-block d-md-none">
                        <span class="btn btn-light mmenu" onclick="openNav()">
                                <i aria-hidden="true" class="fal fa-bars"></i>
                        </span>
                        <?php if($di_data['show_user_btn']) { ?>
                        <?php if(!is_user_logged_in()) { ?>
                            <a title="<?php echo __('Login', 'dina-kala'); ?>" <?php if($di_data['ch_login_link']) {echo 'href="'.$di_data['login_link'].'"'; } else {echo 'href="#" onclick="openLogin()"';} ?>
                                class="btn btn-light mlogin">
                                <i aria-hidden="true" class="fal fa-user"></i>
                            </a>
                            <a title="<?php echo __('Register', 'dina-kala'); ?>" <?php if($di_data['ch_register_link']) {echo 'href="'.$di_data['register_link'].'"'; } else {echo 'href="' .esc_url(home_url()).'/my-account"';} ?>
                                class="btn btn-light mregister">
                                <i aria-hidden="true" class="fal fa-user-plus"></i>
                            </a>
                        <?php } else { ?>
                            <a title="<?php echo __('User Menu', 'dina-kala'); ?>" class="btn btn-light mlogin" onclick="openUmenu()">
                                <i aria-hidden="true" class="fal fa-user"></i>
                            </a>
                        <?php } } ?>
                    </div>

                    <div class="col-md-3 col-6 logo">
                    <?php if (is_front_page()) {echo '<h1>';} ?>
                    <a href="<?php echo esc_url(home_url()); ?>" title="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" rel="home">
                        <img <?php if($di_data['site_schema']) {?>itemprop="logo" <?php } ?> src="<?php echo $di_data['site_logo']['url']; ?>" srcset="<?php echo $di_data['site_logo_retina']['url']; ?> 2x" alt="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" title="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" class="img-logo"/>
                        <strong><?php bloginfo('name'); ?> | <?php bloginfo('description'); ?> </strong>
                    </a>
                    <?php if (is_front_page()) {echo '</h1>';} ?>
                    </div>
                    <div class="col-md-6 search-con">
                        <form id="head-search" role="search" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                        <input type="hidden" name="post_type" value="product" />
                        <div class="input-group search-form col-md-11">
                            <?php 
                            $categories = get_terms("product_cat");
                            if ( $di_data['search_cat'] && !empty( $categories ) && !is_wp_error( $categories ) ) { ?>
                            <div class="input-group-before prod-cat">
                                <?php echo '<select name="product_cat" >';
                                echo '<option value="">'.__("Category",'dina-kala').'</option>';
                                foreach ( $categories as $category ) {
                                echo '<option value="'.$category->slug.'">'.$category->name.'</option>';
                                }
                                echo '</select>'; ?>
                            </div>
                            <?php } ?>
                            <input autocomplete="off" <?php if($di_data['ajax_search']) { echo ' data-swplive="true"' ; } ?> name="s" type="text" class="form-control search-input" placeholder="<?php echo __('Search Products...', 'dina-kala'); ?>" required>
                            <div class="input-group-append">
                                <button class="btn btn-search" type="submit" aria-label="<?php echo __("Search", 'dina-kala'); ?>">
                                    <i class="fal fa-search" aria-hidden="true"></i>
                                </button>
                            </div>
                        </div>
                        </form>
                    </div>

                    <?php if($di_data['show_user_btn']) { ?>
                        <?php if(!is_user_logged_in()) { ?>
                        <div class="col-md-3 user-btn d-none d-md-block">
                            <?php if (function_exists('digits_version') && $di_data['digits_mode']) { ?>
                                <?php if($di_data['digits_page']) {$digits_mode = 'digitlink';} else {$digits_mode = 'digitpopup';} ?>
                                <?php if($di_data['user_btn_style']) { ?>
                                    <span title="<?php echo __('Login Or Register', 'dina-kala'); ?>" class="register-link digitsbtn <?php echo $digits_mode; ?>">
                                        <i aria-hidden="true" class="fal fa-user"></i>
                                        <span class="hidden-ta"><?php echo __('Login', 'dina-kala'); ?></span>
                                        /
                                        <i aria-hidden="true" class="fal fa-user-plus"></i>
                                        <span class="hidden-ta"><?php echo __('Register', 'dina-kala'); ?></span>
                                    </span>
                                <?php } else { ?>
                                    <span title="<?php echo __('Login Or Register', 'dina-kala'); ?>" class="btn btn-success btn-register digitsbtn <?php echo $digits_mode; ?>">
                                        <i aria-hidden="true" class="fal fa-user"></i>
                                        <span class="hidden-ta"><?php echo __('Login', 'dina-kala'); ?></span>
                                        /
                                        <i aria-hidden="true" class="fal fa-user-plus"></i>
                                        <span class="hidden-ta"><?php echo __('Register', 'dina-kala'); ?></span>
                                    </span>
                                <?php } ?>
                            <?php } else { ?>
                                <?php if($di_data['user_btn_style']) { ?>
                                    <a title="<?php echo __('Login', 'dina-kala'); ?>" <?php if($di_data['ch_login_link']) {echo 'href="'.$di_data['login_link'].'"'; } else {echo 'href="#" onclick="openLogin()"';} ?>
                                        class="login-link">
                                        <i aria-hidden="true" class="fal fa-user"></i>
                                        <span class="hidden-ta"><?php echo __('Login', 'dina-kala'); ?></span>
                                    </a>
                                    /
                                    <a title="<?php echo __('Register', 'dina-kala'); ?>" <?php if($di_data['ch_register_link']) {echo 'href="'.$di_data['register_link'].'"'; } else {echo 'href="' .esc_url(home_url()).'/my-account"';} ?>
                                        class="register-link">
                                        <i aria-hidden="true" class="fal fa-user-plus"></i>
                                        <span class="hidden-ta"><?php echo __('Register', 'dina-kala'); ?></span>
                                    </a>
                                <?php } else { ?>
                                    <a title="<?php echo __('Login', 'dina-kala'); ?>" <?php if($di_data['ch_login_link']) {echo 'href="'.$di_data['login_link'].'"'; } else {echo 'href="#" onclick="openLogin()"';} ?>
                                        class="btn btn-outline-success btn-login">
                                        <i aria-hidden="true" class="fal fa-user"></i>
                                        <span class="hidden-ta"><?php echo __('Login', 'dina-kala'); ?></span>
                                    </a>
                                    <a title="<?php echo __('Register', 'dina-kala'); ?>" <?php if($di_data['ch_register_link']) {echo 'href="'.$di_data['register_link'].'"'; } else {echo 'href="' .esc_url(home_url()).'/my-account"';} ?>
                                        class="btn btn-success btn-register">
                                        <i aria-hidden="true" class="fal fa-user-plus"></i>
                                        <span class="hidden-ta"><?php echo __('Register', 'dina-kala'); ?></span>
                                    </a>
                                <?php } ?>
                            <?php } ?>
                        </div>
                        <?php } else {
                        $user = wp_get_current_user(); ?>
                        <div class="col-md-3 drop-con d-none d-md-block">
                        <div class="dropdown user-drop">
                            <button class="dropdown-toggle user-menu" type="button" data-toggle="dropdown">
                            <?php echo get_avatar(get_current_user_id() , 32,'',$user->display_name ); ?>
                            <span class="user-name"><?php echo $user->display_name; ?>
                            <?php if (class_exists( 'WooWallet' ))
                            {       
                            echo '<span class="wallet hidden-ta">';
                            $wallet = woo_wallet()->wallet->get_wallet_balance( get_current_user_id() );
                                    echo ' | '. $wallet;
                            echo '</span>';
                            } ?></span>
                            <span class="fal fa-chevron-down" aria-hidden="true"></span>
                            </button>
                            <ul class="dropdown-menu user-menu mu-menu col-12">
                                <?php get_template_part('includes/umenu'); ?>
                            </ul>
                        </div>
                        </div>
                    <?php }} ?>
            </div>
        </div>
    </div>
    <!-- Header Div -->

    <!-- Navbar -->
    <nav class="navbar navbar-expand-sm<?php if ($di_data['fixed_head_top']) {echo ' fixed-nav';} ?><?php if ($di_data['focus_nav']) {echo ' focus-nav';} ?>" <?php if($di_data['site_schema']) {?>itemscope itemtype="https://schema.org/SiteNavigationElement"<?php } ?>>
    <div class="container">
        <!-- Collect the nav links from WordPress -->
        <div class="collapse navbar-collapse" id="bootstrap-nav-collapse">         
            <?php 
            $args = array(
                'theme_location' => 'mega_menu',
                'depth'             => 4,
                'container'         => 'div',
                'menu_class'        => 'nav navbar-nav yamm',
                'fallback_cb'       => 'Yamm_Nav_Walker_menu_fallback',
                'walker'            => new Yamm_Nav_Walker()
                );
            wp_nav_menu($args);
        ?>
        </div><!-- ./collapse -->

        <?php if($di_data['show_wish_list'] && class_exists( 'JVM_WooCommerce_Wishlist' )) { ?>
        <div class="btn-wish">
            <a href="<?php echo jvm_get_wishlist_url(); ?>" class="wish-icon" data-toggle="tooltip" data-placement="top" title="<?php echo __('Wishlist', 'dina-kala'); ?>">
            <i aria-hidden="true" class="fal fa-heart"></i>
            </a>
        </div>
        <?php } ?>

        <?php 
        if ( defined( 'WCCM_VERISON' ) && $di_data['show_compare_btn'] ) {
        $compare_url = wccm_get_compare_page_link( wccm_get_compare_list() );
        $compare_count = count(wccm_get_compare_list()); ?>
        <div class="btn-compare">
            <a href="<?php echo $compare_url; ?>" class="compare-icon" data-toggle="tooltip" data-placement="top" title="<?php echo __('Compare Products', 'dina-kala'); ?>">
            <i aria-hidden="true" class="fal fa-random"></i>
            <i class="compare-amount"><?php echo $compare_count; ?></i>
            </a>
        </div>
        <?php } ?>

        <?php if($di_data['show_cart_btn']) { ?>
        <div class="btn-cart">
            <span class="shop-icon" data-toggle="tooltip" data-placement="top" title="<?php echo __('Shopping cart', 'dina-kala'); ?>" onclick="openCart()">
            <i aria-hidden="true" class="fal fa-shopping-bag"></i>
            <i class="cart-amount"><?php echo WC()->cart->get_cart_contents_count(); ?></i>
            </span>
        </div>
        <?php } ?>

    </div><!-- /.container -->
    </nav>
    <!-- Navbar -->
		<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-151802148-1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-151802148-1');
</script>

    </header>