<?php 

/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Demo Website: Dina.Elmfile.ir
Author Website: Hosseinkhani.ir
*/

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

//Theme's Languages
function dina_localisation(){
    function dina_localised( $locale ) {
        if ( isset( $_GET['l'] ) ) {
            return sanitize_key( $_GET['l'] );
        }
        return $locale;
    }
    add_filter( 'locale', 'dina_localised' );
    load_theme_textdomain( 'dina-kala', get_template_directory() . '/languages' );
}
add_action( 'after_setup_theme', 'dina_localisation' );

//Theme's constants
define ('DI_URI' , get_template_directory_uri());
define ('DI_DIR' , get_template_directory());


//Incluse Theme Files
if ( !class_exists( 'ReduxFramework' ) && file_exists( dirname( __FILE__ ) . '/includes/ReduxCore/framework.php' ) ) {
    require_once( dirname( __FILE__ ) . '/includes/ReduxCore/framework.php' );
}
if ( !isset( $redux_demo ) && file_exists( dirname( __FILE__ ) . '/includes/admin-panel-config.php' ) ) {
    require_once( dirname( __FILE__ ) . '/includes/admin-panel-config.php' );
}

Redux::init('di_data');

require_once DI_DIR . '/plugins/plugin.php';
require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
require_once DI_DIR . '/includes/meta-box.php';
require_once DI_DIR . '/includes/ajax-login.php';
require_once DI_DIR . '/includes/recaptchalib.php';
require_once DI_DIR . '/includes/simple-link-list-widget/simple-link-list-widget.php';
require_once DI_DIR . '/includes/dynamic_style.php';
require_once DI_DIR . '/includes/d-sidebar.php';
require_once DI_DIR . '/includes/yamm-nav-walker.php';
require_once DI_DIR . '/includes/img-fix.php';
require_once DI_DIR . '/includes/image-banner.php';
require_once DI_DIR . '/includes/logo-namad.php';
require_once DI_DIR . '/includes/epay.php';
require_once DI_DIR . '/includes/products.php';
require_once DI_DIR . '/includes/posts.php';
require_once DI_DIR . '/includes/fnews.php';
require_once DI_DIR . '/includes/thumbnail-upscale.php';
require_once DI_DIR . '/includes/woo.php';
require_once DI_DIR . '/includes/edit_custom_walker.php';
require_once DI_DIR . '/includes/menu-icon.php';
require_once DI_DIR . '/includes/mmenu_walker.php';
require_once DI_DIR . '/includes/views.php';
//Register Elementor Widgets
if ( did_action( 'elementor/loaded' ) ) {
    require_once DI_DIR . '/includes/elementor.php';
}
if($di_data['ajax_search']) {
require_once DI_DIR . '/includes/searchwp-live-ajax-search/searchwp-live-ajax-search.php';
}
if($di_data['ajax_add']) {
require_once DI_DIR . '/includes/ajax-add.php';
}

//Register Theme's styles
add_action('wp_enqueue_scripts','dina_styles');
function dina_styles() {
    wp_register_style('dina-boot-rtl', DI_URI . '/css/bootstrap-rtl.min.css');
    wp_enqueue_style('dina-boot-rtl');
    wp_register_style('dina-awe', DI_URI . '/css/fontawesome.min.css');
    wp_enqueue_style('dina-awe');
    wp_register_style('dina-style', DI_URI . '/style.css', array() ,'1.0');
    wp_enqueue_style('dina-style');
    if( class_exists( 'WeDevs_Dokan' ) ) {
        wp_register_style('dina-dokan', DI_URI . '/css/dokan.css');
        wp_enqueue_style('dina-dokan');
    }
}

//Register Elementor Panel styles
add_action('elementor/editor/before_enqueue_scripts', function() {
    wp_register_style('el-style', DI_URI . '/css/elementor.css', array() ,'1.0');
    wp_enqueue_style('el-style');
    wp_register_style('dina-awe', DI_URI . '/css/fontawesome.min.css');
    wp_enqueue_style('dina-awe');
});

//Register Theme's Scripts
add_action('init', 'dina_scripts');
function dina_scripts() {
if (is_admin()) return;
    wp_enqueue_script('dina-js-boot', DI_URI . '/js/bootstrap.min.js', array('jquery'), '1.0');
    wp_enqueue_script('dina-js-main', DI_URI . '/js/main.js', array('jquery'), '1.0');
}

//Add Admin Scripts
add_action('admin_enqueue_scripts', 'dina_upload_script');
function dina_upload_script() {
    wp_enqueue_media();
    wp_enqueue_script('ads_script', DI_URI . '/js/upload-media.js', false, '1.0', true);
}

// Add Theme Support
add_action('after_setup_theme','dina_support');
function dina_support() {
    add_theme_support('title-tag');
    add_theme_support('html5');
    add_theme_support('post-thumbnails');
    add_theme_support('automatic-feed-links');
    add_theme_support( 'woocommerce' );
    add_theme_support( 'wc-product-gallery-zoom' );
    add_theme_support( 'wc-product-gallery-lightbox' );
    add_theme_support( 'wc-product-gallery-slider' );
}

//Rregister navigation menu
register_nav_menus( array(
    'mega_menu'   => __( 'Mega Menu', 'dina-kala' ),
    'header' => __( 'Header Menu', 'dina-kala' ),
));

//Redux Menu
add_action( 'admin_menu', 'remove_redux_menu',12 );
function remove_redux_menu() {
    remove_submenu_page('tools.php','redux-about');
}

//Redux Styles
add_action( 'admin_enqueue_scripts', 'redux_custom_styles' );
function redux_custom_styles($page)
{
    wp_enqueue_style('redux-custom-style', DI_URI .'/includes/redux.css');
}

//Fontawesomw admin icons
add_action('admin_init', 'fa_dashboard');
function fa_dashboard()
{
    wp_enqueue_style('fa_di_admin', DI_URI . '/css/fontawesome.min.css');
}

//Widget tag's number
add_filter( 'widget_tag_cloud_args', 'dina_tag_cloud_limit' );
function dina_tag_cloud_limit($args){ 
    global $di_data;
    // Check if taxonomy option of the widget is set to tags
    if ( isset($args['taxonomy']) ) {
        $args['number'] = $di_data['tag_number']; // Number of tags to show
        }
    return $args;
}

//Loads admin-side menu-icon scripts and styles
add_action('admin_enqueue_scripts', 'admin_menu_icon_styles');
function admin_menu_icon_styles($page)
{
if ($page == 'nav-menus.php')
    {
    wp_enqueue_style('select2', DI_URI . '/includes/select2.min.css');
    wp_enqueue_style('menu-icon-admin-style', DI_URI . '/includes/menu-icon-admin.css');
    wp_enqueue_script('my_s2', DI_URI . '/includes/select2.min.js');
    wp_enqueue_script('my_s1', DI_URI . '/includes/select2.js');
    }
}

//Pagination
function wp_pagination()
{
global $wp_query;
$big = 999999999;
$page_format = paginate_links(array(
    'base' => str_replace($big, '%#%', esc_url(get_pagenum_link($big))) ,
    'format' => '?paged=%#%',
    'current' => max(1, get_query_var('paged')) ,
    'total' => $wp_query->max_num_pages,
    'prev_text' => __('<i class="fal fa-chevron-right" aria-hidden="true" title="Next"></i>') ,
    'next_text' => __('<i class="fal fa-chevron-left" aria-hidden="true" title="Prev"></i>') ,
    'type' => 
    'array'
));
if (is_array($page_format))
    {
    $paged = (get_query_var('paged') == 0) ? 1 : get_query_var('paged');
    echo '<div class="col-12 pagination"><ul>';
    foreach($page_format as $page)
        {
        echo "<li>$page</li>";
        }
    echo '</ul></div>';
    }
}

function p_img() { 
   if ( has_post_thumbnail()) {
             the_post_thumbnail('woocommerce_thumbnail'); 
    } else { 
    echo '<img src="'.esc_url( get_template_directory_uri() ).'/images/tumb.png" alt="'.the_title_attribute('echo=0').'" class="post-tumb"/>';
    }
}

function remove_admin_bar() {
    global $di_data;
if (current_user_can('administrator') && $di_data['show_abar_admin']) {
  add_filter('show_admin_bar', '__return_true');
}
    else{
    add_filter('show_admin_bar', '__return_false');
    }
}
if ($di_data['show_abar'])
	{ 
	add_action('after_setup_theme', 'remove_admin_bar');
}

/**
* Updating the subscriber role
*/
$subscriber_role = get_role( 'subscriber' );
if($subscriber_role){
// Adding a new capability to role
$subscriber_role->add_cap( 'view_ticket' );
$subscriber_role->add_cap( 'create_ticket' );
$subscriber_role->add_cap( 'close_ticket' );
$subscriber_role->add_cap( 'reply_ticket' );
$subscriber_role->add_cap( 'attach_files' );
}

$customer_role = get_role( 'customer' );
if($customer_role){
// Adding a new capability to role
$customer_role->add_cap( 'view_ticket' );
$customer_role->add_cap( 'create_ticket' );
$customer_role->add_cap( 'close_ticket' );
$customer_role->add_cap( 'reply_ticket' );
$customer_role->add_cap( 'attach_files' );
}

$seller_role = get_role( 'seller' );
if($seller_role){
// Adding a new capability to role
$seller_role->add_cap( 'view_ticket' );
$seller_role->add_cap( 'create_ticket' );
$seller_role->add_cap( 'close_ticket' );
$seller_role->add_cap( 'reply_ticket' );
$seller_role->add_cap( 'attach_files' );
}

if( class_exists( 'Awesome_Support' ) ) { 
add_filter( 'page_template', 'ticket_page_template' );
function ticket_page_template( $page_template ) {
        global $post;
        $ticket_id = wpas_get_option( 'ticket_list' );
        $ticket_submit_id = wpas_get_option( 'ticket_submit' );
        if(is_array($ticket_submit_id)){
            $ticket_submit = $ticket_submit_id[0];
        }
        else{
            $ticket_submit = $ticket_submit_id;
        }
        $post_id = $post->ID;
        if( ($post_id === (int)$ticket_id) || ($post_id === (int)$ticket_submit) ) {
                $page_template = get_stylesheet_directory() . '/tickets.php'; 
        } 
    return $page_template;
}
}

if( class_exists( 'Affiliate_WP' ) ) { 
add_filter( 'page_template', 'affiliate_page_template' );
function affiliate_page_template( $page_template ) {
        global $post;
        $post_id = $post->ID;
        if($post_id === affwp_get_affiliate_area_page_id() ) {
                $page_template = get_stylesheet_directory() . '/affiliate-area.php'; 
        } 
    return $page_template;
}
}

add_filter( 'comment_form_fields', 'wpb_move_comment_field_to_bottom');
function wpb_move_comment_field_to_bottom( $fields ) {
$comment_field = $fields['comment'];
unset( $fields['comment'] );
$fields['comment'] = $comment_field;
return $fields;
}

function get_post_primary_category($post_id, $term='category', $return_all_categories=false){
    $return = array();

    if (class_exists('WPSEO_Primary_Term')){
        // Show Primary category by Yoast if it is enabled & set
        $wpseo_primary_term = new WPSEO_Primary_Term( $term, $post_id );
        $primary_term = get_term($wpseo_primary_term->get_primary_term());

        if (!is_wp_error($primary_term)){
            $return['primary_category'] = $primary_term;
        }
    }

    if (empty($return['primary_category']) || $return_all_categories){
        $categories_list = get_the_terms($post_id, $term);

        if (empty($return['primary_category']) && !empty($categories_list)){
            $return['primary_category'] = $categories_list[0];  //get the first category
        }
        if ($return_all_categories){
            $return['all_categories'] = array();

            if (!empty($categories_list)){
                foreach($categories_list as &$category){
                    $return['all_categories'][] = $category->term_id;
                }
            }
        }
    }

    return $return;
}

function get_jdate_publish_time(){
	$greg_date = get_post_time('j F Y');
	$timestamp = strtotime($greg_date);
	if ( function_exists('jdate') ) {
		echo jdate('j F Y',$timestamp);
	} else {
		echo $greg_date;
	}
}

//حذف گزینه “سفارش به آدرس دیگری ارسال شود؟”
add_filter( 'woocommerce_cart_needs_shipping_address', '__return_false' );