<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: Hosseinkhani.ir
*/
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
global $di_data;
?>

<!-- Footer Area -->
<?php if ( $di_data['show_info_bar'] || $di_data['show_addr'] || is_active_sidebar( 'footer-1' ) || is_active_sidebar( 'footer-2' ) || is_active_sidebar( 'footer-3' ) || is_active_sidebar( 'footer-4' ) ) : ?>
<div class="container-fluid sfooter">
    <div class="container">
            <?php
            if ($di_data['show_info_bar']) { ?>
                <div class="row info-bar">
                    <?php if ($di_data['info_bar_prods']) { ?>
                    <div class="prod-count col">
                        <?php $count_prods = wp_count_posts('product'); $published_prods = $count_prods->publish; ?>
                        <i class="fal fa-shopping-bag" aria-hidden="true"></i>
                        <span class="count-num">
                            <?php echo $published_prods; ?>+</span>
                        <span class="count-text"><?php _e('Products','dina-kala') ?></span>
                    </div>
                    <?php } ?>
                    <?php if ($di_data['info_bar_sales']) { ?>
                    <div class="prod-count col">
                        <i class="fal fa-box-check" aria-hidden="true"></i>
                        <span class="count-num">
                        <?php echo di_woo_get_total_sales(); ?>+</span>
                        <span class="count-text"><?php _e('Order completed','dina-kala') ?></span>
                    </div>
                    <?php } ?>
                    <?php if ($di_data['info_bar_users']) { ?>
                    <div class="prod-count col">
                        <?php $usercount = count_users(); $result = $usercount['total_users']; ?>
                        <i class="fal fa-users" aria-hidden="true"></i>
                        <span class="count-num">
                            <?php echo $result; ?>+</span>
                        <span class="count-text"><?php _e('Members','dina-kala') ?></span>
                    </div>
                    <?php } ?>
                    <?php if ($di_data['info_bar_posts']) { ?>
                    <div class="prod-count col">
                        <?php $count_posts = wp_count_posts('post'); $published_posts = $count_posts->publish; ?>
                        <i class="fal fa-file-alt" aria-hidden="true"></i>
                        <span class="count-num">
                            <?php echo $published_posts; ?>+</span>
                        <span class="count-text"><?php _e('Blog content','dina-kala') ?></span>
                    </div>
                    <?php } ?>
                </div>
        <?php } ?>

        <div class="row fwidgets">
            <?php
            $footer_widgets = (int)$di_data['footer_widgets'];
            $col = ($footer_widgets > 3 ? 3 : 4);
            for ($x = 1; $x <= $footer_widgets; $x++) { ?>
            <div class="col-lg-<?php echo $col; ?> col-md-6 col-12 fwidget">
            <?php if ( is_active_sidebar( 'footer-'.$x ) ) :
                dynamic_sidebar('footer-'.$x);
            endif; ?>
            </div>
            <?php } ?>
        </div>

        <?php if($di_data['show_addr']) { ?>
        <div class="row footer-addr">
            <div class="col-md-9 col-12 addr-con">
                <?php if(($di_data['addr_text']!='') && ($di_data['show_faddr'])) { ?>
                <div class="addr-text col-md-7 col-12"><i class="fal fa-map-marker-alt" aria-hidden="true"></i>
                    <?php echo $di_data['addr_text']; ?>
                </div>
                <?php } ?>
                <div class="ftel col-md-5 col-12">
                    <?php if(($di_data['site_tel']!='') && ($di_data['show_ftel'])) { ?>
                    <span>
                        <i class="fal fa-phone" aria-hidden="true"></i>
                        <span class="top-val" id="site-tel"><?php  echo $di_data['site_tel']; ?></span>
                    </span>
                    <?php } ?>
                    <?php if(($di_data['site_email']!='') && ($di_data['show_fmail'])) { ?>
                    <span class="foot-tel">
                        <i class="fal fa-envelope" aria-hidden="true"></i>
                        <span class="top-val" id="site-email"><?php echo $di_data['site_email']; ?></span>
                    </span>
                    <?php } ?>
                </div>
            </div>
            <?php if($di_data['show_apps']) { ?>
            <div class="col-md-3 col-12 apps-icon">
                <?php if($di_data['and_link'] != '') { ?>
                <a href="<?php echo $di_data['and_link']; ?>" rel="nofollow" class="btn btn-outline-success and-btn"><i class="fab fa-android" aria-hidden="true"></i><?php _e(' Android' , 'dina-kala'); ?></a>
                <?php } ?>
                <?php if($di_data['ios_link'] != '') { ?>
                <a href="<?php echo $di_data['ios_link']; ?>" rel="nofollow" class="btn btn-outline-secondary ios-btn"><i class="fab fa-apple" aria-hidden="true"></i> <?php _e(' IOS' , 'dina-kala'); ?></a>
                <?php } ?>
            </div>
            <?php } ?>
        </div>
        <?php } ?>

        <?php if($di_data['show_footer_text']) { ?>
        <div class="row footer-section-text">
            <?php if($di_data['ftext_title'] != '') { ?>
            <div class="col-12 footer-text-title">
                <h3><?php echo $di_data['ftext_title']; ?></h3>
            </div>
            <?php } ?>
            <?php if($di_data['ftext_text'] != '') { ?>
            <div class="col-12 footer-text">
                <?php echo $di_data['ftext_text']; ?>
            </div>
            <?php } ?>
        </div>
        <?php } ?>

    </div>
</div>
<?php endif; ?>
<!-- Footer Area -->

<!-- Copyright area -->
<div class="container-fluid copyright<?php if($di_data['hide_mobile_bar']) { echo ' no-bbar'; } ?>">
    <div class="container">
        <div class="row">
        <div class="col-md-6 col-12 float-right copy-text">
            <?php echo $di_data['copy_text']; ?>
        </div>
        <div class="col-md-6 col-12 float-left social-footer">
            <ul>
                <?php if($di_data['so_twitter']) { ?>
                <li>
                    <a href="<?php echo $di_data['so_twitter_link']; ?>" title="<?php _e( 'Twitter', 'dina-kala' ); ?>">
                        <i class="fab fa-twitter"></i>
                    </a>
                </li>
                <?php } ?>
                <?php if($di_data['so_facebook']) { ?>
                <li>
                    <a href="<?php echo $di_data['so_facebook_link']; ?>" title="<?php _e( 'Facebook', 'dina-kala' ); ?>">
                        <i class="fab fa-facebook-f"></i>
                    </a>
                </li>
                <?php } ?>
                <?php if($di_data['so_google']) { ?>
                <li>
                    <a href="<?php echo $di_data['so_google_link']; ?>" title="<?php _e( 'Google+', 'dina-kala' ); ?>">
                        <i class="fab fa-google-plus-g"></i>
                    </a>
                </li>
                <?php } ?>
                <?php if($di_data['so_whatsapp']) { ?>
                <li>
                    <a href="<?php echo $di_data['so_whatsapp_link']; ?>" title="<?php _e( 'Whatsapp', 'dina-kala' ); ?>">
                        <i class="fab fa-whatsapp"></i>
                    </a>
                </li>
                <?php } ?>
                <?php if($di_data['so_telegram']) { ?>
                <li>
                    <a href="<?php echo $di_data['so_telegram_link']; ?>" title="<?php _e( 'Telegram', 'dina-kala' ); ?>">
                        <i class="fab fa-telegram-plane"></i>
                    </a>
                </li>
                <?php } ?>
                <?php if($di_data['so_instagram']) { ?>
                <li>
                    <a href="<?php echo $di_data['so_instagram_link']; ?>" title="<?php _e( 'Instagram', 'dina-kala' ); ?>">
                        <i class="fab fa-instagram"></i>
                    </a>
                </li>
                <?php } ?>
                <?php if($di_data['so_youtube']) { ?>
                <li>
                    <a href="<?php echo $di_data['so_youtube_link']; ?>" title="<?php _e( 'Youtube', 'dina-kala' ); ?>">
                        <i class="fab fa-youtube"></i>
                    </a>
                </li>
                <?php } ?>
                <?php if($di_data['so_linkedin']) { ?>
                <li>
                    <a href="<?php echo $di_data['so_linkedin_link']; ?>" title="<?php _e( 'Linkedin', 'dina-kala' ); ?>">
                        <i class="fab fa-linkedin-in"></i>
                    </a>
                </li>
                <?php } ?>
                <?php if($di_data['so_dribble']) { ?>
                <li>
                    <a href="<?php echo $di_data['so_dribble_link']; ?>" title="<?php _e( 'Dribble', 'dina-kala' ); ?>">
                        <i class="fab fa-dribbble"></i>
                    </a>
                </li>
                <?php } ?>
                <?php if($di_data['so_pinterest']) { ?>
                <li>
                    <a href="<?php echo $di_data['so_pinterest_link']; ?>" title="<?php _e( 'Pinterest', 'dina-kala' ); ?>">
                        <i class="fab fa-pinterest-p"></i>
                    </a>
                </li>
                <?php } ?>
                <?php if($di_data['so_aparat']) { ?>
                <li>
                    <a href="<?php echo $di_data['so_aparat_link']; ?>" title="<?php _e('Aparat','dina-kala'); ?>">
                        <i class="ico-aparat"></i>
                    </a>
                </li>
                <?php } ?>
                <?php if($di_data['so_cloob']) { ?>
                <li>
                    <a href="<?php echo $di_data['so_cloob_link']; ?>" title="<?php _e('Cloob','dina-kala'); ?>">
                        <i class="ico-cloob"></i>
                    </a>
                </li>
                <?php } ?>
                <?php if($di_data['so_soroush']) { ?>
                <li>
                    <a href="<?php echo $di_data['so_soroush_link']; ?>" title="<?php _e('Soroush','dina-kala'); ?>">
                        <i class="ico-Soroush"></i>
                    </a>
                </li>
                <?php } ?>
                <?php if($di_data['so_gap']) { ?>
                <li>
                    <a href="<?php echo $di_data['so_gap_link']; ?>" title="<?php _e('Gap','dina-kala'); ?>">
                        <i class="ico-Gap"></i>
                    </a>
                </li>
                <?php } ?>
                <?php if($di_data['so_eitaa']) { ?>
                <li>
                    <a href="<?php echo $di_data['so_eitaa_link']; ?>" title="<?php _e('Eitaa','dina-kala'); ?>">
                        <i class="ico-Eitaa"></i>
                    </a>
                </li>
                <?php } ?>
                <?php if($di_data['so_bisphone']) { ?>
                <li>
                    <a href="<?php echo $di_data['so_bisphone_link']; ?>" title="<?php _e('Bisphone','dina-kala'); ?>">
                        <i class="ico-Bisphone"></i>
                    </a>
                </li>
                <?php } ?>
                <?php if($di_data['so_bale']) { ?>
                <li>
                    <a href="<?php echo $di_data['so_bale_link']; ?>" title="<?php _e('Bale','dina-kala'); ?>">
                        <i class="ico-Bale"></i>
                    </a>
                </li>
                <?php } ?>
                <?php if($di_data['so_igap']) { ?>
                <li>
                    <a href="<?php echo $di_data['so_igap_link']; ?>" title="<?php _e('iGap','dina-kala'); ?>">
                        <i class="ico-iGap"></i>
                    </a>
                </li>
                <?php } ?>
            </ul>
        </div>
        </div>
    </div>
</div>
<!-- Copyright area -->
<div class="overlay-blur"></div>

    <?php if($di_data['show_return_top']) { ?>
    <div id="back-top" style="display: block;">
        <a href="#top"><span class="fal fa-chevron-up" aria-hidden="true"></span></a>
    </div>
    <?php } ?>
    
    <?php if($di_data['show_cart_btn']) { ?>
    <!-- side cart -->
    <div id="mySideCart" class="sidecart">
        <div class="side-head">
        <a href="javascript:void(0)" class="mclosebtn" onclick="closeCart()">
            <i class="fal fa-times" aria-hidden="true"></i>
        </a>
        <div class="side-title">
             <i class="fal fa-shopping-bag" aria-hidden="true"></i> <?php echo __( 'Shopping Cart', 'dina-kala' ); ?>
        </div>
        </div>
        <div class="widget_shopping_cart_content">
            <?php woocommerce_mini_cart() ?>
        </div>
        <i class="fal fa-bags-shopping side-icon" aria-hidden="true"></i>
    </div>
    <div id="myCanvasCart" class="overlay3" onclick="closeCart()"></div>
    <!-- side cart -->
    <?php } ?>

    <?php if($di_data['ch_login_link'] || !is_user_logged_in()) { ?>
    <!-- side login -->
    <div id="mySideLogin" class="sidelogin">
        <div class="side-head">
            <a href="javascript:void(0)" class="mclosebtn" onclick="closeLogin()">
                <i class="fal fa-times" aria-hidden="true"></i>
            </a>
            <div class="side-title">
                <i class="fal fa-user-circle" aria-hidden="true"></i> <?php echo __( 'Login to the site', 'dina-kala' ); ?>
            </div>
        </div>
        <?php if (function_exists('digits_version') && $di_data['digits_mode']) { $digits_class = ' digits-login'; } ?>
        <form name="login_form" class="login_form <?php echo $digits_class; ?>" id="login_form" action="#" method="post">
            <div class="row">
                <div class="col-12">
                <div class="status"></div>
                <div class="form-group">
                    <div class="input-group">
                    <div class="input-group-prepend" id="basic-addon1">
                        <span class="input-group-text">
                        <i class="fal fa-user" aria-hidden="true"></i>
                        </span>
                    </div>
                    <input name="username" type="text" class="form-control" id="username" placeholder="<?php echo __('Username','dina-kala'); ?>" required="required" />
                    </div>
                </div>
                <div class="form-group">
                    <div class="input-group">
                    <div class="input-group-prepend" id="basic-addon2">
                        <span class="input-group-text">
                        <i class="fal fa-key" aria-hidden="true"></i>
                        </span>
                    </div>
                    <input name="password" type="password" class="form-control" id="password" placeholder="<?php echo __('Password','dina-kala'); ?>" required="required" />
                    </div>
                </div>
                <a href="<?php echo wp_lostpassword_url(); ?>" title="<?php echo __('Reset password','dina-kala'); ?>" class="lost-password"><?php echo __('Reset password','dina-kala'); ?></a>
                <a <?php if($di_data['ch_register_link']) {echo 'href="'.$di_data['register_link'].'"'; } else {echo 'href="' .esc_url(home_url()).'/my-account"';} ?> class="pregisterlink"><?php echo __('Create an account', 'dina-kala'); ?></a>
                <?php if($di_data['recapcha_login']) { ?>
                <div class="g-recaptcha" data-sitekey="<?php echo $di_data['site_key']; ?>"></div>
                <?php } ?>
                <?php wp_nonce_field( 'ajax-login-nonce', 'security' ); ?>
                <button class="btn btn-success plogin-btn" id="loginSubmit">
                    <span class="fal fa-user" aria-hidden="true"></span><?php echo __('  Login to the site','dina-kala'); ?>
                </button>
                </div>
            </div>
        </form>
        <i class="fal fa-user-circle side-icon" aria-hidden="true"></i>
    </div>
    <div id="myCanvasLogin" class="overlay3" onclick="closeLogin()"></div>
    <!-- side login -->
    <?php } ?>

    <?php if (is_user_logged_in()) { ?>
    <!-- side user-menu -->
    <div id="myUmenu" class="usermenu">
        <div class="side-head">
            <a href="javascript:void(0)" class="closebtn" onclick="closeUmenu()">
                <i class="fal fa-times" aria-hidden="true"></i>
            </a>
            <?php 
                $user = wp_get_current_user(); 
                echo get_avatar(get_current_user_id() , 65,'' ,$user->display_name ); ?>
            <span class="side-uname">
                <?php echo $user->display_name; ?>
            </span>
            <?php
            if (class_exists( 'WooWallet' ))
            {       
                $wallet = woo_wallet()->wallet->get_wallet_balance( get_current_user_id() );
                echo '<span class="m-wallet">'.__('Wallet Inventory: ','dina-kala').$wallet.'</span>';
            }
            ?>
        </div>
        <ul class="usmenu">
        <?php get_template_part('includes/umenu'); ?>
        </ul>
        <i class="fal fa-id-card side-icon" aria-hidden="true"></i>
    </div>
    <div id="myCanvasUser" class="overlay3" onclick="closeUmenu()"></div>
    <!-- side user-menu -->
    <?php } ?>

    <!-- mobile menu -->
    <div id="myNav" class="sidenav">
        <div class="side-head">
            <a href="javascript:void(0)" class="mclosebtn" onclick="closeNav()">
                <i class="fal fa-times" aria-hidden="true"></i>
            </a>
            <form class="msform" role="search" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                <input type="hidden" name="post_type" value="product" />
                <div class="input-group search-form">
                    <?php 
                    $categories = get_terms("product_cat");
                    if ( $di_data['search_cat'] && !empty( $categories ) && !is_wp_error( $categories ) ) { ?>
                    <div class="input-group-before prod-cat">
                        <?php echo '<select name="product_cat" >';
                        echo '<option value="">'.__("Category",'dina-kala').'</option>';
                        foreach ( $categories as $category ) {
                        echo '<option value="'.$category->slug.'">'.$category->name.'</option>';
                        }
                        echo '</select>'; ?>
                    </div>
                    <?php } ?>
                    <input autocomplete="off" name="s" type="text" class="form-control search-input" placeholder="<?php echo __("Search", 'dina-kala'); ?>" required>
                    <div class="input-group-append">
                        <button class="btn btn-search" type="submit" aria-label="<?php echo __("Search", 'dina-kala'); ?>">
                            <i class="fal fa-search" aria-hidden="true"></i>
                        </button>
                    </div>
                </div>
            </form>
        </div>
        <nav <?php if($di_data['site_schema']) {?>itemscope itemtype="https://schema.org/SiteNavigationElement"<?php } ?> id="cssmenu">
            <?php
            wp_nav_menu(array(
            'menu'              => 'mega_menu',
            'theme_location'    => 'mega_menu',
            'container_id' => 'cssmenu',
            'fallback_cb'       => 'CSS_Menu_Maker_fallback',
            'walker' => new CSS_Menu_Maker_Walker()
            ));
            ?>
       </nav>
       <i class="fal fa-file-search side-icon" aria-hidden="true"></i>
    </div>
    <div id="myCanvasNav" class="overlay3" onclick="closeNav()"></div>
    <!-- mobile menu -->
    <?php wp_footer(); ?>
</body>
</html>